/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.util.async;

import com.solace.messaging.util.internal.Internal;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import org.osgi.annotation.versioning.ProviderType;
import sun.misc.Unsafe;

@Internal
@ProviderType
public class ExtendedCompletableFutureJ8<T>
extends CompletableFuture<T> {
    private static final Unsafe MY_UNSAFE;
    private static final long RESULT_POINTER;
    private static final MethodHandle POST_COMPLETE;
    private static final MethodHandle COMPLETE_THROWABLE;
    private static final MethodHandle COMPLETE_VALUE;

    @Override
    public ExtendedCompletableFutureJ8<T> completeAsync(Supplier<? extends T> supplier, Executor executor) {
        if (supplier == null || executor == null) {
            throw new NullPointerException();
        }
        executor.execute(new AsyncSupply<T>(this, supplier));
        return this;
    }

    static {
        try {
            Unsafe u;
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            MY_UNSAFE = u = (Unsafe)f.get(null);
            Class<CompletableFuture> k = CompletableFuture.class;
            RESULT_POINTER = u.objectFieldOffset(k.getDeclaredField("result"));
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Method postCompleteMethod = k.getDeclaredMethod("postComplete", new Class[0]);
            postCompleteMethod.setAccessible(true);
            POST_COMPLETE = lookup.unreflect(postCompleteMethod);
            Method completeValueMethod = k.getDeclaredMethod("completeValue", Object.class);
            completeValueMethod.setAccessible(true);
            COMPLETE_VALUE = lookup.unreflect(completeValueMethod);
            Method completeThrowableMethod = k.getDeclaredMethod("completeThrowable", Throwable.class);
            completeThrowableMethod.setAccessible(true);
            COMPLETE_THROWABLE = lookup.unreflect(completeThrowableMethod);
        }
        catch (Exception x) {
            throw new Error(x);
        }
    }

    @ProviderType
    static final class AsyncSupply<T>
    implements Runnable,
    CompletableFuture.AsynchronousCompletionTask {
        CompletableFuture<T> dep;
        Supplier<? extends T> fn;

        AsyncSupply(ExtendedCompletableFutureJ8<T> dep, Supplier<? extends T> fn) {
            this.dep = dep;
            this.fn = fn;
        }

        @Override
        public void run() {
            Supplier<T> f;
            CompletableFuture<T> d = this.dep;
            if (d != null && (f = this.fn) != null) {
                this.dep = null;
                this.fn = null;
                try {
                    if (!d.isDone()) {
                        try {
                            COMPLETE_VALUE.invoke(d, f.get());
                        }
                        catch (Throwable ex) {
                            COMPLETE_THROWABLE.invoke(d, ex);
                        }
                    }
                    POST_COMPLETE.invoke(d);
                }
                catch (Throwable t) {
                    d.obtrudeException(t);
                }
            }
        }
    }
}

