/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.config.provider;

import com.solace.messaging.util.Manageable;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.PrivilegedActionUtility;
import com.solacesystems.jcsmp.impl.client.ClientInfoProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class ApiInfoProvider
extends ClientInfoProvider
implements Manageable.ApiInfo {
    private static final long serialVersionUID = -6999649250521972116L;
    private final String apiDate = String.format("JAVA API %s/JCSMP %s", manifestReader.getBuildTime(), super.getSoftwareDate());
    private final String apiVersion = String.format("JAVA API %s/JCSMP %s", manifestReader.getImplVersion(), super.getSoftwareVersion());
    private final String apiImplementationVendor = manifestReader.getImplVendor();
    private static final String dateTemplate = "JAVA API %s/JCSMP %s";
    private static final String versionTemplate = "JAVA API %s/JCSMP %s";
    private static final ManifestReader manifestReader = new ManifestReader();

    protected ApiInfoProvider() {
    }

    @Override
    public String getApiBuildDate() {
        return this.apiDate;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public String getApiUserId() {
        return this.getUserIdExtended();
    }

    @Override
    public String getApiImplementationVendor() {
        return this.apiImplementationVendor;
    }

    public String getSoftwareDate() {
        return this.apiDate;
    }

    public String getSoftwareVersion() {
        return this.apiVersion;
    }

    @Internal
    @ProviderType
    private static final class ManifestReader {
        private static final String API_MANIFEST_SECTION_NAME = "com.solace.messaging";
        private static final Attributes.Name BUILD_TIME = new Attributes.Name("Build-Time");
        private final Map<String, String> manifestContent;
        private static final Log logger = LogFactory.getLog(ManifestReader.class);

        private ManifestReader() {
            block3: {
                this.manifestContent = new HashMap<String, String>();
                ClassLoader cl = PrivilegedActionUtility.getContextClassLoader();
                if (cl != null) {
                    try {
                        Enumeration<URL> manifestResources = cl.getResources("META-INF/MANIFEST.MF");
                        Map<String, String> manifestInfo = ManifestReader.findApiManifest(manifestResources);
                        this.manifestContent.putAll(manifestInfo);
                    }
                    catch (Exception e) {
                        if (!logger.isWarnEnabled()) break block3;
                        logger.warn((Object)"Encountered problem by reading of META-INF/MANIFEST.MF ", (Throwable)e);
                    }
                }
            }
        }

        String getImplVersion() {
            return this.manifestContent.get(Attributes.Name.IMPLEMENTATION_VERSION.toString());
        }

        String getImplVendor() {
            return this.manifestContent.get(Attributes.Name.IMPLEMENTATION_VENDOR.toString());
        }

        String getBuildTime() {
            return this.manifestContent.get(BUILD_TIME.toString());
        }

        String getAttributeValue(String attributeKey) {
            return this.manifestContent.get(attributeKey);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Map<String, String> findApiManifest(Enumeration<URL> allManifests) {
            HashMap<String, String> output = new HashMap<String, String>();
            while (allManifests.hasMoreElements()) {
                URL manifestUrl = allManifests.nextElement();
                try {
                    InputStream manifestStream = manifestUrl.openStream();
                    try {
                        Manifest manifest = new Manifest(manifestStream);
                        Map<String, Attributes> entries = manifest.getEntries();
                        Attributes attributes = entries.get(API_MANIFEST_SECTION_NAME);
                        if (attributes == null || attributes.isEmpty() || !attributes.containsKey(Attributes.Name.IMPLEMENTATION_VERSION) || !attributes.containsKey(Attributes.Name.IMPLEMENTATION_VENDOR) || !attributes.containsKey(BUILD_TIME)) continue;
                        output.put(Attributes.Name.IMPLEMENTATION_VERSION.toString(), attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION));
                        output.put(Attributes.Name.IMPLEMENTATION_VENDOR.toString(), attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR));
                        output.put(BUILD_TIME.toString(), attributes.getValue(BUILD_TIME));
                        Attributes attrs = manifest.getMainAttributes();
                        for (Object key : attrs.keySet()) {
                            String value = attrs.getValue((Attributes.Name)Attributes.Name.class.cast(key));
                            output.put(key.toString(), value);
                        }
                        break;
                    }
                    finally {
                        if (manifestStream == null) continue;
                        try {
                            manifestStream.close();
                        }
                        catch (IOException e) {
                            if (!logger.isWarnEnabled()) continue;
                            logger.warn((Object)"Encountered problem by closing META-INF/MANIFEST.MF file stream", (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn((Object)"Encountered problem by reading META-INF/MANIFEST.MF file stream", (Throwable)e);
                }
            }
            output.computeIfAbsent(BUILD_TIME.toString(), k -> "--");
            output.computeIfAbsent(Attributes.Name.IMPLEMENTATION_VERSION.toString(), k -> "--");
            output.computeIfAbsent(Attributes.Name.IMPLEMENTATION_VENDOR.toString(), k -> "--");
            return output;
        }
    }
}

