/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging;

import com.solace.messaging.DirectMessagePublisherBuilder;
import com.solace.messaging.DirectMessageReceiverBuilder;
import com.solace.messaging.MessageQueueBrowserBuilder;
import com.solace.messaging.MessagingService;
import com.solace.messaging.MessagingServiceClientBuilder$OutboundMessageBuilderImpl$;
import com.solace.messaging.PersistentMessagePublisherBuilder;
import com.solace.messaging.PersistentMessageReceiverBuilder;
import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.RequestReplyMessagePublisherBuilder;
import com.solace.messaging.RequestReplyMessageReceiverBuilder;
import com.solace.messaging.config.AuthenticationConfiguration;
import com.solace.messaging.config.AuthenticationStrategy;
import com.solace.messaging.config.CustomServiceConfiguration;
import com.solace.messaging.config.DeclarativeServiceConfiguration;
import com.solace.messaging.config.LocalServiceConfiguration;
import com.solace.messaging.config.RetryStrategy;
import com.solace.messaging.config.TransportProtocolConfiguration;
import com.solace.messaging.config.TransportSecurityStrategy;
import com.solace.messaging.config.TypedConfiguration;
import com.solace.messaging.config.profile.ConfigurationProfile;
import com.solace.messaging.config.profile.SolaceSessionConfiguration;
import com.solace.messaging.config.provider.CompressionConfigurationProvider;
import com.solace.messaging.config.provider.LocalConfigurationProvider;
import com.solace.messaging.config.provider.ServiceConfigurationProvider;
import com.solace.messaging.config.provider.ServicePropertiesConfigurationProvider;
import com.solace.messaging.config.provider.ServicePropertiesConverter;
import com.solace.messaging.publisher.OutboundMessageBuilder;
import com.solace.messaging.util.CompletionListener;
import com.solace.messaging.util.Identifiable;
import com.solace.messaging.util.Manageable;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.async.ExtendedCompletableFuture;
import com.solace.messaging.util.internal.ApiMetricsCollectorImpl;
import com.solace.messaging.util.internal.ClientSession;
import com.solace.messaging.util.internal.ClientSessionImpl;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.MessagingServiceInternalView;
import com.solace.messaging.util.internal.SolaceStatsMetricsConverter;
import com.solace.messaging.util.internal.Validation;
import com.solacesystems.common.util.StringUtil;
import com.solacesystems.jcsmp.BytesXMLMessage;
import com.solacesystems.jcsmp.Consumer;
import com.solacesystems.jcsmp.Context;
import com.solacesystems.jcsmp.InvalidPropertiesException;
import com.solacesystems.jcsmp.JCSMPException;
import com.solacesystems.jcsmp.JCSMPStats;
import com.solacesystems.jcsmp.XMLMessageListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicStampedReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class MessagingServiceClientBuilder
implements LocalServiceConfiguration,
CustomServiceConfiguration,
DeclarativeServiceConfiguration,
TransportProtocolConfiguration,
AuthenticationConfiguration {
    private final ConfigurationProfile activeProfile;
    private final List<TypedConfiguration> configProviders;
    private static final Log logger = LogFactory.getLog(MessagingServiceClientBuilder.class);

    MessagingServiceClientBuilder(ConfigurationProfile activeProfile) {
        this.activeProfile = activeProfile;
        this.configProviders = new CopyOnWriteArrayList<TypedConfiguration>();
    }

    public MessagingService build() throws PubSubPlusClientException {
        try {
            return new BasicMessagingServiceImpl(this.activeProfile, this.composeConfiguration());
        }
        catch (InvalidPropertiesException e) {
            throw new PubSubPlusClientException.InvalidConfigurationException(e);
        }
    }

    public MessagingService build(String clientName) throws PubSubPlusClientException {
        try {
            return new BasicMessagingServiceImpl(this.activeProfile, this.composeConfiguration(), clientName);
        }
        catch (InvalidPropertiesException e) {
            throw new PubSubPlusClientException.InvalidConfigurationException(e);
        }
    }

    @Override
    public MessagingServiceClientBuilder withAuthenticationStrategy(AuthenticationStrategy authenticationProvider) {
        this.configProviders.add(authenticationProvider);
        return this;
    }

    @Override
    public MessagingServiceClientBuilder withTransportSecurityStrategy(TransportSecurityStrategy transportLayerSecurityStrategy) {
        this.configProviders.add(transportLayerSecurityStrategy);
        return this;
    }

    @Override
    public MessagingServiceClientBuilder withMessageCompression(int compressionFactor) {
        Validation.outOfRangeIllegal(1, 9, compressionFactor, "Compression factor is out of valid range between 1 and 9");
        this.configProviders.add(CompressionConfigurationProvider.of(compressionFactor));
        return this;
    }

    @Override
    public MessagingServiceClientBuilder withReconnectionRetryStrategy(RetryStrategy strategy) {
        Validation.nullIllegal(strategy, "'null' is an illegal RetryStrategy value.");
        this.configProviders.add(RetryStrategy.RetryConfigurationProvider.toReconnectionConfiguration(strategy));
        return this;
    }

    @Override
    public MessagingServiceClientBuilder withConnectionRetryStrategy(RetryStrategy strategy) {
        Validation.nullIllegal(strategy, "'null' is an illegal RetryStrategy value.");
        this.configProviders.add(RetryStrategy.RetryConfigurationProvider.toConnectionConfiguration(strategy));
        return this;
    }

    @Override
    public MessagingServiceClientBuilder local() {
        this.configProviders.add(LocalConfigurationProvider.of());
        return this;
    }

    @Override
    public MessagingServiceClientBuilder local(int port) {
        this.configProviders.add(LocalConfigurationProvider.of(port));
        return this;
    }

    @Override
    public MessagingServiceClientBuilder localTLS() {
        this.configProviders.add(LocalConfigurationProvider.ofSecure());
        return this;
    }

    @Override
    public MessagingServiceClientBuilder localTLS(int port) {
        this.configProviders.add(LocalConfigurationProvider.ofSecure(port));
        return this;
    }

    @Override
    public MessagingServiceClientBuilder localTLS(String vpnName, int port) {
        this.configProviders.add(LocalConfigurationProvider.ofSecure(port, vpnName));
        return this;
    }

    @Override
    public MessagingServiceClientBuilder local(String vpnName, int port) {
        this.configProviders.add(LocalConfigurationProvider.of(port, vpnName));
        return this;
    }

    @Override
    public MessagingServiceClientBuilder fromProperties(Properties properties) {
        this.configProviders.add(ServicePropertiesConfigurationProvider.of(properties));
        return this;
    }

    @Override
    public MessagingServiceClientBuilder fromConfigurationProvider(ServiceConfigurationProvider configProvider) {
        this.configProviders.add(configProvider);
        return this;
    }

    private SolaceSessionConfiguration composeConfiguration() {
        SolaceSessionConfiguration serviceConfiguration = this.activeProfile.getConfigurationObjectFactory().createSolaceSessionConfiguration();
        this.configProviders.forEach(configProvider -> {
            TypedProperties typedConfigurationFromConfigProvider = configProvider.getConfiguration();
            ServicePropertiesConverter.mergeAndPostProcessProperties(typedConfigurationFromConfigProvider, serviceConfiguration);
        });
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Final configuration for the messaging service is composed: " + (Object)((Object)serviceConfiguration)));
        }
        return serviceConfiguration;
    }

    @Internal
    @ProviderType
    static class RequestReplyMessagingServiceImpl
    implements MessagingService.RequestReplyMessagingService {
        private final MessagingServiceInternalView messagingServiceInternalView;

        RequestReplyMessagingServiceImpl(MessagingServiceInternalView messagingServiceInternalView) {
            this.messagingServiceInternalView = messagingServiceInternalView;
        }

        @Override
        public RequestReplyMessageReceiverBuilder createRequestReplyMessageReceiverBuilder() {
            return new RequestReplyMessageReceiverBuilder.RequestReplyMessageReceiverBuilderImpl(this.messagingServiceInternalView);
        }

        @Override
        public RequestReplyMessagePublisherBuilder createRequestReplyMessagePublisherBuilder() {
            return new RequestReplyMessagePublisherBuilder.RequestReplyMessagePublisherBuilderImpl(this.messagingServiceInternalView);
        }
    }

    @Internal
    @ProviderType
    static class DefaultClientSessionBuilder
    extends ClientSessionBuilder {
        DefaultClientSessionBuilder(SolaceSessionConfiguration properties) {
            this(properties, null, false);
        }

        DefaultClientSessionBuilder(SolaceSessionConfiguration properties, Context context) {
            this(properties, context, false);
        }

        DefaultClientSessionBuilder(SolaceSessionConfiguration properties, Context context, boolean allowSharedClientId) {
            super(properties, context, allowSharedClientId);
        }

        @Override
        ClientSession build() throws InvalidPropertiesException {
            return ClientSessionImpl.createInstance(this.properties, this.context, this.allowSharedClientId);
        }
    }

    @ProviderType
    static abstract class ClientSessionBuilder {
        final SolaceSessionConfiguration properties;
        final Context context;
        final boolean allowSharedClientId;

        ClientSessionBuilder(SolaceSessionConfiguration properties, Context context, boolean allowSharedClientId) {
            this.properties = properties;
            this.context = context;
            this.allowSharedClientId = allowSharedClientId;
        }

        abstract ClientSession build() throws InvalidPropertiesException;
    }

    @Internal
    @ProviderType
    private static final class ApiMetricsImpl
    implements Manageable.ApiMetricsCollector {
        static final int PADDING = 44;
        final ClientSession clientSession;
        final Manageable.ApiMetricsCollector ngCollectorDelegate = new ApiMetricsCollectorImpl();

        private ApiMetricsImpl(ClientSession clientSession) {
            this.clientSession = clientSession;
        }

        @Override
        public long getValue(Manageable.ApiMetrics.Metric theMetric) {
            return SolaceStatsMetricsConverter.getFromSolaceStats((JCSMPStats)this.clientSession.getSessionStats(), this.ngCollectorDelegate, theMetric);
        }

        @Override
        public void incrementMetric(Manageable.ApiMetrics.Metric metric) {
            this.ngCollectorDelegate.incrementMetric(metric);
        }

        @Override
        public void increaseMetric(Manageable.ApiMetrics.Metric metric, long delta) {
            this.ngCollectorDelegate.increaseMetric(metric, delta);
        }

        @Override
        public void reset() {
            this.clientSession.getSessionStats().resetStats();
            this.ngCollectorDelegate.reset();
        }

        @Override
        public String toString() {
            Manageable.ApiMetrics.Metric[] allMetrics = Manageable.ApiMetrics.Metric.values();
            StringBuilder sb = new StringBuilder();
            for (Manageable.ApiMetrics.Metric m : allMetrics) {
                sb.append(StringUtil.padLeft((String)m.name(), (int)44));
                sb.append(": ");
                sb.append(this.getValue(m));
                sb.append("\n");
            }
            return sb.toString();
        }
    }

    @Internal
    @ProviderType
    static class BasicMessagingServiceImpl
    implements MessagingService,
    MessagingServiceInternalView,
    Identifiable {
        private static final Log logger = LogFactory.getLog(BasicMessagingServiceImpl.class);
        private static final AtomicLong instanceIdGenerator = new AtomicLong(0L);
        static final int STATE_NOT_CONNECTED = 0;
        static final int STATE_CONNECTING = 1;
        static final int STATE_CONNECTED = 2;
        static final int STATE_TERMINATING = 3;
        static final int STATE_TERMINATED = 4;
        private final String clientName;
        private final ConfigurationProfile activeProfile;
        private final ClientSession clientSession;
        final AtomicStampedReference<CompletableFuture> stateHolder = new AtomicStampedReference<Object>(null, 0);
        private final MessagingService.ServiceInterruptionListener serviceInterruptionListener;
        private final XMLMessageListener noOpMessageListener;
        private final ApiMetricsImpl apiMetrics;
        private final long id = instanceIdGenerator.incrementAndGet();
        private final String instanceName = "MessagingServiceImpl@" + this.id;
        private volatile Consumer defaultNoOpConsumer;
        private final SolaceSessionConfiguration jcsmpConfiguration;
        private static final List<String> modifiableSolaceProperties = new ArrayList<String>();

        BasicMessagingServiceImpl(ConfigurationProfile activeProfile, SolaceSessionConfiguration jcsmpConfiguration) throws InvalidPropertiesException {
            this(activeProfile, jcsmpConfiguration, null);
        }

        BasicMessagingServiceImpl(ConfigurationProfile activeProfile, SolaceSessionConfiguration jcsmpConfiguration, String clientName) throws InvalidPropertiesException {
            this(activeProfile, new DefaultClientSessionBuilder(jcsmpConfiguration), jcsmpConfiguration, clientName);
        }

        BasicMessagingServiceImpl(ConfigurationProfile activeProfile, ClientSessionBuilder sessionBuilder, SolaceSessionConfiguration jcsmpConfiguration, String clientName) throws InvalidPropertiesException {
            this.activeProfile = activeProfile;
            this.jcsmpConfiguration = jcsmpConfiguration;
            if (clientName != null && !clientName.isEmpty()) {
                sessionBuilder.properties.setProperty("client_name", clientName);
            }
            this.serviceInterruptionListener = new MessagingService.ServiceInterruptionListener(){

                @Override
                public void onServiceInterrupted(MessagingService.ServiceEvent e) {
                    stateHolder.set(null, 4);
                    this.onTerminate();
                }
            };
            this.clientSession = sessionBuilder.build();
            this.clientName = (String)this.clientSession.getProperty("client_name");
            this.clientSession.addServiceInterruptionListener(this.serviceInterruptionListener);
            this.noOpMessageListener = new XMLMessageListener(){

                public void onReceive(BytesXMLMessage message) {
                }

                public void onException(JCSMPException exception) {
                }
            };
            this.apiMetrics = new ApiMetricsImpl(this.clientSession);
        }

        public String toString() {
            return "BasicMessagingServiceImpl{clientName='" + this.clientName + '\'' + ", connected=" + this.isConnected() + '}';
        }

        @Override
        public MessagingService addReconnectionListener(MessagingService.ReconnectionListener listener) {
            this.clientSession.addReconnectionListener(listener);
            return this;
        }

        @Override
        public MessagingService removeReconnectionListener(MessagingService.ReconnectionListener listener) {
            this.clientSession.removeReconnectionListener(listener);
            return this;
        }

        @Override
        public MessagingService addReconnectionAttemptListener(MessagingService.ReconnectionAttemptListener listener) {
            this.clientSession.addReconnectionAttemptListener(listener);
            return this;
        }

        @Override
        public MessagingService removeReconnectionAttemptListener(MessagingService.ReconnectionAttemptListener listener) {
            this.clientSession.removeReconnectionAttemptListener(listener);
            return this;
        }

        @Override
        public MessagingService connect() throws PubSubPlusClientException {
            try {
                this.connectAsync().get();
            }
            catch (ExecutionException e) {
                Throwable t = e.getCause();
                if (t != null) {
                    if (t instanceof PubSubPlusClientException) {
                        throw (PubSubPlusClientException)t;
                    }
                    if (t instanceof IllegalStateException) {
                        throw (IllegalStateException)t;
                    }
                    throw new PubSubPlusClientException(t);
                }
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)(this.instanceName + " failed to start"), (Throwable)e);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new PubSubPlusClientException.RequestInterruptedException("Connection creation was canceled", e);
            }
            catch (CancellationException e) {
                throw new PubSubPlusClientException.RequestInterruptedException("Connection creation was canceled", e);
            }
            return this;
        }

        @Override
        public boolean isConnected() {
            return 2 == this.stateHolder.getStamp();
        }

        @Override
        public void disconnect() throws PubSubPlusClientException {
            block7: {
                try {
                    this.disconnectAsync().get();
                }
                catch (ExecutionException e) {
                    Throwable t = e.getCause();
                    if (t != null) {
                        if (t instanceof PubSubPlusClientException) {
                            throw (PubSubPlusClientException)t;
                        }
                        throw new PubSubPlusClientException(t);
                    }
                    if (logger.isWarnEnabled()) {
                        logger.warn((Object)(this.instanceName + " failed to disconnect"), (Throwable)e);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new PubSubPlusClientException.RequestInterruptedException("Disconnection from a messaging broker was interrupted", e);
                }
                catch (Exception e) {
                    if (!logger.isWarnEnabled()) break block7;
                    logger.warn((Object)(this.instanceName + " encountered problem during disconnection."), (Throwable)e);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public <MessagingService> CompletableFuture<MessagingService> connectAsync() throws PubSubPlusClientException {
            int state = this.stateHolder.getStamp();
            if (3 == state || state == 4) {
                throw new IllegalStateException("MessagingService client is already closed");
            }
            block6: while (true) {
                int[] currentStateHolder = new int[1];
                CompletableFuture currentFuture = this.stateHolder.get(currentStateHolder);
                int currentState = currentStateHolder[0];
                switch (currentState) {
                    case 0: {
                        ExtendedCompletableFuture<BasicMessagingServiceImpl> connecting;
                        boolean stateChanged;
                        if (!(stateChanged = this.stateHolder.compareAndSet(null, connecting = new ExtendedCompletableFuture<BasicMessagingServiceImpl>(), 0, 1))) continue block6;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)(this.instanceName + " is being connected"));
                        }
                        try {
                            int newCurrentState;
                            this.onConnect();
                            boolean connectingToConnected = this.stateHolder.compareAndSet(connecting, connecting, 1, 2);
                            if (!connectingToConnected && (newCurrentState = this.stateHolder.getStamp()) >= 3) {
                                this.onTerminate();
                                connecting.completeExceptionally(new CancellationException("Connection to the messaging broker was interrupted"));
                                return connecting;
                            }
                            connecting.complete(this);
                            if (!logger.isDebugEnabled()) return ExtendedCompletableFuture.onCancellation(connecting, (service, throwable) -> {
                                this.stateHolder.set(null, 4);
                                this.onTerminate();
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)(this.instanceName + " async connection was canceled"));
                                }
                            });
                            logger.debug((Object)(this.instanceName + " is connected"));
                            return ExtendedCompletableFuture.onCancellation(connecting, (service, throwable) -> {
                                this.stateHolder.set(null, 4);
                                this.onTerminate();
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)(this.instanceName + " async connection was canceled"));
                                }
                            });
                        }
                        catch (Exception e) {
                            this.stateHolder.set(null, 4);
                            this.onTerminate();
                            connecting.completeExceptionally(PubSubPlusClientException.of(e));
                            if (!logger.isErrorEnabled()) return ExtendedCompletableFuture.onCancellation(connecting, (service, throwable) -> {
                                this.stateHolder.set(null, 4);
                                this.onTerminate();
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)(this.instanceName + " async connection was canceled"));
                                }
                            });
                            logger.error((Object)(this.instanceName + " failed to connect and is disconnecting"), (Throwable)e);
                        }
                        return ExtendedCompletableFuture.onCancellation(connecting, (service, throwable) -> {
                            this.stateHolder.set(null, 4);
                            this.onTerminate();
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)(this.instanceName + " async connection was canceled"));
                            }
                        });
                    }
                    case 1: 
                    case 2: {
                        return currentFuture;
                    }
                }
                break;
            }
            return ExtendedCompletableFuture.failedFuture(new IllegalStateException("MessagingService client is already closed"));
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public CompletableFuture<Void> disconnectAsync() throws PubSubPlusClientException {
            block5: while (true) {
                currentStateHolder = new int[1];
                currentFuture = this.stateHolder.get(currentStateHolder);
                currentState = currentStateHolder[0];
                switch (currentState) {
                    case 0: {
                        stateChanged = this.stateHolder.compareAndSet(null, null, 0, 4);
                        if (!stateChanged) continue block5;
                        return CompletableFuture.completedFuture(null);
                    }
                    case 1: {
                        this.stateHolder.set(null, 4);
                        currentFuture.cancel(true);
                        return CompletableFuture.completedFuture(null);
                    }
                    case 2: {
                        terminating = new ExtendedCompletableFuture<Void>();
                        stateChanged = this.stateHolder.compareAndSet(currentFuture, terminating, 2, 3);
                        if (stateChanged) ** break;
                        continue block5;
                        this.stateHolder.set(null, 4);
                        this.onTerminate();
                        terminating.complete(null);
                        return terminating;
                    }
                }
                break;
            }
            return CompletableFuture.completedFuture(null);
        }

        void onConnect() throws JCSMPException {
            this.clientSession.connect();
            this.defaultNoOpConsumer = this.clientSession.getMessageConsumer(this.noOpMessageListener);
        }

        void onTerminate() {
            try {
                if (!this.clientSession.isClosed()) {
                    this.clientSession.closeSession();
                }
            }
            catch (Exception ex) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)(this.instanceName + "  encountered problem closing session during termination."), (Throwable)ex);
                }
            }
            finally {
                this.clientSession.removeServiceInterruptionListener(this.serviceInterruptionListener);
                this.defaultNoOpConsumer = null;
            }
        }

        @Override
        public <MessagingService> void connectAsync(CompletionListener<MessagingService> connectionListener) throws PubSubPlusClientException {
            Validation.nullIllegal(connectionListener, "Connection listener can't be null");
            CompletableFuture<MessagingService> onceConnected = this.connectAsync();
            onceConnected.whenComplete((messagingService, throwable) -> {
                block2: {
                    try {
                        connectionListener.onCompletion(messagingService, throwable == null ? null : throwable.getCause());
                    }
                    catch (Exception e) {
                        if (!logger.isErrorEnabled()) break block2;
                        logger.error((Object)(this.instanceName + " failed to connect"), (Throwable)e);
                    }
                }
            });
        }

        @Override
        public void disconnectAsync(CompletionListener<Void> disconnectionListener) throws PubSubPlusClientException {
            Validation.nullIllegal(disconnectionListener, "Disconnection listener can't be null");
            CompletableFuture<Void> onceDisconnected = this.disconnectAsync();
            onceDisconnected.whenComplete((nothing, throwable) -> {
                block2: {
                    try {
                        disconnectionListener.onCompletion(null, throwable == null ? null : throwable.getCause());
                    }
                    catch (Exception e) {
                        if (!logger.isWarnEnabled()) break block2;
                        logger.warn((Object)(this.instanceName + "  encountered problem during disconnection."), (Throwable)e);
                    }
                }
            });
        }

        @Override
        public DirectMessageReceiverBuilder createDirectMessageReceiverBuilder() {
            return new DirectMessageReceiverBuilder.DirectMessageReceiverBuilderImpl(this);
        }

        @Override
        public DirectMessagePublisherBuilder createDirectMessagePublisherBuilder() {
            return new DirectMessagePublisherBuilder.DirectMessagePublisherBuilderImpl(this.messageBuilder(), this);
        }

        @Override
        public PersistentMessageReceiverBuilder createPersistentMessageReceiverBuilder() {
            return new PersistentMessageReceiverBuilder.PersistentMessageReceiverBuilderImpl(this);
        }

        @Override
        public PersistentMessagePublisherBuilder createPersistentMessagePublisherBuilder() {
            Integer ackWindowSize;
            Properties takenOverFromSession = new Properties();
            SolaceSessionConfiguration sessionDefaults = this.activeProfile.getConfigurationObjectFactory().createSolaceSessionConfiguration();
            Boolean generateSendTimestamps = this.jcsmpConfiguration.getBooleanProperty("generate_send_timestamps");
            if (generateSendTimestamps != null && !generateSendTimestamps.equals(sessionDefaults.getBooleanProperty("generate_send_timestamps"))) {
                takenOverFromSession.setProperty("solace.messaging.service.generate-send-timestamps", generateSendTimestamps.toString());
            }
            if ((ackWindowSize = this.jcsmpConfiguration.getIntegerProperty("pub_ack_window_size")) != null && !ackWindowSize.equals(sessionDefaults.getIntegerProperty("pub_ack_window_size"))) {
                takenOverFromSession.setProperty("solace.messaging.service.publishers.persistent.ack-window-size", ackWindowSize.toString());
            }
            return new PersistentMessagePublisherBuilder.PersistentMessagePublisherBuilderImpl(this.messageBuilder(), this, takenOverFromSession);
        }

        @Override
        public MessageQueueBrowserBuilder createMessageQueueBrowserBuilder() {
            return new MessageQueueBrowserBuilder.MessageQueueBrowserBuilderImpl(this);
        }

        @Override
        public MessagingService.RequestReplyMessagingService requestReply() {
            return new RequestReplyMessagingServiceImpl(this);
        }

        @Override
        public OutboundMessageBuilder messageBuilder() {
            return new MessagingServiceClientBuilder$OutboundMessageBuilderImpl$(this.activeProfile, null);
        }

        @Override
        public String getApplicationId() {
            return this.getClientName();
        }

        @Override
        public String getClientName() {
            return this.clientName;
        }

        @Override
        public void updateProperty(String property, Object value) throws PubSubPlusClientException {
            if (!this.isConnected()) {
                throw new IllegalStateException("MessagingService client is not connected");
            }
            if (!modifiableSolaceProperties.contains(property)) {
                throw new IllegalArgumentException(String.format("Property '%s' is not a modifiable property.", property));
            }
            String internalSolacePropertyName = ServicePropertiesConverter.getInternalSolacePropertyName(property);
            if (internalSolacePropertyName == null) {
                throw new IllegalArgumentException(String.format("Property '%s' is not updated due to internal error.", property));
            }
            try {
                this.clientSession.setProperty(internalSolacePropertyName, value);
            }
            catch (JCSMPException e) {
                throw new PubSubPlusClientException(String.format("Failed to update property %s", property), e);
            }
        }

        @Override
        public ClientSession getClientSession() {
            return this.clientSession;
        }

        @Override
        public void enableConsumerAPI() throws IllegalStateException, PubSubPlusClientException {
            if (this.defaultNoOpConsumer == null) {
                throw new IllegalStateException("Default consumer can't be started before session is connected");
            }
            try {
                this.defaultNoOpConsumer.start();
            }
            catch (JCSMPException e) {
                throw new PubSubPlusClientException(e);
            }
        }

        @Override
        public void disableConsumerAPI() throws IllegalStateException {
            if (this.defaultNoOpConsumer == null) {
                throw new IllegalStateException("Default consumer can't be started before session is connected");
            }
            this.defaultNoOpConsumer.stop();
        }

        @Override
        public ConfigurationProfile getActiveProfile() {
            return this.activeProfile;
        }

        @Override
        public Manageable.ApiMetricsCollector getApiMetricsCollector() {
            return this.apiMetrics;
        }

        @Override
        public Manageable.ApiMetrics metrics() {
            return this.apiMetrics;
        }

        @Override
        public Manageable.ApiInfo info() {
            return this.activeProfile.getConfigurationObjectFactory().getApiInfoProvider();
        }

        @Override
        public void addServiceInterruptionListener(MessagingService.ServiceInterruptionListener l) {
            this.clientSession.addServiceInterruptionListener(l);
        }

        @Override
        public boolean removeServiceInterruptionListener(MessagingService.ServiceInterruptionListener l) {
            return this.clientSession.removeServiceInterruptionListener(l);
        }

        @Override
        public long getId() {
            return this.id;
        }

        static {
            modifiableSolaceProperties.add("solace.messaging.authentication.oauth2.access-token");
            modifiableSolaceProperties.add("solace.messaging.authentication.oauth2.oidc-id-token");
        }
    }
}

