/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.util.internal;

import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.SolaceMessageUtil;
import com.solace.messaging.util.internal.Validation;
import com.solacesystems.jcsmp.SDTException;
import com.solacesystems.jcsmp.SDTMap;
import com.solacesystems.jcsmp.XMLMessage;
import com.solacesystems.jcsmp.impl.JCSMPGenericXMLMessage;
import com.solacesystems.jcsmp.impl.sdt.MapImpl;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class OutboundMessageTemplate
extends JCSMPGenericXMLMessage {
    private final int maxContentLength;

    @Internal
    protected OutboundMessageTemplate(int maxContentLength, boolean withDirectBuffers) {
        super(maxContentLength, withDirectBuffers, true);
        this.maxContentLength = maxContentLength;
    }

    public void setProperty(String key, String value) {
        if (null == this.getProperties()) {
            this.setProperties((SDTMap)new MapImpl());
        }
        try {
            this.getProperties().putString(key, value);
        }
        catch (SDTException sDTException) {
            // empty catch block
        }
    }

    public void setProperties(TypedProperties.ConfigurationProperties configurationProperties) {
        SolaceMessageUtil.addPropertiesToMessage((XMLMessage)this, configurationProperties);
    }

    public static OutboundMessageTemplate copyTemplate(OutboundMessageTemplate template) {
        Validation.nullIllegal(template, "'null' is an illegal template value.");
        OutboundMessageTemplate copy = new OutboundMessageTemplate(template.maxContentLength, template.useDirectBuffer);
        copy.setElidingEligible(template.isElidingEligible());
        copy.setDeliveryMode(template.getDeliveryMode());
        copy.setPriority(template.getPriority());
        copy.setSenderId(template.getSenderId());
        copy.setCos(template.getCos());
        copy.setTimeToLive(template.getTimeToLive());
        copy.setExpiration(template.getExpiration());
        copy.setDMQEligible(template.isDMQEligible());
        copy.setAckImmediately(template.isAckImmediately());
        copy.setHTTPContentEncoding(template.getHTTPContentEncoding());
        copy.setHTTPContentType(template.getHTTPContentType());
        copy.setReplyTo(template.getReplyTo());
        copy.setApplicationMessageType(template.getApplicationMessageType());
        if (template.getSequenceNumber() != null) {
            copy.setSequenceNumber(template.getSequenceNumber());
        }
        copy.setProperties(template.getProperties());
        return copy;
    }
}

