/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.util.async;

import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.util.async.ToggleLatch;
import com.solace.messaging.util.internal.Internal;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class DiscardOldestConcurrentBuffer<T> {
    private final LinkedBlockingQueue<T> queue;
    private final AtomicBoolean dropped = new AtomicBoolean(false);
    final ReentrantLock lock = new ReentrantLock();
    private volatile boolean inAwaitEmpty = false;
    private final ToggleLatch emptyLatch = new ToggleLatch();

    public DiscardOldestConcurrentBuffer(int capacity) {
        this.queue = new LinkedBlockingQueue(capacity);
        this.emptyLatch.open();
    }

    public int remainingCapacity() {
        return this.queue.remainingCapacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void add(T nexEntry) throws PubSubPlusClientException.RequestInterruptedException {
        if (nexEntry == null) {
            return;
        }
        inserted = this.queue.offer(nexEntry);
        if (inserted) {
            return;
        }
        l = this.lock;
        try {
            l.lockInterruptibly();
            do lbl-1000:
            // 3 sources

            {
                if ((droppedHead = this.queue.poll()) == null) continue;
                this.dropped.set(true);
                reinserted = this.queue.offer(nexEntry);
                if (!reinserted) ** GOTO lbl-1000
                return;
            } while (!(reinserted = this.queue.offer(nexEntry)));
            return;
        }
        catch (InterruptedException ignore) {
            return;
        }
        finally {
            l.unlock();
        }
    }

    public boolean remove(T t) {
        if (t == null) {
            return false;
        }
        boolean removed = this.queue.remove(t);
        if (removed && this.inAwaitEmpty && this.queue.isEmpty()) {
            this.emptyLatch.open();
        }
        return removed;
    }

    public T take() throws PubSubPlusClientException.RequestInterruptedException {
        try {
            T t = this.queue.take();
            return t;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PubSubPlusClientException.RequestInterruptedException("Consume operation was interrupted", e);
        }
        finally {
            if (this.inAwaitEmpty && this.queue.isEmpty()) {
                this.emptyLatch.open();
            }
        }
    }

    public T poll(long timeout, TimeUnit unit) throws PubSubPlusClientException.RequestInterruptedException {
        try {
            T t = this.queue.poll(timeout, unit);
            return t;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PubSubPlusClientException.RequestInterruptedException("Consume operation was interrupted", e);
        }
        finally {
            if (this.inAwaitEmpty && this.queue.isEmpty()) {
                this.emptyLatch.open();
            }
        }
    }

    public T pollOrNull() {
        try {
            T t = this.queue.poll();
            return t;
        }
        finally {
            if (this.inAwaitEmpty && this.queue.isEmpty()) {
                this.emptyLatch.open();
            }
        }
    }

    /*
     * Loose catch block
     */
    public boolean awaitEmpty(long timeout, TimeUnit unit) {
        if (this.queue.isEmpty()) {
            return true;
        }
        try {
            boolean bl;
            this.inAwaitEmpty = true;
            long nanoTimeout = unit.toNanos(timeout);
            try {
                boolean turnedEmpty = this.queue.isEmpty();
                if (turnedEmpty) {
                    boolean bl2 = true;
                    return bl2;
                }
                this.emptyLatch.lock();
                bl = this.emptyLatch.await(nanoTimeout, TimeUnit.NANOSECONDS) && this.queue.isEmpty();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new PubSubPlusClientException.RequestInterruptedException("AwaitEmpty on DiscardOldestConcurrentBuffer was interrupted", e);
            }
            finally {
                this.emptyLatch.open();
            }
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.inAwaitEmpty = false;
        }
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public int size() {
        return this.queue.size();
    }

    public void clear() {
        this.queue.clear();
        this.emptyLatch.open();
        this.inAwaitEmpty = false;
    }
}

