/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.publisher;

import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.publisher.OutboundMessage;
import com.solace.messaging.resources.Destination;
import com.solace.messaging.resources.Topic;
import com.solace.messaging.util.Manageable;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.async.ToggleLatch;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.Validation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public interface PublisherBuffers {
    public static PublisherBuffer<Topic> createBuffer(TypedProperties publisherConfiguration, Manageable.ApiMetricsCollector metricsCollector) throws IllegalArgumentException {
        String strategy = publisherConfiguration.getProperty("solace.messaging.publisher.back-pressure.strategy");
        if (strategy == null) {
            return new ElasticPublisherBuffer<Topic>();
        }
        int capacity = -1;
        switch (strategy) {
            case "BUFFER_REJECT_WHEN_FULL": {
                try {
                    capacity = publisherConfiguration.getIntegerProperty("solace.messaging.publisher.back-pressure.buffer-capacity");
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Can't create capacity bonded buffer without capacity");
                }
                Validation.smallerThanNumbersIllegal(1, capacity, "Can't create capacity bonded buffer with capacity less 1");
                return new RejectingPublisherBuffer<Topic>(capacity, metricsCollector);
            }
            case "BUFFER_WAIT_WHEN_FULL": {
                try {
                    capacity = publisherConfiguration.getIntegerProperty("solace.messaging.publisher.back-pressure.buffer-capacity");
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Can't create capacity bonded buffer without capacity");
                }
                Validation.smallerThanNumbersIllegal(1, capacity, "Can't create capacity bonded buffer with capacity less 1");
                return new BlockingPublisherBuffer<Topic>(capacity);
            }
        }
        return new ElasticPublisherBuffer<Topic>();
    }

    @Internal
    @ProviderType
    public static interface BufferCongestionMonitor {
        public void onCongestionRelease(int var1);

        public boolean isActive();
    }

    @Internal
    @ProviderType
    public static class RejectingPublisherBuffer<RESOURCE extends Destination>
    implements PublisherBuffer<RESOURCE> {
        private final LinkedBlockingQueue<Publishable<RESOURCE>> queue;
        private volatile boolean inAwaitEmpty = false;
        private final AtomicBoolean full = new AtomicBoolean(false);
        private final ToggleLatch emptyLatch = new ToggleLatch();
        private volatile BufferCongestionMonitor congestionMonitor = null;
        private volatile int notificationThreshold = 1;
        private final int capacity;
        private volatile boolean closed = false;
        private final Manageable.ApiMetricsCollector metricsCollector;

        public RejectingPublisherBuffer(int capacity, Manageable.ApiMetricsCollector metricsCollector) {
            this.queue = new LinkedBlockingQueue(capacity);
            this.emptyLatch.open();
            this.capacity = capacity;
            this.metricsCollector = metricsCollector;
        }

        @Override
        public int remainingCapacity() {
            return this.queue.remainingCapacity();
        }

        @Override
        public int capacity() {
            return this.capacity;
        }

        @Override
        public void insert(Publishable<RESOURCE> publishable) throws PubSubPlusClientException.PublisherOverflowException, PubSubPlusClientException.RequestInterruptedException {
            if (this.closed) {
                return;
            }
            boolean inserted = this.queue.offer(publishable);
            if (!inserted) {
                this.full.set(true);
                if (this.metricsCollector != null) {
                    this.metricsCollector.incrementMetric(Manageable.ApiMetrics.Metric.PUBLISH_MESSAGES_BACKPRESSURE_DISCARDED);
                }
                throw new PubSubPlusClientException.PublisherOverflowException("Buffer full");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Publishable<RESOURCE> consume() {
            if (this.closed) {
                return null;
            }
            try {
                Publishable<RESOURCE> r = this.queue.take();
                if (Publishable.none() != r) {
                    Publishable<RESOURCE> publishable = r;
                    return publishable;
                }
                Publishable<RESOURCE> publishable = null;
                return publishable;
            }
            catch (InterruptedException ignored) {
                Publishable<RESOURCE> publishable = null;
                return publishable;
            }
            finally {
                int remainingCapacity;
                if (this.inAwaitEmpty && this.queue.isEmpty()) {
                    this.emptyLatch.open();
                }
                if (!this.closed && this.congestionMonitor != null && this.congestionMonitor.isActive() && (remainingCapacity = this.queue.remainingCapacity()) >= this.notificationThreshold && this.full.compareAndSet(true, false)) {
                    this.congestionMonitor.onCongestionRelease(remainingCapacity);
                }
            }
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        /*
         * Loose catch block
         */
        @Override
        public boolean awaitEmpty(long timeout, TimeUnit unit) {
            if (this.isEmpty()) {
                return true;
            }
            try {
                boolean bl;
                this.inAwaitEmpty = true;
                long nanoTimeout = unit.toNanos(timeout);
                try {
                    boolean turnedEmpty = this.queue.isEmpty();
                    if (turnedEmpty) {
                        boolean bl2 = true;
                        return bl2;
                    }
                    this.emptyLatch.lock();
                    bl = this.emptyLatch.await(nanoTimeout, TimeUnit.NANOSECONDS) && this.queue.isEmpty();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new PubSubPlusClientException.RequestInterruptedException("Waiting during graceful termination was interrupted", e);
                }
                finally {
                    this.emptyLatch.open();
                }
                return bl;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.inAwaitEmpty = false;
            }
        }

        @Override
        public void close() {
            this.closed = true;
            this.queue.clear();
            this.emptyLatch.open();
            this.inAwaitEmpty = false;
            this.unblockConsumer();
        }

        @Override
        public void close(Consumer<Publishable<RESOURCE>> action) {
            this.closed = true;
            if (this.queue.isEmpty()) {
                this.emptyLatch.open();
                this.inAwaitEmpty = false;
                this.unblockConsumer();
                return;
            }
            try {
                this.closed = true;
                this.queue.removeIf(publishable -> {
                    action.accept((Publishable)publishable);
                    return true;
                });
            }
            finally {
                this.emptyLatch.open();
                this.inAwaitEmpty = false;
                this.unblockConsumer();
            }
        }

        @Override
        public int size() {
            if (this.closed && this.queue.peek() == Publishable.none()) {
                return 0;
            }
            return this.queue.size();
        }

        @Override
        public void setBufferCongestionMonitor(BufferCongestionMonitor monitor, int notificationThreshold) {
            this.congestionMonitor = monitor;
            this.notificationThreshold = notificationThreshold;
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        void unblockConsumer() {
            if (this.queue.isEmpty()) {
                this.queue.offer(Publishable.none());
            }
        }
    }

    @Internal
    @ProviderType
    public static class BlockingPublisherBuffer<RESOURCE extends Destination>
    implements PublisherBuffer<RESOURCE> {
        private final LinkedBlockingQueue<Publishable<RESOURCE>> queue;
        private volatile boolean inAwaitEmpty = false;
        private final ToggleLatch emptyLatch = new ToggleLatch();
        private final ReentrantLockWithInterruptionSupport insertLock = new ReentrantLockWithInterruptionSupport();
        private final Condition notFull = this.insertLock.newCondition();
        private final int capacity;
        private volatile boolean closed = false;

        BlockingPublisherBuffer(int capacity) {
            this.queue = new LinkedBlockingQueue(capacity);
            this.emptyLatch.open();
            this.capacity = capacity;
        }

        @Override
        public int remainingCapacity() {
            return this.queue.remainingCapacity();
        }

        @Override
        public int capacity() {
            return this.capacity;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void insert(Publishable<RESOURCE> publishable) {
            block10: {
                if (this.closed) {
                    return;
                }
                try {
                    while (true) lbl-1000:
                    // 4 sources

                    {
                        if (this.closed) {
                            Thread.currentThread().interrupt();
                            break block10;
                        }
                        if (this.queue.offer(publishable)) {
                            if (this.queue.size() + 1 < this.capacity) {
                                this.unblockProducer();
                            }
                            break block10;
                        }
                        this.insertLock.lockInterruptibly();
                        try {
                            if (this.queue.size() != this.capacity) ** GOTO lbl-1000
                            this.notFull.await();
                        }
                        finally {
                            this.insertLock.unlock();
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new PubSubPlusClientException.RequestInterruptedException("Insertion operation to a blocking buffer was interrupted", e);
                }
                ** GOTO lbl-1000
            }
        }

        @Override
        public Publishable<RESOURCE> consume() {
            if (this.closed) {
                return null;
            }
            try {
                Publishable<RESOURCE> r = this.queue.take();
                if (Publishable.none() != r) {
                    Publishable<RESOURCE> publishable = r;
                    return publishable;
                }
                Publishable<RESOURCE> publishable = null;
                return publishable;
            }
            catch (InterruptedException ignored) {
                Publishable<RESOURCE> publishable = null;
                return publishable;
            }
            finally {
                if (this.inAwaitEmpty && this.queue.isEmpty()) {
                    this.emptyLatch.open();
                }
                this.unblockProducer();
            }
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        /*
         * Loose catch block
         */
        @Override
        public boolean awaitEmpty(long timeout, TimeUnit unit) {
            if (this.size() == 0) {
                return true;
            }
            try {
                boolean bl;
                this.inAwaitEmpty = true;
                long nanoTimeout = unit.toNanos(timeout);
                try {
                    boolean turnedEmpty = this.queue.isEmpty();
                    if (turnedEmpty) {
                        boolean bl2 = true;
                        return bl2;
                    }
                    this.emptyLatch.lock();
                    bl = this.emptyLatch.await(nanoTimeout, TimeUnit.NANOSECONDS) && this.queue.isEmpty();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new PubSubPlusClientException.RequestInterruptedException("Waiting during graceful termination was interrupted", e);
                }
                finally {
                    this.emptyLatch.open();
                }
                return bl;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.inAwaitEmpty = false;
            }
        }

        @Override
        public void close() {
            this.closed = true;
            this.interruptBlockedProducer();
            this.queue.clear();
            this.emptyLatch.open();
            this.inAwaitEmpty = false;
            this.unblockConsumer();
            this.unblockProducer();
        }

        @Override
        public void close(Consumer<Publishable<RESOURCE>> action) {
            this.closed = true;
            if (this.queue.isEmpty()) {
                this.interruptBlockedProducer();
                this.emptyLatch.open();
                this.inAwaitEmpty = false;
                this.unblockConsumer();
                this.unblockProducer();
                return;
            }
            try {
                this.interruptBlockedProducer();
                this.queue.removeIf(publishable -> {
                    action.accept((Publishable)publishable);
                    return true;
                });
            }
            finally {
                this.emptyLatch.open();
                this.inAwaitEmpty = false;
                this.unblockConsumer();
                this.unblockProducer();
            }
        }

        @Override
        public int size() {
            if (this.closed && this.queue.peek() == Publishable.none()) {
                return 0;
            }
            return this.queue.size();
        }

        @Override
        public void setBufferCongestionMonitor(BufferCongestionMonitor monitor, int notificationThreshold) {
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        void unblockConsumer() {
            if (this.queue.isEmpty()) {
                this.queue.offer(Publishable.none());
            }
        }

        private void unblockProducer() {
            ReentrantLockWithInterruptionSupport iLock = this.insertLock;
            iLock.lock();
            try {
                this.notFull.signal();
            }
            finally {
                iLock.unlock();
            }
        }

        private void interruptBlockedProducer() {
            this.insertLock.interruptWaitingThreads(this.notFull);
        }

        @Internal
        @ProviderType
        private static class ReentrantLockWithInterruptionSupport
        extends ReentrantLock {
            static final List<Thread.State> STATES_OF_INTEREST = Arrays.asList(Thread.State.TIMED_WAITING, Thread.State.WAITING);

            private ReentrantLockWithInterruptionSupport() {
            }

            void interruptWaitingThreads(Condition condition) {
                this.lock();
                Collection<Thread> wt = null;
                try {
                    wt = super.getWaitingThreads(condition);
                }
                finally {
                    this.unlock();
                }
                if (wt != null) {
                    Collection<Thread> waitingThreads = wt;
                    waitingThreads.forEach(thread -> {
                        if (ReentrantLockWithInterruptionSupport.isThreadInWaitingState(thread)) {
                            thread.interrupt();
                        }
                    });
                }
            }

            private static boolean isThreadInWaitingState(Thread t) {
                if (t == null) {
                    return false;
                }
                for (Thread.State st : STATES_OF_INTEREST) {
                    if (st == null || !st.equals((Object)t.getState())) continue;
                    return true;
                }
                return false;
            }
        }
    }

    @Internal
    @ProviderType
    public static class ElasticPublisherBuffer<RESOURCE extends Destination>
    implements PublisherBuffer<RESOURCE> {
        private final ConcurrentLinkedQueue<Publishable<RESOURCE>> queue;
        private final AtomicBoolean empty = new AtomicBoolean(true);
        private final ReentrantLock takeLock = new ReentrantLock();
        private final Condition notEmpty = this.takeLock.newCondition();
        private volatile boolean inAwaitEmpty = false;
        private volatile boolean closed = false;
        private final ToggleLatch emptyLatch = new ToggleLatch();

        ElasticPublisherBuffer() {
            this.queue = new ConcurrentLinkedQueue();
            this.emptyLatch.open();
        }

        private void onNotEmpty() {
            boolean nEmpty = this.empty.compareAndSet(true, false);
            if (nEmpty) {
                this.unblockConsumer();
            }
        }

        @Override
        public int remainingCapacity() {
            return Integer.MAX_VALUE;
        }

        @Override
        public int capacity() {
            return Integer.MAX_VALUE;
        }

        @Override
        public void insert(Publishable<RESOURCE> publishable) {
            if (this.closed) {
                return;
            }
            this.queue.offer(publishable);
            if (this.empty.get()) {
                this.onNotEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Publishable<RESOURCE> consume() {
            try {
                Publishable<RESOURCE> p;
                while ((p = this.queue.poll()) == null && !this.closed) {
                    ReentrantLock takeLock = this.takeLock;
                    takeLock.lockInterruptibly();
                    try {
                        boolean e = this.queue.isEmpty();
                        this.empty.set(e);
                        if (!e) continue;
                        this.notEmpty.await();
                    }
                    catch (InterruptedException ignored) {
                        Publishable<RESOURCE> publishable = null;
                        if (!this.inAwaitEmpty) return publishable;
                        if (!this.queue.isEmpty()) return publishable;
                        this.emptyLatch.open();
                        return publishable;
                    }
                    finally {
                        takeLock.unlock();
                    }
                }
                Publishable<RESOURCE> returned = p;
                p = returned;
                return p;
            }
            catch (InterruptedException ignored) {
                Publishable<RESOURCE> publishable = null;
                return publishable;
            }
            finally {
                if (this.inAwaitEmpty && this.queue.isEmpty()) {
                    this.emptyLatch.open();
                }
            }
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        /*
         * Loose catch block
         */
        @Override
        public boolean awaitEmpty(long timeout, TimeUnit unit) {
            if (this.queue.isEmpty()) {
                return true;
            }
            try {
                boolean bl;
                this.inAwaitEmpty = true;
                long nanoTimeout = unit.toNanos(timeout);
                try {
                    boolean turnedEmpty = this.queue.isEmpty();
                    if (turnedEmpty) {
                        this.empty.set(true);
                        boolean bl2 = true;
                        return bl2;
                    }
                    this.emptyLatch.lock();
                    bl = this.emptyLatch.await(nanoTimeout, TimeUnit.NANOSECONDS) && this.queue.isEmpty();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new PubSubPlusClientException.RequestInterruptedException("Waiting during graceful termination was interrupted", e);
                }
                finally {
                    this.emptyLatch.open();
                }
                return bl;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.inAwaitEmpty = false;
            }
        }

        @Override
        public void close() {
            this.closed = true;
            this.queue.clear();
            this.empty.set(true);
            this.emptyLatch.open();
            this.inAwaitEmpty = false;
            this.unblockConsumer();
        }

        @Override
        public void close(Consumer<Publishable<RESOURCE>> action) {
            if (this.queue.isEmpty()) {
                this.closed = true;
                this.empty.set(true);
                this.emptyLatch.open();
                this.inAwaitEmpty = false;
                this.unblockConsumer();
                return;
            }
            this.closed = true;
            try {
                ReentrantLock takeLock = this.takeLock;
                takeLock.lockInterruptibly();
                this.queue.removeIf(publishable -> {
                    action.accept((Publishable)publishable);
                    return true;
                });
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new PubSubPlusClientException.RequestInterruptedException("Cleaning of the buffer was was interrupted", e);
            }
            finally {
                this.takeLock.unlock();
                this.empty.set(true);
                this.emptyLatch.open();
                this.inAwaitEmpty = false;
                this.unblockConsumer();
            }
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public void setBufferCongestionMonitor(BufferCongestionMonitor monitor, int notificationThreshold) {
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        void unblockConsumer() {
            ReentrantLock takeLock = this.takeLock;
            takeLock.lock();
            try {
                this.notEmpty.signalAll();
            }
            finally {
                takeLock.unlock();
            }
        }
    }

    @Internal
    @ProviderType
    public static interface PublisherBuffer<T extends Destination>
    extends Serializable {
        public int remainingCapacity();

        public int capacity();

        public void insert(Publishable<T> var1) throws PubSubPlusClientException.PublisherOverflowException, PubSubPlusClientException.RequestInterruptedException;

        public Publishable<T> consume();

        public boolean isEmpty();

        public boolean awaitEmpty(long var1, TimeUnit var3);

        public void close();

        public void close(Consumer<Publishable<T>> var1);

        public int size();

        public void setBufferCongestionMonitor(BufferCongestionMonitor var1, int var2);

        public boolean isClosed();
    }

    @Internal
    @ProviderType
    public static interface Publishable<T extends Destination>
    extends Serializable {
        public static final TopicPublishable NONE = new TopicPublishable(null, null);

        public OutboundMessage getMessage();

        public T getDestination();

        public static Publishable of(OutboundMessage message, Topic destination) {
            return new TopicPublishable(message, destination);
        }

        public static Publishable none() {
            return NONE;
        }

        @Internal
        @ProviderType
        public static class TopicPublishable
        implements Publishable<Topic> {
            private static final long serialVersionUID = -5813137159388185570L;
            private final OutboundMessage message;
            private final Topic destination;

            TopicPublishable(OutboundMessage message, Topic destination) {
                this.message = message;
                this.destination = destination;
            }

            @Override
            public OutboundMessage getMessage() {
                return this.message;
            }

            @Override
            public Topic getDestination() {
                return this.destination;
            }

            public String toString() {
                return "TopicPublishable{message=" + this.message + ", destination=" + this.destination + '}';
            }
        }
    }
}

