/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.publisher;

import com.solace.messaging.PubSubPlusClientException;
import com.solace.messaging.publisher.MessagePublisher;
import com.solace.messaging.publisher.OutboundMessage;
import com.solace.messaging.resources.Topic;
import com.solace.messaging.util.CompletionListener;
import com.solace.messaging.util.ManageablePublisher;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface PersistentMessagePublisher
extends MessagePublisher {
    @Override
    public ManageablePublisher.PersistentPublisherInfo publisherInfo();

    @Override
    public PersistentMessagePublisher start();

    public <PersistentMessagePublisher> CompletableFuture<PersistentMessagePublisher> startAsync() throws PubSubPlusClientException;

    public <PersistentMessagePublisher> void startAsync(CompletionListener<PersistentMessagePublisher> var1) throws PubSubPlusClientException, IllegalStateException;

    public void setMessagePublishReceiptListener(MessagePublishReceiptListener var1);

    public void publish(byte[] var1, Topic var2) throws PubSubPlusClientException, IllegalStateException, IllegalArgumentException, PubSubPlusClientException.PublisherOverflowException;

    public void publish(byte[] var1, Topic var2, Object var3) throws PubSubPlusClientException, IllegalStateException, IllegalArgumentException, PubSubPlusClientException.PublisherOverflowException;

    public void publish(String var1, Topic var2) throws PubSubPlusClientException, IllegalStateException, IllegalArgumentException, PubSubPlusClientException.PublisherOverflowException;

    public void publish(String var1, Topic var2, Object var3) throws PubSubPlusClientException, IllegalStateException, IllegalArgumentException, PubSubPlusClientException.PublisherOverflowException;

    public void publish(OutboundMessage var1, Topic var2) throws PubSubPlusClientException, IllegalStateException, IllegalArgumentException, PubSubPlusClientException.PublisherOverflowException;

    public void publish(OutboundMessage var1, Topic var2, Object var3) throws PubSubPlusClientException, IllegalStateException, IllegalArgumentException, PubSubPlusClientException.PublisherOverflowException;

    public void publish(OutboundMessage var1, Topic var2, Object var3, Properties var4) throws PubSubPlusClientException, IllegalStateException, IllegalArgumentException, PubSubPlusClientException.PublisherOverflowException;

    public void publishAwaitAcknowledgement(OutboundMessage var1, Topic var2, long var3) throws PubSubPlusClientException.TimeoutException, PubSubPlusClientException.MessageRejectedByBrokerException, PubSubPlusClientException.PublisherOverflowException, PubSubPlusClientException.MessageDestinationDoesNotExistException, PubSubPlusClientException.MessageNotAcknowledgedByBrokerException, PubSubPlusClientException, InterruptedException;

    public void publishAwaitAcknowledgement(OutboundMessage var1, Topic var2, long var3, Properties var5) throws PubSubPlusClientException.TimeoutException, PubSubPlusClientException.MessageRejectedByBrokerException, PubSubPlusClientException.PublisherOverflowException, PubSubPlusClientException.MessageDestinationDoesNotExistException, PubSubPlusClientException.MessageNotAcknowledgedByBrokerException, PubSubPlusClientException, InterruptedException;

    @ProviderType
    public static class PublishReceipt
    implements Serializable {
        private static final long serialVersionUID = -7294450932106561755L;
        private final OutboundMessage message;
        private final long timeStamp;
        private final PubSubPlusClientException exception;
        private final boolean persisted;
        private transient Object userContext;

        PublishReceipt(OutboundMessage message, PubSubPlusClientException exception, long timeStamp, boolean persisted, Object userContext) {
            this.message = message;
            this.timeStamp = timeStamp;
            this.exception = exception;
            this.persisted = persisted;
            this.userContext = userContext;
        }

        PublishReceipt(OutboundMessage message, PubSubPlusClientException exception, long timeStamp, boolean persisted) {
            this(message, exception, timeStamp, persisted, null);
        }

        public Object getUserContext() {
            return this.userContext;
        }

        public long getTimeStamp() {
            return this.timeStamp;
        }

        public OutboundMessage getMessage() {
            return this.message;
        }

        public PubSubPlusClientException getException() {
            return this.exception;
        }

        public boolean isPersisted() {
            return this.persisted;
        }

        public String toString() {
            return "PublishReceipt{message=" + this.message + ", timeStamp=" + this.timeStamp + ", exception=" + this.exception + ", persisted=" + this.persisted + ", userContext=" + (this.userContext == null ? "null" : this.userContext.getClass().getName() + "@" + Integer.toHexString(this.hashCode())) + '}';
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.userContext = null;
        }
    }

    @FunctionalInterface
    public static interface MessagePublishReceiptListener {
        public void onPublishReceipt(PublishReceipt var1);
    }
}

