/*
 * Decompiled with CFR 0.152.
 */
package com.solace.messaging.config.provider;

import com.solace.messaging.config.provider.PublisherConfigurationProvider;
import com.solace.messaging.config.provider.PublisherPropertiesConverter;
import com.solace.messaging.util.TypedProperties;
import com.solace.messaging.util.internal.Internal;
import com.solace.messaging.util.internal.Validation;
import java.util.Properties;
import org.osgi.annotation.versioning.ProviderType;

@Internal
@ProviderType
public class PublisherBackPressureConfigurationProvider
implements PublisherConfigurationProvider {
    private final Properties configurationSource = new Properties();

    private PublisherBackPressureConfigurationProvider() {
    }

    public static PublisherBackPressureConfigurationProvider elastic() {
        PublisherBackPressureConfigurationProvider provider = new PublisherBackPressureConfigurationProvider();
        provider.configurationSource.setProperty("solace.messaging.publisher.back-pressure.strategy", "ELASTIC");
        return provider;
    }

    public static PublisherBackPressureConfigurationProvider bufferAndReject(int capacity) {
        Validation.nonNaturalNumbersIllegal(capacity, "Buffer capacity can't be negative");
        PublisherBackPressureConfigurationProvider provider = new PublisherBackPressureConfigurationProvider();
        provider.configurationSource.setProperty("solace.messaging.publisher.back-pressure.strategy", "BUFFER_REJECT_WHEN_FULL");
        provider.configurationSource.setProperty("solace.messaging.publisher.back-pressure.buffer-capacity", String.valueOf(capacity));
        return provider;
    }

    public static PublisherBackPressureConfigurationProvider bufferAndWait(int capacity) {
        Validation.nonNaturalNumbersIllegal(capacity, "Buffer capacity can't be negative");
        PublisherBackPressureConfigurationProvider provider = new PublisherBackPressureConfigurationProvider();
        provider.configurationSource.setProperty("solace.messaging.publisher.back-pressure.strategy", "BUFFER_WAIT_WHEN_FULL");
        provider.configurationSource.setProperty("solace.messaging.publisher.back-pressure.buffer-capacity", String.valueOf(capacity));
        return provider;
    }

    @Override
    public TypedProperties getConfiguration() {
        return PublisherPropertiesConverter.toTypedProperties(this.configurationSource);
    }
}

