/*
 * Decompiled with CFR 0.152.
 */
package com.solace.spring.cloud.cloudfoundry;

import com.solace.spring.cloud.core.SolaceMessagingInfo;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.cloudfoundry.CloudFoundryServiceInfoCreator;
import org.springframework.cloud.cloudfoundry.Tags;

public class SolaceMessagingInfoCreator
extends CloudFoundryServiceInfoCreator<SolaceMessagingInfo> {
    private static String solaceMessagingTag = "solace-messaging";

    public SolaceMessagingInfoCreator() {
        super(new Tags(new String[]{solaceMessagingTag}), new String[0]);
    }

    public SolaceMessagingInfo createServiceInfo(Map<String, Object> serviceData) {
        String id = this.getId(serviceData);
        String clientUsername = null;
        String clientPassword = null;
        String msgVpnName = null;
        List smfHosts = null;
        List smfTlsHosts = null;
        List smfZipHosts = null;
        List jmsJndiUris = null;
        List jmsJndiTlsUris = null;
        List restUris = null;
        List restTlsUris = null;
        List mqttUris = null;
        List mqttTlsUris = null;
        List amqpUris = null;
        List amqpTlsUris = null;
        List mqttWsUris = null;
        List mqttWssUris = null;
        List managementHostnames = null;
        String managementPassword = null;
        String managementUsername = null;
        String activeManagementHostname = null;
        Map credentials = this.getCredentials(serviceData);
        if (credentials == null) {
            throw new IllegalArgumentException("Received null credentials during object creation");
        }
        for (Map.Entry entry : credentials.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            switch (key) {
                case "clientUsername": {
                    clientUsername = (String)value;
                    break;
                }
                case "clientPassword": {
                    clientPassword = (String)value;
                    break;
                }
                case "msgVpnName": {
                    msgVpnName = (String)value;
                    break;
                }
                case "smfHosts": {
                    smfHosts = (List)value;
                    break;
                }
                case "smfTlsHosts": {
                    smfTlsHosts = (List)value;
                    break;
                }
                case "smfZipHosts": {
                    smfZipHosts = (List)value;
                    break;
                }
                case "jmsJndiUris": {
                    jmsJndiUris = (List)value;
                    break;
                }
                case "jmsJndiTlsUris": {
                    jmsJndiTlsUris = (List)value;
                    break;
                }
                case "managementUsername": {
                    managementUsername = (String)value;
                    break;
                }
                case "managementPassword": {
                    managementPassword = (String)value;
                    break;
                }
                case "activeManagementHostname": {
                    activeManagementHostname = (String)value;
                    break;
                }
                case "restUris": {
                    restUris = (List)value;
                    break;
                }
                case "restTlsUris": {
                    restTlsUris = (List)value;
                    break;
                }
                case "mqttUris": {
                    mqttUris = (List)value;
                    break;
                }
                case "mqttTlsUris": {
                    mqttTlsUris = (List)value;
                    break;
                }
                case "mqttWsUris": {
                    mqttWsUris = (List)value;
                    break;
                }
                case "mqttWssUris": {
                    mqttWssUris = (List)value;
                    break;
                }
                case "amqpUris": {
                    amqpUris = (List)value;
                    break;
                }
                case "amqpTlsUris": {
                    amqpTlsUris = (List)value;
                    break;
                }
                case "managementHostnames": {
                    managementHostnames = (List)value;
                }
            }
        }
        String smfHost = null;
        String smfTlsHost = null;
        String smfZipHost = null;
        String jmsJndiUri = null;
        String jmsJndiTlsUri = null;
        if (smfHosts != null) {
            smfHost = String.join((CharSequence)",", smfHosts);
        }
        if (smfTlsHosts != null) {
            smfTlsHost = String.join((CharSequence)",", smfTlsHosts);
        }
        if (smfZipHosts != null) {
            smfZipHost = String.join((CharSequence)",", smfZipHosts);
        }
        if (jmsJndiUris != null) {
            jmsJndiUri = String.join((CharSequence)",", jmsJndiUris);
        }
        if (jmsJndiTlsUris != null) {
            jmsJndiTlsUri = String.join((CharSequence)",", jmsJndiTlsUris);
        }
        SolaceMessagingInfo solMessagingInfo = new SolaceMessagingInfo(id, clientUsername, clientPassword, msgVpnName, smfHost, smfTlsHost, smfZipHost, jmsJndiUri, jmsJndiTlsUri, restUris, restTlsUris, mqttUris, mqttTlsUris, mqttWsUris, mqttWssUris, amqpUris, amqpTlsUris, managementHostnames, managementPassword, managementUsername, activeManagementHostname);
        return solMessagingInfo;
    }

    public boolean accept(Map<String, Object> serviceData) {
        return super.accept(serviceData) || this.isUserProvided(serviceData) && this.isSolaceMessagingInfo(serviceData);
    }

    public boolean isUserProvided(Map<String, Object> serviceData) {
        if (serviceData == null) {
            return false;
        }
        String label = (String)serviceData.get("label");
        return "user-provided".startsWith(label);
    }

    public boolean isSolaceMessagingInfo(Map<String, Object> serviceData) {
        if (serviceData == null) {
            return false;
        }
        try {
            SolaceMessagingInfo solMessagingInfo = this.createServiceInfo(serviceData);
            if (solMessagingInfo == null) break block5;
            if (solMessagingInfo.getId() == null) break block6;
            if (solMessagingInfo.getMsgVpnName() != null) {
                return true;
            }
        }
        finally {
            return false;
        }
        {
            block5: {
                block6: {
                }
            }
        }
    }
}

