/*
 * Decompiled with CFR 0.152.
 */
package com.solace.spring.cloud.core;

import com.solace.services.core.model.SolaceServiceCredentials;
import com.solace.services.core.model.SolaceServiceCredentialsImpl;
import io.pivotal.cfenv.core.CfEnv;
import io.pivotal.cfenv.core.CfService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SolaceServiceCredentialsFactory {
    private static final String solacePubSubLabel = "solace-pubsub";
    private static final String solacePubSubTag = "solace-pubsub";

    public static List<SolaceServiceCredentials> getAllFromCloudFoundry() {
        CfEnv cfEnv = new CfEnv();
        ArrayList<CfService> services = new ArrayList<CfService>(cfEnv.findServicesByLabel(new String[]{"solace-pubsub"}));
        for (CfService serviceA : cfEnv.findServicesByTag(new String[]{"solace-pubsub"})) {
            boolean unique = true;
            for (CfService serviceB : services) {
                if (!serviceA.getName().equals(serviceB.getName())) continue;
                unique = false;
            }
            if (!unique) continue;
            services.add(serviceA);
        }
        ArrayList<SolaceServiceCredentials> credentials = new ArrayList<SolaceServiceCredentials>();
        for (CfService service : services) {
            credentials.add(SolaceServiceCredentialsFactory.loadServiceCredentials(service));
        }
        return credentials;
    }

    private static SolaceServiceCredentials loadServiceCredentials(CfService service) {
        SolaceServiceCredentialsImpl credentials = new SolaceServiceCredentialsImpl();
        credentials.setId(service.getName());
        for (Map.Entry entry : service.getCredentials().getMap().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            switch (key) {
                case "clientUsername": {
                    credentials.setClientUsername((String)value);
                    break;
                }
                case "clientPassword": {
                    credentials.setClientPassword((String)value);
                    break;
                }
                case "msgVpnName": {
                    credentials.setMsgVpnName((String)value);
                    break;
                }
                case "smfHosts": {
                    credentials.setSmfHosts((List)value);
                    break;
                }
                case "smfTlsHosts": {
                    credentials.setSmfTlsHosts((List)value);
                    break;
                }
                case "smfZipHosts": {
                    credentials.setSmfZipHosts((List)value);
                    break;
                }
                case "jmsJndiUris": {
                    credentials.setJmsJndiUris((List)value);
                    break;
                }
                case "jmsJndiTlsUris": {
                    credentials.setJmsJndiTlsUris((List)value);
                    break;
                }
                case "managementUsername": {
                    credentials.setManagementUsername((String)value);
                    break;
                }
                case "managementPassword": {
                    credentials.setManagementPassword((String)value);
                    break;
                }
                case "activeManagementHostname": {
                    credentials.setActiveManagementHostname((String)value);
                    break;
                }
                case "restUris": {
                    credentials.setRestUris((List)value);
                    break;
                }
                case "restTlsUris": {
                    credentials.setRestTlsUris((List)value);
                    break;
                }
                case "mqttUris": {
                    credentials.setMqttUris((List)value);
                    break;
                }
                case "mqttTlsUris": {
                    credentials.setMqttTlsUris((List)value);
                    break;
                }
                case "mqttWsUris": {
                    credentials.setMqttWsUris((List)value);
                    break;
                }
                case "mqttWssUris": {
                    credentials.setMqttWssUris((List)value);
                    break;
                }
                case "amqpUris": {
                    credentials.setAmqpUris((List)value);
                    break;
                }
                case "amqpTlsUris": {
                    credentials.setAmqpTlsUris((List)value);
                    break;
                }
                case "managementHostnames": {
                    credentials.setManagementHostnames((List)value);
                    break;
                }
                case "dmrClusterName": {
                    credentials.setDmrClusterName((String)value);
                    break;
                }
                case "dmrClusterPassword": {
                    credentials.setDmrClusterPassword((String)value);
                }
            }
        }
        return credentials;
    }
}

