/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremill.sttp.okhttp;

import com.softwaremill.sttp.BasicResponseAs;
import com.softwaremill.sttp.ByteArrayBody;
import com.softwaremill.sttp.ByteBufferBody;
import com.softwaremill.sttp.FileBody;
import com.softwaremill.sttp.FileHelpers$;
import com.softwaremill.sttp.HeaderNames$;
import com.softwaremill.sttp.IgnoreResponse$;
import com.softwaremill.sttp.InputStreamBody;
import com.softwaremill.sttp.Method;
import com.softwaremill.sttp.MonadError;
import com.softwaremill.sttp.Multipart;
import com.softwaremill.sttp.MultipartBody;
import com.softwaremill.sttp.NoBody$;
import com.softwaremill.sttp.RequestBody;
import com.softwaremill.sttp.RequestT;
import com.softwaremill.sttp.Response;
import com.softwaremill.sttp.ResponseAs;
import com.softwaremill.sttp.ResponseAsByteArray$;
import com.softwaremill.sttp.ResponseAsFile;
import com.softwaremill.sttp.ResponseAsStream;
import com.softwaremill.sttp.ResponseAsString;
import com.softwaremill.sttp.ResponseMetadata;
import com.softwaremill.sttp.ResponseMetadata$;
import com.softwaremill.sttp.StreamBody;
import com.softwaremill.sttp.StringBody;
import com.softwaremill.sttp.SttpBackend;
import com.softwaremill.sttp.SttpBackendOptions;
import com.softwaremill.sttp.Uri;
import com.softwaremill.sttp.internal.SttpFile;
import com.softwaremill.sttp.package$;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Route;
import okhttp3.internal.http.HttpMethod;
import okio.BufferedSink;
import okio.Okio;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005]h!B\u000b\u0017\u0003\u0003y\u0002\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011\r\u0003!\u0011!Q\u0001\n\u0011CQa\u0012\u0001\u0005\u0002!Ca!\u0014\u0001\u0005\u0002Yq\u0005\"B4\u0001\t\u0013A\u0007\"B;\u0001\t\u00131\b\u0002CA\t\u0001\u0011\u0005a#a\u0005\t\u000f\u0005\u0015\u0003\u0001\"\u0003\u0002H!9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0004bBA4\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003s\u0002A\u0011IA>\u000f\u001d\tiH\u0006E\u0001\u0003\u007f2a!\u0006\f\t\u0002\u0005\u0005\u0005BB$\u000e\t\u0003\t\u0019I\u0002\u0004\u0002\u00066!\u0011q\u0011\u0005\u000b\u0003?{!\u0011!Q\u0001\n\u0005\u0005\u0006BB$\u0010\t\u0003\ty\u000bC\u0004\u00028>!\t%!/\t\u0011\u0005%W\u0002\"\u0001\u0017\u0003\u0017D\u0001\"!9\u000e\t\u00031\u00121\u001d\u0002\u000e\u001f.DE\u000f\u001e9CC\u000e\\WM\u001c3\u000b\u0005]A\u0012AB8lQR$\bO\u0003\u0002\u001a5\u0005!1\u000f\u001e;q\u0015\tYB$\u0001\u0007t_\u001a$x/\u0019:f[&dGNC\u0001\u001e\u0003\r\u0019w.\\\u0002\u0001+\r\u0001SFO\n\u0004\u0001\u0005:\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g\r\u0005\u0003)S-JT\"\u0001\r\n\u0005)B\"aC*uiB\u0014\u0015mY6f]\u0012\u0004\"\u0001L\u0017\r\u0001\u0011)a\u0006\u0001b\u0001_\t\t!+\u0006\u00021oE\u0011\u0011\u0007\u000e\t\u0003EIJ!aM\u0012\u0003\u000f9{G\u000f[5oOB\u0011!%N\u0005\u0003m\r\u00121!\u00118z\t\u0015ATF1\u00011\u0005\u0005y\u0006C\u0001\u0017;\t\u0015Y\u0004A1\u00011\u0005\u0005\u0019\u0016AB2mS\u0016tG\u000f\u0005\u0002?\u00036\tqHC\u0001A\u0003\u001dy7\u000e\u001b;uaNJ!AQ \u0003\u0019=[\u0007\n\u001e;q\u00072LWM\u001c;\u0002\u0017\rdwn]3DY&,g\u000e\u001e\t\u0003E\u0015K!AR\u0012\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"2!S&M!\u0011Q\u0005aK\u001d\u000e\u0003YAQ\u0001P\u0002A\u0002uBQaQ\u0002A\u0002\u0011\u000babY8om\u0016\u0014HOU3rk\u0016\u001cH/\u0006\u0002PKR\u0011\u0001k\u0015\t\u0003}EK!AU \u0003\u000fI+\u0017/^3ti\")A\u000b\u0002a\u0001+\u00069!/Z9vKN$\b\u0003\u0002,cIfr!a\u00161\u000f\u0005a{fBA-_\u001d\tQV,D\u0001\\\u0015\taf$\u0001\u0004=e>|GOP\u0005\u0002;%\u00111\u0004H\u0005\u00033iI!!\u0019\r\u0002\u000fA\f7m[1hK&\u0011!k\u0019\u0006\u0003Cb\u0001\"\u0001L3\u0005\u000b\u0019$!\u0019\u0001\u0019\u0003\u0003Q\u000bABY8esR{wj\u001b%uiB,\"!\u001b;\u0015\u0005)\u0004\bc\u0001\u0012l[&\u0011An\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005yr\u0017BA8@\u0005-\u0011V-];fgR\u0014u\u000eZ=\t\u000bE,\u0001\u0019\u0001:\u0002\t\t|G-\u001f\t\u0004QML\u0014BA8\u0019\t\u00151WA1\u00011\u00031\tG\rZ'vYRL\u0007/\u0019:u)\u00119(0a\u0002\u0011\u0005\tB\u0018BA=$\u0005\u0011)f.\u001b;\t\u000bm4\u0001\u0019\u0001?\u0002\u000f\t,\u0018\u000e\u001c3feB\u0019Q0!\u0001\u000f\u0005yr\u0018BA@@\u00035iU\u000f\u001c;ja\u0006\u0014HOQ8es&!\u00111AA\u0003\u0005\u001d\u0011U/\u001b7eKJT!a` \t\u000f\u0005%a\u00011\u0001\u0002\f\u0005\u0011Q\u000e\u001d\t\u0004Q\u00055\u0011bAA\b1\tIQ*\u001e7uSB\f'\u000f^\u0001\re\u0016\fGMU3ta>t7/Z\u000b\u0005\u0003+\t\t\u0003\u0006\u0005\u0002\u0018\u0005\r\u00121FA\u001b!\u0011aS&!\u0007\u0011\u000b!\nY\"a\b\n\u0007\u0005u\u0001D\u0001\u0005SKN\u0004xN\\:f!\ra\u0013\u0011\u0005\u0003\u0006M\u001e\u0011\r\u0001\r\u0005\b\u0003K9\u0001\u0019AA\u0014\u0003\r\u0011Xm\u001d\t\u0004}\u0005%\u0012bAA\u000f\u007f!9\u0011QF\u0004A\u0002\u0005=\u0012A\u0003:fgB|gn]3BgB1\u0001&!\r\u0002 eJ1!a\r\u0019\u0005)\u0011Vm\u001d9p]N,\u0017i\u001d\u0005\b\u0003o9\u0001\u0019AA\u001d\u00039\u0001\u0018M]:f\u0007>tG-\u001b;j_:\u0004bAIA\u001e\u0003\u007f!\u0015bAA\u001fG\tIa)\u001e8di&|g.\r\t\u0004Q\u0005\u0005\u0013bAA\"1\t\u0001\"+Z:q_:\u001cX-T3uC\u0012\fG/Y\u0001\u0010e\u0016\u001c\bo\u001c8tK\"\u000bg\u000e\u001a7feR!\u0011\u0011JA/%\u0015\tY%IA(\r\u0019\ti\u0005\u0003\u0001\u0002J\taAH]3gS:,W.\u001a8u}A)\u0011\u0011KA,s9\u0019\u0001&a\u0015\n\u0007\u0005U\u0003$\u0001\u0006SKN\u0004xN\\:f\u0003NLA!!\u0017\u0002\\\t!R)Y4feJ+7\u000f]8og\u0016D\u0015M\u001c3mKJT1!!\u0016\u0019\u0011\u001d\t)\u0003\u0003a\u0001\u0003O\t1c\u001d;sK\u0006lGk\u001c*fcV,7\u000f\u001e\"pIf$2A[A2\u0011\u0019\t)'\u0003a\u0001s\u000511\u000f\u001e:fC6\fAC]3ta>t7/\u001a\"pIf$vn\u0015;sK\u0006lG\u0003BA6\u0003o\u0002R!!\u001c\u0002tej!!a\u001c\u000b\u0007\u0005E4%\u0001\u0003vi&d\u0017\u0002BA;\u0003_\u00121\u0001\u0016:z\u0011\u001d\t)C\u0003a\u0001\u0003O\tQa\u00197pg\u0016$\u0012a^\u0001\u000e\u001f.DE\u000f\u001e9CC\u000e\\WM\u001c3\u0011\u0005)k1CA\u0007\")\t\tyH\u0001\nQe>D\u00180Q;uQ\u0016tG/[2bi>\u00148#B\b\u0002\n\u0006e\u0005\u0003BAF\u0003+k!!!$\u000b\t\u0005=\u0015\u0011S\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0014\u0006!!.\u0019<b\u0013\u0011\t9*!$\u0003\r=\u0013'.Z2u!\rq\u00141T\u0005\u0004\u0003;{$!D!vi\",g\u000e^5dCR|'/\u0001\u0003bkRD\u0007\u0003BAR\u0003Ss1\u0001KAS\u0013\r\t9\u000bG\u0001\u0013'R$\bOQ1dW\u0016tGm\u00149uS>t7/\u0003\u0003\u0002,\u00065&!\u0003)s_bL\u0018)\u001e;i\u0015\r\t9\u000b\u0007\u000b\u0005\u0003c\u000b)\fE\u0002\u00024>i\u0011!\u0004\u0005\b\u0003?\u000b\u0002\u0019AAQ\u00031\tW\u000f\u001e5f]RL7-\u0019;f)\u0015\u0001\u00161XAc\u0011\u001d\tiL\u0005a\u0001\u0003\u007f\u000bQA]8vi\u0016\u00042APAa\u0013\r\t\u0019m\u0010\u0002\u0006%>,H/\u001a\u0005\b\u0003\u000f\u0014\u0002\u0019AA\u0014\u0003!\u0011Xm\u001d9p]N,\u0017!\u00043fM\u0006,H\u000e^\"mS\u0016tG\u000fF\u0003>\u0003\u001b\f9\u000eC\u0004\u0002PN\u0001\r!!5\u0002\u0017I,\u0017\r\u001a+j[\u0016|W\u000f\u001e\t\u0004E\u0005M\u0017bAAkG\t!Aj\u001c8h\u0011\u001d\tIn\u0005a\u0001\u00037\fqa\u001c9uS>t7\u000fE\u0002)\u0003;L1!a8\u0019\u0005I\u0019F\u000f\u001e9CC\u000e\\WM\u001c3PaRLwN\\:\u0002?U\u0004H-\u0019;f\u00072LWM\u001c;JM\u000e+8\u000f^8n%\u0016\fG\rV5nK>,H/\u0006\u0004\u0002f\u0006=\u00181\u001f\u000b\u0006{\u0005\u001d\u0018Q\u001f\u0005\b\u0003S$\u0002\u0019AAv\u0003\u0005\u0011\bC\u0002,c\u0003[\f\t\u0010E\u0002-\u0003_$QA\u001a\u000bC\u0002A\u00022\u0001LAz\t\u0015YDC1\u00011\u0011\u0015aD\u00031\u0001>\u0001")
public abstract class OkHttpBackend<R, S>
implements SttpBackend<R, S> {
    private final OkHttpClient client;
    private final boolean closeClient;

    public <T> Request convertRequest(RequestT<Object, T, S> request) {
        Request.Builder builder = new Request.Builder().url(((Uri)request.uri()).toString());
        Option<okhttp3.RequestBody> body = this.bodyToOkHttp(request.body());
        builder.method(((Method)request.method()).m(), (okhttp3.RequestBody)body.getOrElse((Function0 & Serializable & scala.Serializable)() -> HttpMethod.requiresRequestBody((String)((Method)request.method()).m()) ? okhttp3.RequestBody.create(null, (String)"") : null));
        ((IterableLike)request.headers().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)OkHttpBackend.$anonfun$convertRequest$2(x$1)))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            String value = (String)tuple2._2();
            Request.Builder builder = builder.addHeader(name, value);
            return builder;
        });
        return builder.build();
    }

    private <T> Option<okhttp3.RequestBody> bodyToOkHttp(RequestBody<S> body) {
        Some some;
        RequestBody<S> requestBody = body;
        if (NoBody$.MODULE$.equals(requestBody)) {
            some = None$.MODULE$;
        } else if (requestBody instanceof StringBody) {
            StringBody stringBody = (StringBody)requestBody;
            String b = stringBody.s();
            some = new Some((Object)okhttp3.RequestBody.create(null, (String)b));
        } else if (requestBody instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody = (ByteArrayBody)requestBody;
            byte[] b = byteArrayBody.b();
            some = new Some((Object)okhttp3.RequestBody.create(null, (byte[])b));
        } else if (requestBody instanceof ByteBufferBody) {
            ByteBufferBody byteBufferBody = (ByteBufferBody)requestBody;
            ByteBuffer b = byteBufferBody.b();
            some = new Some((Object)okhttp3.RequestBody.create(null, (byte[])b.array()));
        } else if (requestBody instanceof InputStreamBody) {
            InputStreamBody inputStreamBody = (InputStreamBody)requestBody;
            InputStream b = inputStreamBody.b();
            some = new Some((Object)new okhttp3.RequestBody(null, b){
                private final InputStream b$1;

                public void writeTo(BufferedSink sink) {
                    sink.writeAll(Okio.source((InputStream)this.b$1));
                }

                public MediaType contentType() {
                    return null;
                }
                {
                    this.b$1 = b$1;
                }
            });
        } else if (requestBody instanceof FileBody) {
            FileBody fileBody = (FileBody)requestBody;
            SttpFile b = fileBody.f();
            some = new Some((Object)okhttp3.RequestBody.create(null, (File)b.toFile()));
        } else if (requestBody instanceof StreamBody) {
            StreamBody streamBody = (StreamBody)requestBody;
            Object s = streamBody.s();
            some = this.streamToRequestBody(s);
        } else if (requestBody instanceof MultipartBody) {
            MultipartBody multipartBody = (MultipartBody)requestBody;
            Seq ps = multipartBody.parts();
            MultipartBody.Builder b = new MultipartBody.Builder().setType(okhttp3.MultipartBody.FORM);
            ps.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                this.addMultipart(b, x$2);
                return BoxedUnit.UNIT;
            });
            some = new Some((Object)b.build());
        } else {
            throw new MatchError(requestBody);
        }
        return some;
    }

    private void addMultipart(MultipartBody.Builder builder, Multipart mp) {
        scala.collection.immutable.Map allHeaders = mp.additionalHeaders().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.ContentDisposition()), (Object)mp.contentDispositionHeaderValue()));
        Headers headers = Headers.of((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)allHeaders).asJava()));
        this.bodyToOkHttp((RequestBody<S>)mp.body()).foreach((Function1 & Serializable & scala.Serializable)x$3 -> builder.addPart(headers, x$3));
    }

    public <T> R readResponse(okhttp3.Response res, ResponseAs<T, S> responseAs, Function1<ResponseMetadata, Object> parseCondition) {
        int code = res.code();
        List headers = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(res.headers().names()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)name -> (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res.headers().values(name)).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> new Tuple2(name, x$4), Buffer$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom())).toList();
        ResponseMetadata responseMetadata = ResponseMetadata$.MODULE$.apply((Seq)headers, res.code(), res.message());
        Object body = BoxesRunTime.unboxToBoolean((Object)parseCondition.apply((Object)responseMetadata)) ? this.responseMonad().map(this.responseHandler(res).handle(responseAs, this.responseMonad(), responseMetadata), (Function1 & Serializable & scala.Serializable)x$5 -> scala.package$.MODULE$.Right().apply(x$5)) : this.responseMonad().map(this.responseHandler(res).handle(package$.MODULE$.asByteArray(), this.responseMonad(), responseMetadata), (Function1 & Serializable & scala.Serializable)x$6 -> scala.package$.MODULE$.Left().apply(x$6));
        return (R)this.responseMonad().map(body, (Function1 & Serializable & scala.Serializable)x$7 -> new Response(x$7, res.code(), res.message(), (Seq)headers, (List)Nil$.MODULE$));
    }

    private ResponseAs.EagerResponseHandler<S> responseHandler(okhttp3.Response res) {
        return new ResponseAs.EagerResponseHandler<S>(this, res){
            private final /* synthetic */ OkHttpBackend $outer;
            private final okhttp3.Response res$2;

            public <T, R> R handle(ResponseAs<T, S> responseAs, MonadError<R> responseMonad, ResponseMetadata headers) {
                return (R)ResponseAs.EagerResponseHandler.handle$((ResponseAs.EagerResponseHandler)this, responseAs, responseMonad, (ResponseMetadata)headers);
            }

            public <T> Try<T> handleBasic(BasicResponseAs<T, S> bra) {
                Try try_;
                BasicResponseAs<T, S> basicResponseAs = bra;
                if (IgnoreResponse$.MODULE$.equals(basicResponseAs)) {
                    try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.res$2.close());
                } else if (basicResponseAs instanceof ResponseAsString) {
                    ResponseAsString responseAsString = (ResponseAsString)basicResponseAs;
                    String encoding = responseAsString.encoding();
                    String charset = (String)Option$.MODULE$.apply((Object)this.res$2.header(HeaderNames$.MODULE$.ContentType())).flatMap((Function1 & Serializable & scala.Serializable)ct -> com.softwaremill.sttp.internal.package$.MODULE$.encodingFromContentType(ct)).getOrElse((Function0 & Serializable & scala.Serializable)() -> encoding);
                    Try body = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.res$2.body().source().readString(Charset.forName(charset)));
                    this.res$2.close();
                    try_ = body;
                } else if (ResponseAsByteArray$.MODULE$.equals(basicResponseAs)) {
                    Try body = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> $this.res$2.body().bytes());
                    this.res$2.close();
                    try_ = body;
                } else if (basicResponseAs instanceof ResponseAsStream) {
                    ResponseAsStream responseAsStream = (ResponseAsStream)basicResponseAs;
                    try_ = this.$outer.responseBodyToStream(this.res$2).map((Function1)responseAsStream.responseIsStream());
                } else if (basicResponseAs instanceof ResponseAsFile) {
                    ResponseAsFile responseAsFile = (ResponseAsFile)basicResponseAs;
                    SttpFile file = responseAsFile.output();
                    boolean overwrite = responseAsFile.overwrite();
                    Try body = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> FileHelpers$.MODULE$.saveFile(file.toFile(), $this.res$2.body().byteStream(), overwrite));
                    this.res$2.close();
                    try_ = body.map((Function1 & Serializable & scala.Serializable)x$8 -> file);
                } else {
                    throw new MatchError(basicResponseAs);
                }
                return try_;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.res$2 = res$2;
                ResponseAs.EagerResponseHandler.$init$((ResponseAs.EagerResponseHandler)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$handleBasic$1(com.softwaremill.sttp.okhttp.OkHttpBackend$$anon$2 ), $anonfun$handleBasic$2(java.lang.String ), $anonfun$handleBasic$3(java.lang.String ), $anonfun$handleBasic$4(com.softwaremill.sttp.okhttp.OkHttpBackend$$anon$2 java.lang.String ), $anonfun$handleBasic$5(com.softwaremill.sttp.okhttp.OkHttpBackend$$anon$2 ), $anonfun$handleBasic$6(com.softwaremill.sttp.okhttp.OkHttpBackend$$anon$2 com.softwaremill.sttp.internal.SttpFile boolean ), $anonfun$handleBasic$7(com.softwaremill.sttp.internal.SttpFile java.io.File )}, serializedLambda);
            }
        };
    }

    public Option<okhttp3.RequestBody> streamToRequestBody(S stream) {
        return None$.MODULE$;
    }

    public Try<S> responseBodyToStream(okhttp3.Response res) {
        return new Failure((Throwable)new IllegalStateException("Streaming isn't supported"));
    }

    public void close() {
        block0: {
            if (!this.closeClient) break block0;
            this.client.dispatcher().executorService().shutdown();
        }
    }

    public static final /* synthetic */ boolean $anonfun$convertRequest$2(Tuple2 x$1) {
        return !((String)x$1._1()).equalsIgnoreCase(HeaderNames$.MODULE$.AcceptEncoding());
    }

    public OkHttpBackend(OkHttpClient client, boolean closeClient) {
        this.client = client;
        this.closeClient = closeClient;
    }

    public static class ProxyAuthenticator
    implements Authenticator {
        private final SttpBackendOptions.ProxyAuth auth;

        public Request authenticate(Route route, okhttp3.Response response) {
            String credential = Credentials.basic((String)this.auth.username(), (String)this.auth.password());
            return response.request().newBuilder().header("Proxy-Authorization", credential).build();
        }

        public ProxyAuthenticator(SttpBackendOptions.ProxyAuth auth) {
            this.auth = auth;
        }
    }
}

