/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import java.io.IOException;

public abstract class FileStoreInfo {
    public static final String FILE_STORE_CLASS = "java.nio.file.FileStore";
    private static final String JAVA7_FILE_STORE_FACTORY_CLASS = "com.sleepycat.je.utilint.Java7FileStoreInfo$Java7Factory";
    private static final Factory standardFactory = FileStoreInfo.createFactory();
    private static volatile Factory testFactory = null;

    protected FileStoreInfo() {
    }

    private static Factory createFactory() {
        try {
            Class.forName(FILE_STORE_CLASS);
        }
        catch (ClassNotFoundException e) {
            return new FailingFactory(new UnsupportedOperationException("FileStoreInfo is only supported for Java 7 and later"));
        }
        try {
            return Class.forName(JAVA7_FILE_STORE_FACTORY_CLASS).asSubclass(Factory.class).newInstance();
        }
        catch (Exception e) {
            return new FailingFactory(new IllegalStateException("Problem accessing class com.sleepycat.je.utilint.Java7FileStoreInfo$Java7Factory: " + e, e));
        }
    }

    public static final synchronized void checkSupported() {
        FileStoreInfo.getFactory().factoryCheckSupported();
    }

    private static synchronized Factory getFactory() {
        return testFactory == null ? standardFactory : testFactory;
    }

    public static void setFactory(Factory factory) {
        testFactory = factory;
    }

    public static FileStoreInfo getInfo(String file) throws IOException {
        return FileStoreInfo.getFactory().factoryGetInfo(file);
    }

    public abstract long getTotalSpace() throws IOException;

    public abstract long getUsableSpace() throws IOException;

    private static class FailingFactory
    implements Factory {
        final RuntimeException exception;

        FailingFactory(RuntimeException exception) {
            this.exception = exception;
        }

        @Override
        public void factoryCheckSupported() {
            throw this.exception;
        }

        @Override
        public FileStoreInfo factoryGetInfo(String file) {
            throw this.exception;
        }
    }

    static interface Factory {
        public void factoryCheckSupported();

        public FileStoreInfo factoryGetInfo(String var1) throws IOException;
    }
}

