/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.cleaner.BaseUtilizationTracker;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.utilint.DbLsn;
import java.util.HashMap;
import java.util.Map;

public class RecoveryUtilizationTracker
extends BaseUtilizationTracker {
    private final Map<Long, Long> fileSummaryLsns = new HashMap<Long, Long>();

    public RecoveryUtilizationTracker(EnvironmentImpl env) {
        super(env);
    }

    public void saveLastLoggedFileSummaryLN(long fileNum, long lsn) {
        this.fileSummaryLsns.put(fileNum, lsn);
    }

    public void countNewLogEntry(long lsn, LogEntryType type, int size) {
        this.countNew(lsn, type, size);
    }

    public void countObsoleteUnconditional(long lsn, LogEntryType type, int size, boolean trackOffset) {
        this.countObsolete(lsn, type, size, trackOffset, false);
    }

    public void countObsoleteIfUncounted(long oldLsn, long newLsn, LogEntryType type, int size, boolean trackOffset) {
        Long fileNum = DbLsn.getFileNumber(oldLsn);
        if (!this.isFileUncounted(fileNum, newLsn)) {
            return;
        }
        this.countObsolete(oldLsn, type, size, trackOffset, false);
    }

    @Override
    boolean isFileUncounted(Long fileNum, long lsn) {
        long fsLsn = DbLsn.longToLsn(this.fileSummaryLsns.get(fileNum));
        int cmpFsLsnToNewLsn = fsLsn != -1L ? DbLsn.compareTo(fsLsn, lsn) : -1;
        return cmpFsLsnToNewLsn < 0;
    }

    public void resetFileInfo(long fileNum) {
        TrackedFileSummary trackedSummary = this.getTrackedFile(fileNum);
        if (trackedSummary != null) {
            trackedSummary.reset();
        }
    }
}

