/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.methods.impl;

import com.slack.api.methods.MethodsConfig;
import com.slack.api.methods.SlackApiResponse;
import com.slack.api.methods.impl.AsyncExecutionSupplier;
import com.slack.api.methods.impl.AsyncMethodsRateLimiter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncRateLimitQueue {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncRateLimitQueue.class);
    private static final ConcurrentMap<String, ConcurrentMap<String, AsyncRateLimitQueue>> ALL_QUEUES = new ConcurrentHashMap<String, ConcurrentMap<String, AsyncRateLimitQueue>>();
    private AsyncMethodsRateLimiter rateLimiter;
    private final ConcurrentMap<String, LinkedBlockingQueue<Message>> methodNameToActiveQueue = new ConcurrentHashMap<String, LinkedBlockingQueue<Message>>();

    private static ConcurrentMap<String, AsyncRateLimitQueue> getInstance(String executorName) {
        ConcurrentHashMap teamIdToQueue = (ConcurrentHashMap)ALL_QUEUES.get(executorName);
        if (teamIdToQueue == null) {
            teamIdToQueue = new ConcurrentHashMap();
            ALL_QUEUES.put(executorName, teamIdToQueue);
        }
        return teamIdToQueue;
    }

    public AsyncMethodsRateLimiter getRateLimiter() {
        return this.rateLimiter;
    }

    public void setRateLimiter(AsyncMethodsRateLimiter rateLimiter) {
        this.rateLimiter = rateLimiter;
    }

    private AsyncRateLimitQueue(MethodsConfig config) {
        this.rateLimiter = new AsyncMethodsRateLimiter(config);
    }

    public static AsyncRateLimitQueue get(String executorName, String teamId) {
        if (executorName == null || teamId == null) {
            throw new IllegalArgumentException("`executorName` and `teamId` are required");
        }
        ConcurrentMap<String, AsyncRateLimitQueue> teamIdToQueue = AsyncRateLimitQueue.getInstance(executorName);
        return (AsyncRateLimitQueue)teamIdToQueue.get(teamId);
    }

    public static AsyncRateLimitQueue getOrCreate(MethodsConfig config, String teamId) {
        if (teamId == null) {
            throw new IllegalArgumentException("`teamId` is required");
        }
        ConcurrentMap<String, AsyncRateLimitQueue> teamIdToQueue = AsyncRateLimitQueue.getInstance(config.getExecutorName());
        AsyncRateLimitQueue queue = (AsyncRateLimitQueue)teamIdToQueue.get(teamId);
        if (queue != null && queue.getRateLimiter().getMetricsDatastore() != config.getMetricsDatastore()) {
            queue.setRateLimiter(new AsyncMethodsRateLimiter(config));
        }
        if (queue == null) {
            queue = new AsyncRateLimitQueue(config);
            teamIdToQueue.put(teamId, queue);
        }
        return queue;
    }

    private LinkedBlockingQueue<Message> getOrCreateActiveQueue(String methodName) {
        LinkedBlockingQueue queue = (LinkedBlockingQueue)this.methodNameToActiveQueue.get(methodName);
        if (queue != null) {
            return queue;
        }
        LinkedBlockingQueue<Message> newQueue = new LinkedBlockingQueue<Message>();
        this.methodNameToActiveQueue.putIfAbsent(methodName, newQueue);
        return newQueue;
    }

    public <T extends SlackApiResponse> void enqueue(String messageId, String teamId, String methodName, Map<String, String> params, AsyncExecutionSupplier<T> methodsSupplier) throws InterruptedException {
        AsyncMethodsRateLimiter.WaitTime waitTime = methodName.equals("chat.postMessage") ? this.rateLimiter.acquireWaitTimeForChatPostMessage(teamId, params.get("channel")) : this.rateLimiter.acquireWaitTime(teamId, methodName);
        LinkedBlockingQueue<Message> activeQueue = this.getOrCreateActiveQueue(methodName);
        long epochMillisToRun = System.currentTimeMillis() + waitTime.getMillisToWait();
        Message message = new Message(messageId, epochMillisToRun, waitTime, methodsSupplier);
        activeQueue.put(message);
        if (log.isDebugEnabled()) {
            log.debug("A new message has been enqueued (id: {}, pace: {}, wait time: {})", new Object[]{message.getId(), message.getWaitTime().getPace(), message.getWaitTime().getMillisToWait()});
        }
    }

    public synchronized void remove(String methodName, String messageId) {
        LinkedBlockingQueue<Message> activeQueue = this.getOrCreateActiveQueue(methodName);
        Message toRemove = null;
        for (Message message : activeQueue) {
            if (!message.getId().equals(messageId)) continue;
            toRemove = message;
            break;
        }
        activeQueue.remove(toRemove);
    }

    public synchronized <T extends SlackApiResponse> AsyncExecutionSupplier<T> dequeueIfReady(String messageId, String teamId, String methodName, Map<String, String> params) {
        LinkedBlockingQueue<Message> activeQueue = this.getOrCreateActiveQueue(methodName);
        Message message = activeQueue.peek();
        if (message == null) {
            throw new IllegalStateException("No message is found in the queue");
        }
        if (message.getId().equals(messageId) && message.getMillisToRun() <= System.currentTimeMillis()) {
            AsyncMethodsRateLimiter.WaitTime original = message.getWaitTime();
            AsyncMethodsRateLimiter.WaitTime latest = methodName.equals("chat.postMessage") ? this.rateLimiter.acquireWaitTimeForChatPostMessage(teamId, params.get("channel")) : this.rateLimiter.acquireWaitTime(teamId, methodName);
            if (log.isDebugEnabled()) {
                log.debug("Latest: {} ({} millis), original: {} ({} millis)", new Object[]{latest.getPace(), latest.getMillisToWait(), original.getPace(), original.getMillisToWait()});
            }
            if (latest.getPace() != original.getPace() && latest.getMillisToWait() > original.getMillisToWait()) {
                long newMillisToRun = System.currentTimeMillis() + latest.getMillisToWait();
                message.setMillisToRun(newMillisToRun);
                message.setWaitTime(latest);
            } else {
                AsyncExecutionSupplier<?> supplier = activeQueue.poll().getSupplier();
                return supplier;
            }
        }
        return null;
    }

    public Integer getCurrentActiveQueueSize(String methodNameWithSuffix) {
        LinkedBlockingQueue activeQueue = (LinkedBlockingQueue)this.methodNameToActiveQueue.get(methodNameWithSuffix);
        return activeQueue != null ? activeQueue.size() : 0;
    }

    private static class Message {
        private String id;
        private long millisToRun;
        private AsyncMethodsRateLimiter.WaitTime waitTime;
        private AsyncExecutionSupplier<?> supplier;

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public long getMillisToRun() {
            return this.millisToRun;
        }

        @Generated
        public AsyncMethodsRateLimiter.WaitTime getWaitTime() {
            return this.waitTime;
        }

        @Generated
        public AsyncExecutionSupplier<?> getSupplier() {
            return this.supplier;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setMillisToRun(long millisToRun) {
            this.millisToRun = millisToRun;
        }

        @Generated
        public void setWaitTime(AsyncMethodsRateLimiter.WaitTime waitTime) {
            this.waitTime = waitTime;
        }

        @Generated
        public void setSupplier(AsyncExecutionSupplier<?> supplier) {
            this.supplier = supplier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Message)) {
                return false;
            }
            Message other = (Message)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMillisToRun() != other.getMillisToRun()) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            AsyncMethodsRateLimiter.WaitTime this$waitTime = this.getWaitTime();
            AsyncMethodsRateLimiter.WaitTime other$waitTime = other.getWaitTime();
            if (this$waitTime == null ? other$waitTime != null : !((Object)this$waitTime).equals(other$waitTime)) {
                return false;
            }
            AsyncExecutionSupplier<?> this$supplier = this.getSupplier();
            AsyncExecutionSupplier<?> other$supplier = other.getSupplier();
            return !(this$supplier == null ? other$supplier != null : !this$supplier.equals(other$supplier));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Message;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $millisToRun = this.getMillisToRun();
            result = result * 59 + (int)($millisToRun >>> 32 ^ $millisToRun);
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            AsyncMethodsRateLimiter.WaitTime $waitTime = this.getWaitTime();
            result = result * 59 + ($waitTime == null ? 43 : ((Object)$waitTime).hashCode());
            AsyncExecutionSupplier<?> $supplier = this.getSupplier();
            result = result * 59 + ($supplier == null ? 43 : $supplier.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AsyncRateLimitQueue.Message(id=" + this.getId() + ", millisToRun=" + this.getMillisToRun() + ", waitTime=" + this.getWaitTime() + ", supplier=" + this.getSupplier() + ")";
        }

        @Generated
        public Message(String id, long millisToRun, AsyncMethodsRateLimiter.WaitTime waitTime, AsyncExecutionSupplier<?> supplier) {
            this.id = id;
            this.millisToRun = millisToRun;
            this.waitTime = waitTime;
            this.supplier = supplier;
        }
    }
}

