/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.socket_mode.impl;

import com.google.gson.Gson;
import com.slack.api.Slack;
import com.slack.api.methods.SlackApiException;
import com.slack.api.socket_mode.SocketModeClient;
import com.slack.api.socket_mode.listener.EnvelopeListener;
import com.slack.api.socket_mode.listener.WebSocketCloseListener;
import com.slack.api.socket_mode.listener.WebSocketErrorListener;
import com.slack.api.socket_mode.listener.WebSocketMessageListener;
import com.slack.api.socket_mode.queue.SocketModeMessageQueue;
import com.slack.api.socket_mode.queue.impl.ConcurrentLinkedMessageQueue;
import com.slack.api.socket_mode.request.EventsApiEnvelope;
import com.slack.api.socket_mode.request.InteractiveEnvelope;
import com.slack.api.socket_mode.request.SlashCommandsEnvelope;
import com.slack.api.util.json.GsonFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.java_websocket.WebSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ServerHandshake;

public class SocketModeClientJavaWSImpl
implements SocketModeClient {
    private Slack slack;
    private String appToken;
    private final Gson gson;
    private URI wssUri;
    private boolean autoReconnectEnabled;
    private SocketModeMessageQueue messageQueue;
    private ScheduledExecutorService messageProcessorExecutor;
    private boolean sessionMonitorEnabled;
    private Optional<ScheduledExecutorService> sessionMonitorExecutor;
    private final List<WebSocketMessageListener> webSocketMessageListeners = new CopyOnWriteArrayList<WebSocketMessageListener>();
    private final List<EnvelopeListener<EventsApiEnvelope>> eventsApiEnvelopeListeners = new CopyOnWriteArrayList<EnvelopeListener<EventsApiEnvelope>>();
    private final List<EnvelopeListener<SlashCommandsEnvelope>> slashCommandsEnvelopeListeners = new CopyOnWriteArrayList<EnvelopeListener<SlashCommandsEnvelope>>();
    private final List<EnvelopeListener<InteractiveEnvelope>> interactiveEnvelopeListeners = new CopyOnWriteArrayList<EnvelopeListener<InteractiveEnvelope>>();
    private final List<WebSocketErrorListener> webSocketErrorListeners = new CopyOnWriteArrayList<WebSocketErrorListener>();
    private final List<WebSocketCloseListener> webSocketCloseListeners = new CopyOnWriteArrayList<WebSocketCloseListener>();
    private UnderlyingWebSocketSession currentSession;

    public SocketModeClientJavaWSImpl(String appToken) throws IOException, SlackApiException, URISyntaxException {
        this(Slack.getInstance(), appToken);
    }

    public SocketModeClientJavaWSImpl(Slack slack, String appToken) throws IOException, SlackApiException, URISyntaxException {
        this(slack, appToken, slack.methods(appToken).appsConnectionsOpen(r -> r).getUrl());
    }

    public SocketModeClientJavaWSImpl(Slack slack, String appToken, String wssUrl) throws URISyntaxException {
        this(slack, appToken, wssUrl, 10);
    }

    public SocketModeClientJavaWSImpl(Slack slack, String appToken, String wssUrl, int concurrency) throws URISyntaxException {
        this(slack, appToken, wssUrl, concurrency, new ConcurrentLinkedMessageQueue(), true, true, 5000L);
    }

    public SocketModeClientJavaWSImpl(Slack slack, String appToken, String wssUrl, int concurrency, SocketModeMessageQueue messageQueue, boolean autoReconnectEnabled, boolean sessionMonitorEnabled, long sessionMonitorIntervalMillis) throws URISyntaxException {
        if (wssUrl == null) {
            throw new IllegalArgumentException("The wss URL for using Socket Mode is absent.");
        }
        this.setSlack(slack);
        this.setAppToken(appToken);
        this.setWssUri(new URI(wssUrl));
        this.gson = GsonFactory.createSnakeCase(slack.getConfig());
        this.setMessageQueue(messageQueue);
        this.setAutoReconnectEnabled(autoReconnectEnabled);
        this.setSessionMonitorEnabled(sessionMonitorEnabled);
        this.initializeSessionMonitorExecutor(sessionMonitorIntervalMillis);
        this.initializeMessageProcessorExecutor(concurrency);
        this.currentSession = new UnderlyingWebSocketSession(this.getWssUri(), this);
    }

    @Override
    public void connect() {
        this.currentSession.connect();
    }

    @Override
    public boolean verifyConnection() {
        if (this.currentSession != null && this.currentSession.isOpen()) {
            try {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Sending a ping message");
                }
                this.currentSession.sendPing();
                for (long waitMillis = 0L; waitMillis <= 3000L; waitMillis += 100L) {
                    if (this.currentSession.isPongReceived()) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Received a pong message");
                        }
                        return true;
                    }
                    this.currentSession.sendPing();
                    Thread.sleep(100L);
                }
            }
            catch (Exception e) {
                this.getLogger().info("Failed to send a ping message (exception: {}, message: {})", (Object)e.getClass().getCanonicalName(), (Object)e.getMessage());
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Failed to receive a pong message");
            }
        }
        return false;
    }

    @Override
    public void disconnect() {
        this.setAutoReconnectEnabled(false);
        this.currentSession.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectToNewEndpoint() throws IOException {
        try {
            this.setWssUri(new URI(this.getSlack().issueSocketModeUrl(this.getAppToken())));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        if (this.currentSession == null) {
            this.currentSession = new UnderlyingWebSocketSession(this.getWssUri(), this);
            this.connect();
        } else {
            UnderlyingWebSocketSession underlyingWebSocketSession = this.currentSession;
            synchronized (underlyingWebSocketSession) {
                UnderlyingWebSocketSession oldSession = this.currentSession;
                this.currentSession = new UnderlyingWebSocketSession(this.getWssUri(), this);
                this.connect();
                oldSession.close();
            }
        }
    }

    @Override
    public void sendWebSocketMessage(String message) {
        this.currentSession.send(message);
    }

    @Override
    public long maintainCurrentSession() {
        if (this.isAutoReconnectEnabled() && !this.verifyConnection()) {
            try {
                this.connectToNewEndpoint();
            }
            catch (IOException e) {
                this.getLogger().error("Failed to establish a new connection to the Socket Mode server: {}", (Object)e.getMessage(), (Object)e);
                return System.currentTimeMillis() + 10000L;
            }
        }
        return System.currentTimeMillis();
    }

    @Override
    public Slack getSlack() {
        return this.slack;
    }

    @Override
    public void setSlack(Slack slack) {
        this.slack = slack;
    }

    @Override
    public Gson getGson() {
        return this.gson;
    }

    @Override
    public String getAppToken() {
        return this.appToken;
    }

    @Override
    public void setAppToken(String appToken) {
        this.appToken = appToken;
    }

    @Override
    public URI getWssUri() {
        return this.wssUri;
    }

    @Override
    public void setWssUri(URI wssUri) {
        this.wssUri = wssUri;
    }

    @Override
    public boolean isAutoReconnectEnabled() {
        return this.autoReconnectEnabled;
    }

    @Override
    public void setAutoReconnectEnabled(boolean autoReconnectEnabled) {
        this.autoReconnectEnabled = autoReconnectEnabled;
    }

    @Override
    public boolean isSessionMonitorEnabled() {
        return this.sessionMonitorEnabled;
    }

    @Override
    public void setSessionMonitorEnabled(boolean sessionMonitorEnabled) {
        this.sessionMonitorEnabled = sessionMonitorEnabled;
    }

    @Override
    public Optional<ScheduledExecutorService> getSessionMonitorExecutor() {
        return this.sessionMonitorExecutor;
    }

    @Override
    public void setSessionMonitorExecutor(Optional<ScheduledExecutorService> executorService) {
        this.sessionMonitorExecutor = executorService;
    }

    @Override
    public SocketModeMessageQueue getMessageQueue() {
        return this.messageQueue;
    }

    @Override
    public void setMessageQueue(SocketModeMessageQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    @Override
    public ScheduledExecutorService getMessageProcessorExecutor() {
        return this.messageProcessorExecutor;
    }

    @Override
    public void setMessageProcessorExecutor(ScheduledExecutorService executorService) {
        this.messageProcessorExecutor = executorService;
    }

    @Override
    public List<WebSocketErrorListener> getWebSocketErrorListeners() {
        return this.webSocketErrorListeners;
    }

    @Override
    public List<WebSocketCloseListener> getWebSocketCloseListeners() {
        return this.webSocketCloseListeners;
    }

    @Override
    public List<WebSocketMessageListener> getWebSocketMessageListeners() {
        return this.webSocketMessageListeners;
    }

    @Override
    public List<EnvelopeListener<EventsApiEnvelope>> getEventsApiEnvelopeListeners() {
        return this.eventsApiEnvelopeListeners;
    }

    @Override
    public List<EnvelopeListener<InteractiveEnvelope>> getInteractiveEnvelopeListeners() {
        return this.interactiveEnvelopeListeners;
    }

    @Override
    public List<EnvelopeListener<SlashCommandsEnvelope>> getSlashCommandsEnvelopeListeners() {
        return this.slashCommandsEnvelopeListeners;
    }

    static class UnderlyingWebSocketSession
    extends WebSocketClient {
        private final SocketModeClient smc;
        private final AtomicLong lastPongReceived = new AtomicLong();

        public boolean isPongReceived() {
            return Math.abs(System.currentTimeMillis() - this.lastPongReceived.get()) < 1000L;
        }

        public UnderlyingWebSocketSession(URI serverUri, SocketModeClient smc) {
            super(serverUri);
            this.smc = smc;
            String proxyUrl = smc.getSlack().getHttpClient().getConfig().getProxyUrl();
            if (proxyUrl != null) {
                if (smc.getLogger().isDebugEnabled()) {
                    smc.getLogger().debug("The SocketMode client's going to use an HTTP proxy: {}", (Object)proxyUrl);
                }
                try {
                    URL p = new URL(proxyUrl);
                    InetSocketAddress proxyAddress = new InetSocketAddress(p.getHost(), p.getPort());
                    this.setProxy(new Proxy(Proxy.Type.HTTP, proxyAddress));
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException("The proxy setting is invalid: " + proxyUrl);
                }
            }
        }

        public void onOpen(ServerHandshake serverHandshake) {
            byte[] bytes = serverHandshake.getContent();
            if (bytes != null) {
                this.smc.getLogger().info("New session is open (content: {})", (Object)new String(bytes));
                this.smc.setAutoReconnectEnabled(true);
            } else {
                this.smc.getLogger().info("New session is open");
            }
        }

        public void onMessage(String message) {
            this.smc.enqueueMessage(message);
        }

        public void onClose(int code, String reason, boolean remote) {
            this.smc.getLogger().info("onClose listener is called (code: {}, reason: {})", (Object)code, (Object)reason);
            if (code >= 1000) {
                this.smc.runCloseListenersAndAutoReconnectAsNecessary(code, reason);
            }
        }

        public void onError(Exception reason) {
            this.smc.getLogger().error("onError listener is called (reason: {})", (Throwable)reason);
            this.smc.runErrorListeners(reason);
        }

        public void onWebsocketPong(WebSocket conn, Framedata f) {
            this.lastPongReceived.set(System.currentTimeMillis());
        }
    }
}

