/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.methods.impl;

import com.slack.api.methods.RequestFormBuilder;
import com.slack.api.methods.SlackApiException;
import com.slack.api.methods.impl.MethodsClientImpl;
import com.slack.api.methods.request.auth.AuthTestRequest;
import com.slack.api.methods.response.auth.AuthTestResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import lombok.Generated;
import okhttp3.FormBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeamIdCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TeamIdCache.class);
    public static final List<String> METHOD_NAMES_TO_SKIP_TEAM_ID_CACHE_RESOLUTION = Arrays.asList("auth.revoke", "openid.connect.token", "openid.connect.userInfo");
    private static final ConcurrentMap<String, String> TOKEN_TO_TEAM_ID = new ConcurrentHashMap<String, String>();
    private final MethodsClientImpl methodsImpl;

    public TeamIdCache(MethodsClientImpl methodsImpl) {
        this.methodsImpl = methodsImpl;
    }

    public String lookupOrResolve(String token) {
        return TeamIdCache.lookupOrResolve(token, newToken -> {
            try {
                FormBody.Builder form = RequestFormBuilder.toForm(AuthTestRequest.builder().token((String)newToken).build());
                Response response = this.methodsImpl.runPostFormWithToken(form, "auth.test", token);
                AuthTestResponse authTest = this.methodsImpl.parseJsonResponseAndRunListeners(null, null, response, AuthTestResponse.class);
                if (authTest != null && authTest.isOk()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Created cache for an auth.test API call (token: {}, team_id: {})", (Object)(token.substring(0, 16) + "..."), (Object)authTest.getTeamId());
                    }
                    return authTest.getTeamId();
                }
                String error = authTest != null ? authTest.getError() : "(empty response)";
                log.error("Got an unsuccessful response from auth.test API (error: {})", (Object)error);
            }
            catch (SlackApiException | IOException e) {
                log.error("Failed to call auth.test API (error: {})", (Object)e.getMessage(), (Object)e);
            }
            return null;
        });
    }

    private static String lookupOrResolve(String token, Function<String, String> compute) {
        if (token == null) {
            return null;
        }
        return TOKEN_TO_TEAM_ID.computeIfAbsent(token, compute);
    }
}

