/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.middleware;

import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestType;
import com.slack.api.bolt.request.builtin.EventRequest;
import java.util.Arrays;
import java.util.List;

public class MiddlewareOps {
    private static final List<String> EVENT_TYPES_TO_SKIP_AUTHORIZATION = Arrays.asList("app_uninstalled", "tokens_revoked");

    private MiddlewareOps() {
    }

    public static boolean isNoSlackSignatureRequest(RequestType requestType) {
        return requestType == RequestType.OAuthStart || requestType == RequestType.OAuthCallback || requestType == RequestType.SSLCheck;
    }

    public static boolean isNoAuthRequiredRequest(RequestType requestType) {
        return MiddlewareOps.isNoSlackSignatureRequest(requestType) || requestType == RequestType.UrlVerification;
    }

    public static boolean isNoTokenRequiredRequest(Request req) {
        if (req.getRequestType() == RequestType.Event) {
            EventRequest eventRequest = (EventRequest)req;
            String eventType = eventRequest.getEventType();
            return eventType != null && EVENT_TYPES_TO_SKIP_AUTHORIZATION.contains(eventType);
        }
        return false;
    }
}

