/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.context;

import com.slack.api.methods.MethodsClient;
import com.slack.api.methods.SlackApiException;
import com.slack.api.methods.response.views.ViewsOpenResponse;
import com.slack.api.model.block.LayoutBlock;
import com.slack.api.model.view.Views;
import java.io.IOException;
import java.util.List;

public interface WorkflowConfigureUtility {
    public String getTriggerId();

    public String getCallbackId();

    public MethodsClient client();

    default public ViewsOpenResponse configure(List<LayoutBlock> blocks) throws IOException, SlackApiException {
        return this.configure(blocks, null, null, null);
    }

    default public ViewsOpenResponse configure(List<LayoutBlock> blocks, String privateMetadata) throws IOException, SlackApiException {
        return this.configure(blocks, privateMetadata, null, null);
    }

    default public ViewsOpenResponse configure(List<LayoutBlock> blocks, String privateMetadata, String externalId) throws IOException, SlackApiException {
        return this.configure(blocks, privateMetadata, externalId, null);
    }

    default public ViewsOpenResponse configure(List<LayoutBlock> blocks, String privateMetadata, String externalId, Boolean submitDisabled) throws IOException, SlackApiException {
        ViewsOpenResponse response = this.client().viewsOpen(r -> r.triggerId(this.getTriggerId()).view(Views.view(v -> v.type("workflow_step").callbackId(this.getCallbackId()).externalId(externalId).privateMetadata(privateMetadata).submitDisabled(submitDisabled).blocks(blocks))));
        return response;
    }
}

