/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.request.builtin;

import com.google.gson.Gson;
import com.slack.api.app_backend.events.payload.Authorization;
import com.slack.api.app_backend.events.payload.WorkflowStepExecutePayload;
import com.slack.api.bolt.context.builtin.WorkflowStepExecuteContext;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.RequestType;
import com.slack.api.util.json.GsonFactory;
import lombok.Generated;

public class WorkflowStepExecuteRequest
extends Request<WorkflowStepExecuteContext> {
    private final String requestBody;
    private final RequestHeaders headers;
    private final WorkflowStepExecutePayload payload;
    private static final Gson GSON = GsonFactory.createSnakeCase();
    private WorkflowStepExecuteContext context = new WorkflowStepExecuteContext();

    public WorkflowStepExecuteRequest(String requestBody, RequestHeaders headers) {
        this.requestBody = requestBody;
        this.headers = headers;
        this.payload = (WorkflowStepExecutePayload)GSON.fromJson(requestBody, WorkflowStepExecutePayload.class);
        if (this.payload != null) {
            if (this.payload.getAuthorizations() != null && this.payload.getAuthorizations().size() > 0) {
                this.getContext().setEnterpriseId(((Authorization)this.payload.getAuthorizations().get(0)).getEnterpriseId());
                this.getContext().setTeamId(((Authorization)this.payload.getAuthorizations().get(0)).getTeamId());
            } else {
                this.getContext().setEnterpriseId(this.payload.getEnterpriseId());
                this.getContext().setTeamId(this.payload.getTeamId());
            }
            this.getContext().setRequestUserId(null);
            this.getContext().setCallbackId(this.payload.getEvent().getCallbackId());
            this.getContext().setWorkflowStepExecuteId(this.payload.getEvent().getWorkflowStep().getWorkflowStepExecuteId());
        }
    }

    @Override
    public WorkflowStepExecuteContext getContext() {
        return this.context;
    }

    @Override
    public RequestType getRequestType() {
        return RequestType.WorkflowStepExecute;
    }

    @Override
    public String getRequestBodyAsString() {
        return this.requestBody;
    }

    @Override
    public RequestHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public String getResponseUrl() {
        return null;
    }

    public WorkflowStepExecutePayload getPayload() {
        return this.payload;
    }

    @Override
    @Generated
    public String toString() {
        return "WorkflowStepExecuteRequest(super=" + super.toString() + ", requestBody=" + this.requestBody + ", headers=" + this.getHeaders() + ", payload=" + this.getPayload() + ", context=" + this.getContext() + ")";
    }
}

