/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.servlet;

import com.slack.api.bolt.AppConfig;
import com.slack.api.bolt.request.RequestHeaders;
import com.slack.api.bolt.request.WebEndpointRequest;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.servlet.ServletAdapterOps;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebEndpointServletAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebEndpointServletAdapter.class);
    private AppConfig appConfig;

    public WebEndpointServletAdapter(AppConfig appConfig) {
        this.appConfig = appConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebEndpointRequest buildSlackRequest(HttpServletRequest req) throws IOException {
        String queryString = req.getQueryString();
        String requestBody = this.doReadRequestBodyAsString(req);
        RequestHeaders headers = new RequestHeaders(ServletAdapterOps.toHeaderMap(req));
        WebEndpointRequest slackRequest = null;
        try {
            WebEndpointRequest webEndpointRequest = slackRequest = new WebEndpointRequest(queryString, requestBody, headers);
            return webEndpointRequest;
        }
        finally {
            if (slackRequest != null) {
                String ipAddress = req.getHeader("X-FORWARDED-FOR");
                if (ipAddress == null) {
                    ipAddress = req.getRemoteAddr();
                }
                slackRequest.setClientIpAddress(ipAddress);
            }
        }
    }

    protected String doReadRequestBodyAsString(HttpServletRequest req) throws IOException {
        return ServletAdapterOps.doReadRequestBodyAsString(req);
    }

    public void writeResponse(HttpServletResponse resp, Response slackResp) throws IOException {
        ServletAdapterOps.writeResponse(resp, slackResp);
    }
}

