/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.bolt.servlet;

import com.slack.api.bolt.App;
import com.slack.api.bolt.request.Request;
import com.slack.api.bolt.response.Response;
import com.slack.api.bolt.servlet.SlackAppServletAdapter;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackAppServlet
extends HttpServlet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SlackAppServlet.class);
    private final App app;
    private final SlackAppServletAdapter adapter;

    public App getApp() {
        return this.app;
    }

    public SlackAppServlet(App app) {
        this.app = app;
        this.adapter = new SlackAppServletAdapter(app.config());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Request<?> slackReq = this.adapter.buildSlackRequest(req);
        if (slackReq != null) {
            try {
                Response slackResp = this.app.run(slackReq);
                this.adapter.writeResponse(resp, slackResp);
            }
            catch (Exception e) {
                log.error("Failed to handle a request - {}", (Object)e.getMessage(), (Object)e);
                resp.setStatus(500);
                resp.setContentType("application/json");
                resp.getWriter().write("{\"error\":\"Something is wrong\"}");
            }
        }
    }
}

