/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.elastic4s.http;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import scala.Function0;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tUgaB\u0001\u0003!\u0003\r\nc\u0003\u0002\u000b\u0011R$\b/\u00128uSRL(BA\u0002\u0005\u0003\u0011AG\u000f\u001e9\u000b\u0005\u00151\u0011!C3mCN$\u0018n\u0019\u001bt\u0015\t9\u0001\"\u0001\u0005tWN\fW.^3m\u0015\u0005I\u0011aA2p[\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fM\")1\u0003\u0001D\u0001)\u0005q1m\u001c8uK:$8\t[1sg\u0016$X#A\u000b\u0011\u000751\u0002$\u0003\u0002\u0018\u001d\t1q\n\u001d;j_:\u0004\"!\u0007\u000f\u000f\u00055Q\u0012BA\u000e\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011QD\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005mq\u0001\"\u0002\u0011\u0001\r\u0003\t\u0013aA4fiV\t\u0001$K\u0004\u0001G\u0005\u001d\u0018QN\u001c\u0007\u000b\u0011*\u0003Ia$\u0003\u001f\tKH/Z!se\u0006LXI\u001c;jif4Q!\u0001\u0002\t\u0002\u0019\u001a\"!\n\u0007\t\u000b!*C\u0011A\u0015\u0002\rqJg.\u001b;?)\u0005Q\u0003CA\u0016&\u001b\u0005\u0011\u0001\"B\u0017&\t\u0003q\u0013!B1qa2LHCA\u00181!\tY\u0003\u0001C\u00032Y\u0001\u0007\u0001$A\u0004d_:$XM\u001c;\t\u000b5*C\u0011A\u001a\u0015\u0007=\"T\u0007C\u00032e\u0001\u0007\u0001\u0004C\u00037e\u0001\u0007\u0001$A\u0006d_:$XM\u001c;UsB,g\u0001\u0002\u001d&\u0001f\u0012Ab\u0015;sS:<WI\u001c;jif\u001cRa\u000e\u00070uu\u0002\"!D\u001e\n\u0005qr!a\u0002)s_\u0012,8\r\u001e\t\u0003\u001byJ!a\u0010\b\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011E:$Q3A\u0005\u0002\u0005B\u0001BQ\u001c\u0003\u0012\u0003\u0006I\u0001G\u0001\tG>tG/\u001a8uA!A1c\u000eBK\u0002\u0013\u0005A\u0003\u0003\u0005Fo\tE\t\u0015!\u0003\u0016\u0003=\u0019wN\u001c;f]R\u001c\u0005.\u0019:tKR\u0004\u0003\"\u0002\u00158\t\u00039Ec\u0001%K\u0017B\u0011\u0011jN\u0007\u0002K!)\u0011G\u0012a\u00011!)1C\u0012a\u0001+!)\u0001e\u000eC\u0001C!9ajNA\u0001\n\u0003y\u0015\u0001B2paf$2\u0001\u0013)R\u0011\u001d\tT\n%AA\u0002aAqaE'\u0011\u0002\u0003\u0007Q\u0003C\u0004ToE\u0005I\u0011\u0001+\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\tQK\u000b\u0002\u0019-.\nq\u000b\u0005\u0002Y;6\t\u0011L\u0003\u0002[7\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u00039:\t!\"\u00198o_R\fG/[8o\u0013\tq\u0016LA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016Dq\u0001Y\u001c\u0012\u0002\u0013\u0005\u0011-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003\tT#!\u0006,\t\u000f\u0011<\u0014\u0011!C!K\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012A\u001a\t\u0003O2l\u0011\u0001\u001b\u0006\u0003S*\fA\u0001\\1oO*\t1.\u0001\u0003kCZ\f\u0017BA\u000fi\u0011\u001dqw'!A\u0005\u0002=\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012\u0001\u001d\t\u0003\u001bEL!A\u001d\b\u0003\u0007%sG\u000fC\u0004uo\u0005\u0005I\u0011A;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0011a/\u001f\t\u0003\u001b]L!\u0001\u001f\b\u0003\u0007\u0005s\u0017\u0010C\u0004{g\u0006\u0005\t\u0019\u00019\u0002\u0007a$\u0013\u0007C\u0004}o\u0005\u0005I\u0011I?\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\u0012A \t\u0005\u007f\u0006\u0015a/\u0004\u0002\u0002\u0002)\u0019\u00111\u0001\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\b\u0005\u0005!\u0001C%uKJ\fGo\u001c:\t\u0013\u0005-q'!A\u0005\u0002\u00055\u0011\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005=\u0011Q\u0003\t\u0004\u001b\u0005E\u0011bAA\n\u001d\t9!i\\8mK\u0006t\u0007\u0002\u0003>\u0002\n\u0005\u0005\t\u0019\u0001<\t\u0013\u0005eq'!A\u0005B\u0005m\u0011\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003AD\u0011\"a\b8\u0003\u0003%\t%!\t\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A\u001a\u0005\n\u0003K9\u0014\u0011!C!\u0003O\ta!Z9vC2\u001cH\u0003BA\b\u0003SA\u0001B_A\u0012\u0003\u0003\u0005\rA^\u0004\n\u0003[)\u0013\u0011!E\u0001\u0003_\tAb\u0015;sS:<WI\u001c;jif\u00042!SA\u0019\r!AT%!A\t\u0002\u0005M2#BA\u0019\u0003ki\u0004cBA\u001c\u0003{AR\u0003S\u0007\u0003\u0003sQ1!a\u000f\u000f\u0003\u001d\u0011XO\u001c;j[\u0016LA!a\u0010\u0002:\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000f!\n\t\u0004\"\u0001\u0002DQ\u0011\u0011q\u0006\u0005\u000b\u0003?\t\t$!A\u0005F\u0005\u0005\u0002\"C\u0017\u00022\u0005\u0005I\u0011QA%)\u0015A\u00151JA'\u0011\u0019\t\u0014q\ta\u00011!11#a\u0012A\u0002UA!\"!\u0015\u00022\u0005\u0005I\u0011QA*\u0003\u001d)h.\u00199qYf$B!!\u0016\u0002^A!QBFA,!\u0015i\u0011\u0011\f\r\u0016\u0013\r\tYF\u0004\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005}\u0013qJA\u0001\u0002\u0004A\u0015a\u0001=%a!Q\u00111MA\u0019\u0003\u0003%I!!\u001a\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003O\u00022aZA5\u0013\r\tY\u0007\u001b\u0002\u0007\u001f\nTWm\u0019;\u0007\r\u0005=T\u0005QA9\u0005EIe\u000e];u'R\u0014X-Y7F]RLG/_\n\u0007\u0003[bqFO\u001f\t\u0015E\niG!f\u0001\n\u0003\t)(\u0006\u0002\u0002xA!\u0011\u0011PA@\u001b\t\tYHC\u0002\u0002~)\f!![8\n\t\u0005\u0005\u00151\u0010\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0006C\u0003[\u0012\t\u0012)A\u0005\u0003oB\u0011bEA7\u0005+\u0007I\u0011\u0001\u000b\t\u0013\u0015\u000biG!E!\u0002\u0013)\u0002b\u0002\u0015\u0002n\u0011\u0005\u00111\u0012\u000b\u0007\u0003\u001b\u000by)!%\u0011\u0007%\u000bi\u0007C\u00042\u0003\u0013\u0003\r!a\u001e\t\rM\tI\t1\u0001\u0016\u0011\u0019\u0001\u0013Q\u000eC\u0001C!Ia*!\u001c\u0002\u0002\u0013\u0005\u0011q\u0013\u000b\u0007\u0003\u001b\u000bI*a'\t\u0013E\n)\n%AA\u0002\u0005]\u0004\u0002C\n\u0002\u0016B\u0005\t\u0019A\u000b\t\u0013M\u000bi'%A\u0005\u0002\u0005}UCAAQU\r\t9H\u0016\u0005\tA\u00065\u0014\u0013!C\u0001C\"AA-!\u001c\u0002\u0002\u0013\u0005S\r\u0003\u0005o\u0003[\n\t\u0011\"\u0001p\u0011%!\u0018QNA\u0001\n\u0003\tY\u000bF\u0002w\u0003[C\u0001B_AU\u0003\u0003\u0005\r\u0001\u001d\u0005\ty\u00065\u0014\u0011!C!{\"Q\u00111BA7\u0003\u0003%\t!a-\u0015\t\u0005=\u0011Q\u0017\u0005\tu\u0006E\u0016\u0011!a\u0001m\"Q\u0011\u0011DA7\u0003\u0003%\t%a\u0007\t\u0015\u0005}\u0011QNA\u0001\n\u0003\n\t\u0003\u0003\u0006\u0002&\u00055\u0014\u0011!C!\u0003{#B!a\u0004\u0002@\"A!0a/\u0002\u0002\u0003\u0007aoB\u0005\u0002D\u0016\n\t\u0011#\u0001\u0002F\u0006\t\u0012J\u001c9viN#(/Z1n\u000b:$\u0018\u000e^=\u0011\u0007%\u000b9MB\u0005\u0002p\u0015\n\t\u0011#\u0001\u0002JN)\u0011qYAf{AI\u0011qGA\u001f\u0003o*\u0012Q\u0012\u0005\bQ\u0005\u001dG\u0011AAh)\t\t)\r\u0003\u0006\u0002 \u0005\u001d\u0017\u0011!C#\u0003CA\u0011\"LAd\u0003\u0003%\t)!6\u0015\r\u00055\u0015q[Am\u0011\u001d\t\u00141\u001ba\u0001\u0003oBaaEAj\u0001\u0004)\u0002BCA)\u0003\u000f\f\t\u0011\"!\u0002^R!\u0011q\\Ar!\u0011ia#!9\u0011\r5\tI&a\u001e\u0016\u0011)\ty&a7\u0002\u0002\u0003\u0007\u0011Q\u0012\u0005\u000b\u0003G\n9-!A\u0005\n\u0005\u0015dABAuK\u0001\u000bYO\u0001\u0006GS2,WI\u001c;jif\u001cb!a:\r_ij\u0004BC\u0019\u0002h\nU\r\u0011\"\u0001\u0002pV\u0011\u0011\u0011\u001f\t\u0005\u0003s\n\u00190\u0003\u0003\u0002v\u0006m$\u0001\u0002$jY\u0016D!BQAt\u0005#\u0005\u000b\u0011BAy\u0011%\u0019\u0012q\u001dBK\u0002\u0013\u0005A\u0003C\u0005F\u0003O\u0014\t\u0012)A\u0005+!9\u0001&a:\u0005\u0002\u0005}HC\u0002B\u0001\u0005\u0007\u0011)\u0001E\u0002J\u0003ODq!MA\u007f\u0001\u0004\t\t\u0010\u0003\u0004\u0014\u0003{\u0004\r!\u0006\u0005\u0007A\u0005\u001dH\u0011A\u0011\t\u00139\u000b9/!A\u0005\u0002\t-AC\u0002B\u0001\u0005\u001b\u0011y\u0001C\u00052\u0005\u0013\u0001\n\u00111\u0001\u0002r\"A1C!\u0003\u0011\u0002\u0003\u0007Q\u0003C\u0005T\u0003O\f\n\u0011\"\u0001\u0003\u0014U\u0011!Q\u0003\u0016\u0004\u0003c4\u0006\u0002\u00031\u0002hF\u0005I\u0011A1\t\u0011\u0011\f9/!A\u0005B\u0015D\u0001B\\At\u0003\u0003%\ta\u001c\u0005\ni\u0006\u001d\u0018\u0011!C\u0001\u0005?!2A\u001eB\u0011\u0011!Q(QDA\u0001\u0002\u0004\u0001\b\u0002\u0003?\u0002h\u0006\u0005I\u0011I?\t\u0015\u0005-\u0011q]A\u0001\n\u0003\u00119\u0003\u0006\u0003\u0002\u0010\t%\u0002\u0002\u0003>\u0003&\u0005\u0005\t\u0019\u0001<\t\u0015\u0005e\u0011q]A\u0001\n\u0003\nY\u0002\u0003\u0006\u0002 \u0005\u001d\u0018\u0011!C!\u0003CA!\"!\n\u0002h\u0006\u0005I\u0011\tB\u0019)\u0011\tyAa\r\t\u0011i\u0014y#!AA\u0002Y<\u0011Ba\u000e&\u0003\u0003E\tA!\u000f\u0002\u0015\u0019KG.Z#oi&$\u0018\u0010E\u0002J\u0005w1\u0011\"!;&\u0003\u0003E\tA!\u0010\u0014\u000b\tm\"qH\u001f\u0011\u0013\u0005]\u0012QHAy+\t\u0005\u0001b\u0002\u0015\u0003<\u0011\u0005!1\t\u000b\u0003\u0005sA!\"a\b\u0003<\u0005\u0005IQIA\u0011\u0011%i#1HA\u0001\n\u0003\u0013I\u0005\u0006\u0004\u0003\u0002\t-#Q\n\u0005\bc\t\u001d\u0003\u0019AAy\u0011\u0019\u0019\"q\ta\u0001+!Q\u0011\u0011\u000bB\u001e\u0003\u0003%\tI!\u0015\u0015\t\tM#q\u000b\t\u0005\u001bY\u0011)\u0006\u0005\u0004\u000e\u00033\n\t0\u0006\u0005\u000b\u0003?\u0012y%!AA\u0002\t\u0005\u0001BCA2\u0005w\t\t\u0011\"\u0003\u0002f\u001dI!QL\u0013\u0002\u0002#\u0005!qL\u0001\u0010\u0005f$X-\u0011:sCf,e\u000e^5usB\u0019\u0011J!\u0019\u0007\u0011\u0011*\u0013\u0011!E\u0001\u0005G\u001aRA!\u0019\u0003fu\u0002\u0012\"a\u000e\u0002>\t\u001dTCa\u001d\u0011\u000b5\u0011IG!\u001c\n\u0007\t-dBA\u0003BeJ\f\u0017\u0010E\u0002\u000e\u0005_J1A!\u001d\u000f\u0005\u0011\u0011\u0015\u0010^3\u0011\u0005%\u001b\u0003b\u0002\u0015\u0003b\u0011\u0005!q\u000f\u000b\u0003\u0005?B!\"a\b\u0003b\u0005\u0005IQIA\u0011\u0011%i#\u0011MA\u0001\n\u0003\u0013i\b\u0006\u0004\u0003t\t}$\u0011\u0011\u0005\bc\tm\u0004\u0019\u0001B4\u0011\u0019\u0019\"1\u0010a\u0001+!Q\u0011\u0011\u000bB1\u0003\u0003%\tI!\"\u0015\t\t\u001d%1\u0012\t\u0005\u001bY\u0011I\t\u0005\u0004\u000e\u00033\u00129'\u0006\u0005\u000b\u0003?\u0012\u0019)!AA\u0002\tM\u0004BCA2\u0005C\n\t\u0011\"\u0003\u0002fM)1\u0005D\u0018;{!I\u0011g\tBK\u0002\u0013\u0005!1S\u000b\u0003\u0005OB\u0011BQ\u0012\u0003\u0012\u0003\u0006IAa\u001a\t\u0011M\u0019#Q3A\u0005\u0002QA\u0001\"R\u0012\u0003\u0012\u0003\u0006I!\u0006\u0005\u0007Q\r\"\tA!(\u0015\r\tM$q\u0014BQ\u0011\u001d\t$1\u0014a\u0001\u0005OBaa\u0005BN\u0001\u0004)\u0002\"\u0002\u0011$\t\u0003\t\u0003\u0002\u0003($\u0003\u0003%\tAa*\u0015\r\tM$\u0011\u0016BV\u0011%\t$Q\u0015I\u0001\u0002\u0004\u00119\u0007\u0003\u0005\u0014\u0005K\u0003\n\u00111\u0001\u0016\u0011!\u00196%%A\u0005\u0002\t=VC\u0001BYU\r\u00119G\u0016\u0005\bA\u000e\n\n\u0011\"\u0001b\u0011\u001d!7%!A\u0005B\u0015DqA\\\u0012\u0002\u0002\u0013\u0005q\u000e\u0003\u0005uG\u0005\u0005I\u0011\u0001B^)\r1(Q\u0018\u0005\tu\ne\u0016\u0011!a\u0001a\"9ApIA\u0001\n\u0003j\b\"CA\u0006G\u0005\u0005I\u0011\u0001Bb)\u0011\tyA!2\t\u0011i\u0014\t-!AA\u0002YD\u0011\"!\u0007$\u0003\u0003%\t%a\u0007\t\u0013\u0005}1%!A\u0005B\u0005\u0005\u0002\"CA\u0013G\u0005\u0005I\u0011\tBg)\u0011\tyAa4\t\u0011i\u0014Y-!AA\u0002Y<aAa5\u0003\u0011\u0003Q\u0013A\u0003%uiB,e\u000e^5us\u0002")
public interface HttpEntity {
    public Option<String> contentCharset();

    public String get();

    public static class FileEntity
    implements HttpEntity,
    Product,
    Serializable {
        private final File content;
        private final Option<String> contentCharset;

        public File content() {
            return this.content;
        }

        @Override
        public Option<String> contentCharset() {
            return this.contentCharset;
        }

        @Override
        public String get() {
            return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.content().toPath())).asScala()).mkString("\n");
        }

        public FileEntity copy(File content, Option<String> contentCharset) {
            return new FileEntity(content, contentCharset);
        }

        public File copy$default$1() {
            return this.content();
        }

        public Option<String> copy$default$2() {
            return this.contentCharset();
        }

        public String productPrefix() {
            return "FileEntity";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.contentCharset();
                    break;
                }
                case 0: {
                    object = this.content();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FileEntity;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FileEntity)) return false;
            boolean bl = true;
            if (!bl) return false;
            FileEntity fileEntity = (FileEntity)x$1;
            File file = this.content();
            File file2 = fileEntity.content();
            if (file == null) {
                if (file2 != null) {
                    return false;
                }
            } else if (!((Object)file).equals(file2)) return false;
            Option<String> option = this.contentCharset();
            Option<String> option2 = fileEntity.contentCharset();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!fileEntity.canEqual(this)) return false;
            return true;
        }

        public FileEntity(File content, Option<String> contentCharset) {
            this.content = content;
            this.contentCharset = contentCharset;
            Product.class.$init$((Product)this);
        }
    }

    public static class StringEntity
    implements HttpEntity,
    Product,
    Serializable {
        private final String content;
        private final Option<String> contentCharset;

        public String content() {
            return this.content;
        }

        @Override
        public Option<String> contentCharset() {
            return this.contentCharset;
        }

        @Override
        public String get() {
            return this.content();
        }

        public StringEntity copy(String content, Option<String> contentCharset) {
            return new StringEntity(content, contentCharset);
        }

        public String copy$default$1() {
            return this.content();
        }

        public Option<String> copy$default$2() {
            return this.contentCharset();
        }

        public String productPrefix() {
            return "StringEntity";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.contentCharset();
                    break;
                }
                case 0: {
                    object = this.content();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof StringEntity;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof StringEntity)) return false;
            boolean bl = true;
            if (!bl) return false;
            StringEntity stringEntity = (StringEntity)x$1;
            String string = this.content();
            String string2 = stringEntity.content();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Option<String> option = this.contentCharset();
            Option<String> option2 = stringEntity.contentCharset();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!stringEntity.canEqual(this)) return false;
            return true;
        }

        public StringEntity(String content, Option<String> contentCharset) {
            this.content = content;
            this.contentCharset = contentCharset;
            Product.class.$init$((Product)this);
        }
    }

    public static class ByteArrayEntity
    implements HttpEntity,
    Product,
    Serializable {
        private final byte[] content;
        private final Option<String> contentCharset;

        public byte[] content() {
            return this.content;
        }

        @Override
        public Option<String> contentCharset() {
            return this.contentCharset;
        }

        @Override
        public String get() {
            return new String(this.content(), (String)this.contentCharset().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "utf-8";
                }
            }));
        }

        public ByteArrayEntity copy(byte[] content, Option<String> contentCharset) {
            return new ByteArrayEntity(content, contentCharset);
        }

        public byte[] copy$default$1() {
            return this.content();
        }

        public Option<String> copy$default$2() {
            return this.contentCharset();
        }

        public String productPrefix() {
            return "ByteArrayEntity";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.contentCharset();
                    break;
                }
                case 0: {
                    object = this.content();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ByteArrayEntity;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ByteArrayEntity)) return false;
            boolean bl = true;
            if (!bl) return false;
            ByteArrayEntity byteArrayEntity = (ByteArrayEntity)x$1;
            if (this.content() != byteArrayEntity.content()) return false;
            Option<String> option = this.contentCharset();
            Option<String> option2 = byteArrayEntity.contentCharset();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!byteArrayEntity.canEqual(this)) return false;
            return true;
        }

        public ByteArrayEntity(byte[] content, Option<String> contentCharset) {
            this.content = content;
            this.contentCharset = contentCharset;
            Product.class.$init$((Product)this);
        }
    }

    public static class InputStreamEntity
    implements HttpEntity,
    Product,
    Serializable {
        private final InputStream content;
        private final Option<String> contentCharset;

        public InputStream content() {
            return this.content;
        }

        @Override
        public Option<String> contentCharset() {
            return this.contentCharset;
        }

        @Override
        public String get() {
            return Source$.MODULE$.fromInputStream(this.content(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("\n");
        }

        public InputStreamEntity copy(InputStream content, Option<String> contentCharset) {
            return new InputStreamEntity(content, contentCharset);
        }

        public InputStream copy$default$1() {
            return this.content();
        }

        public Option<String> copy$default$2() {
            return this.contentCharset();
        }

        public String productPrefix() {
            return "InputStreamEntity";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.contentCharset();
                    break;
                }
                case 0: {
                    object = this.content();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof InputStreamEntity;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof InputStreamEntity)) return false;
            boolean bl = true;
            if (!bl) return false;
            InputStreamEntity inputStreamEntity = (InputStreamEntity)x$1;
            InputStream inputStream = this.content();
            InputStream inputStream2 = inputStreamEntity.content();
            if (inputStream == null) {
                if (inputStream2 != null) {
                    return false;
                }
            } else if (!inputStream.equals(inputStream2)) return false;
            Option<String> option = this.contentCharset();
            Option<String> option2 = inputStreamEntity.contentCharset();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!inputStreamEntity.canEqual(this)) return false;
            return true;
        }

        public InputStreamEntity(InputStream content, Option<String> contentCharset) {
            this.content = content;
            this.contentCharset = contentCharset;
            Product.class.$init$((Product)this);
        }
    }
}

