/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android.common;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.logging.Logger;

public final class ArtifactResolverHelper {
    public static final List<String> EXCLUDE_NON_PACKAGED_SCOPES = Arrays.asList("provided", "import");
    private final ArtifactResolver artifactResolver;
    private final Logger log;
    private final List<ArtifactRepository> remoteArtifactRepositories;

    public ArtifactResolverHelper(ArtifactResolver artifactResolver, Logger log) {
        this(artifactResolver, log, Collections.emptyList());
    }

    public ArtifactResolverHelper(ArtifactResolver artifactResolver, Logger log, List<ArtifactRepository> remoteArtifactRepositories) {
        this.artifactResolver = artifactResolver;
        this.log = log;
        this.remoteArtifactRepositories = remoteArtifactRepositories;
    }

    public Set<Artifact> getFilteredArtifacts(Iterable<Artifact> allArtifacts, String ... types) {
        return this.getFilteredArtifacts(EXCLUDE_NON_PACKAGED_SCOPES, allArtifacts, types);
    }

    public Set<Artifact> getFilteredArtifacts(List<String> filteredScopes, Iterable<Artifact> allArtifacts, String ... types) {
        List<String> acceptTypeList = Arrays.asList(types);
        boolean acceptAllArtifacts = acceptTypeList.isEmpty();
        LinkedHashSet<Artifact> results = new LinkedHashSet<Artifact>();
        for (Artifact artifact : allArtifacts) {
            if (artifact == null || filteredScopes.contains(artifact.getScope()) || !acceptAllArtifacts && !acceptTypeList.contains(artifact.getType())) continue;
            results.add(artifact);
        }
        return results;
    }

    public File resolveArtifactToFile(Artifact artifact) throws MojoExecutionException {
        Artifact resolvedArtifact = this.resolveArtifact(artifact);
        File jar = resolvedArtifact.getFile();
        if (jar == null) {
            throw new MojoExecutionException("Could not resolve artifact " + artifact.getId() + ". Please install it with \"mvn install:install-file ...\" or deploy it to a repository with \"mvn deploy:deploy-file ...\"");
        }
        return jar;
    }

    public Set<Artifact> resolveArtifacts(Collection<Artifact> artifacts) throws MojoExecutionException {
        LinkedHashSet<Artifact> resolvedArtifacts = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            resolvedArtifacts.add(this.resolveArtifact(artifact));
        }
        return resolvedArtifacts;
    }

    private Artifact resolveArtifact(Artifact artifact) throws MojoExecutionException {
        ArtifactResolutionRequest artifactResolutionRequest = new ArtifactResolutionRequest();
        artifactResolutionRequest.setArtifact(artifact);
        if (this.remoteArtifactRepositories != null && !this.remoteArtifactRepositories.isEmpty()) {
            artifactResolutionRequest.setRemoteRepositories(this.remoteArtifactRepositories);
        }
        ArtifactResolutionResult resolutionResult = this.artifactResolver.resolve(artifactResolutionRequest);
        this.log.debug("Resolving : " + artifact);
        if (resolutionResult.getArtifacts().size() == 0) {
            throw new MojoExecutionException("Could not resolve artifact " + artifact + ". Please install it with \"mvn install:install-file ...\" or deploy it to a repository with \"mvn deploy:deploy-file ...\"");
        }
        if (resolutionResult.getArtifacts().size() > 1) {
            this.log.debug("Resolved artifacts : " + resolutionResult.getArtifacts());
            throw new MojoExecutionException("Could not resolve artifact " + artifact + " to single target. Found the following possible options : " + resolutionResult.getArtifacts());
        }
        Artifact resolvedArtifact = (Artifact)resolutionResult.getArtifacts().iterator().next();
        this.log.debug("Resolved : " + resolvedArtifact);
        return resolvedArtifact;
    }
}

