/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android;

import com.android.SdkConstants;
import com.android.repository.Revision;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.targets.AndroidTargetManager;
import com.simpligility.maven.plugins.android.InvalidSdkException;
import com.simpligility.maven.plugins.android.ProgressIndicatorImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;

public class AndroidSdk {
    private static final String DEFAULT_ANDROID_API_LEVEL = "23";
    private static final String SOURCE_PROPERTIES_FILENAME = "source.properties";
    private static final String SDK_TOOLS_REVISION_PROPERTY = "Pkg.Revision";
    private static final String PLATFORMS_FOLDER_NAME = "platforms";
    private static final String BIN_FOLDER_NAME_IN_TOOLS = "bin";
    private static final String PARAMETER_MESSAGE = "Please provide a proper Android SDK directory path as configuration parameter <sdk><path>...</path></sdk> in the plugin <configuration/>. As an alternative, you may add the parameter to commandline: -Dandroid.sdk.path=... or set environment variable ANDROID_HOME.";
    private final File sdkPath;
    private File platformToolsPath;
    private File toolsPath;
    private final IAndroidTarget androidTarget;
    private AndroidSdkHandler sdkManager;
    private int sdkMajorVersion;
    private String buildToolsVersion;
    private ProgressIndicatorImpl progressIndicator;

    public AndroidSdk(File sdkPath, String apiLevel) {
        this(sdkPath, apiLevel, null);
    }

    public AndroidSdk(File sdkPath, String apiLevel, String buildToolsVersion) {
        this.sdkPath = sdkPath;
        this.buildToolsVersion = buildToolsVersion;
        this.progressIndicator = new ProgressIndicatorImpl();
        if (sdkPath != null) {
            this.sdkManager = AndroidSdkHandler.getInstance((File)sdkPath);
            this.platformToolsPath = new File(sdkPath, "platform-tools");
            this.toolsPath = new File(sdkPath, "tools");
            if (this.sdkManager == null) {
                throw this.invalidSdkException(sdkPath, apiLevel);
            }
        }
        this.loadSDKToolsMajorVersion();
        if (apiLevel == null) {
            apiLevel = DEFAULT_ANDROID_API_LEVEL;
        }
        this.androidTarget = this.findPlatformByApiLevel(apiLevel);
        if (this.androidTarget == null) {
            throw this.invalidSdkException(sdkPath, apiLevel);
        }
    }

    private InvalidSdkException invalidSdkException(File sdkPath, String platformOrApiLevel) {
        throw new InvalidSdkException("Invalid SDK: Platform/API level " + platformOrApiLevel + " not available. This command should give you all you need:\n" + sdkPath.getAbsolutePath() + File.separator + "tools" + File.separator + "android update sdk --no-ui --obsolete --force");
    }

    private IAndroidTarget findPlatformByApiLevel(String apiLevel) {
        AndroidVersion version = null;
        try {
            version = new AndroidVersion(apiLevel);
            String hashString = AndroidTargetHash.getPlatformHashString((AndroidVersion)version);
            IAndroidTarget target = this.sdkManager.getAndroidTargetManager((ProgressIndicator)this.progressIndicator).getTargetFromHashString(hashString, (ProgressIndicator)this.progressIndicator);
            if (target != null && target.getLocation() != null) {
                return target;
            }
        }
        catch (AndroidVersion.AndroidVersionException ignore) {
            throw new InvalidSdkException("Error AndroidVersion: " + ignore.getMessage());
        }
        for (IAndroidTarget t : this.sdkManager.getAndroidTargetManager(null).getTargets(null)) {
            if (!t.isPlatform() || !apiLevel.equals(t.getVersionName())) continue;
            return t;
        }
        return null;
    }

    private void assertPathIsDirectory(File path) {
        if (path == null) {
            throw new InvalidSdkException(PARAMETER_MESSAGE);
        }
        if (!path.isDirectory()) {
            throw new InvalidSdkException("Path \"" + path + "\" is not a directory. " + PARAMETER_MESSAGE);
        }
    }

    public String getAaptPath() {
        return this.getPathForBuildTool(BuildToolInfo.PathId.AAPT);
    }

    public String getAidlPath() {
        return this.getPathForBuildTool(BuildToolInfo.PathId.AIDL);
    }

    public String getDxJarPath() {
        return this.getPathForBuildTool(BuildToolInfo.PathId.DX_JAR);
    }

    public String getD8JarPath() {
        File pathToDexJar = new File(this.getPathForBuildTool(BuildToolInfo.PathId.DX_JAR));
        File pathToD8Jar = new File(pathToDexJar.getParent(), "d8.jar");
        return pathToD8Jar.getAbsolutePath();
    }

    public String getProguardJarPath() {
        File directory = new File(this.getToolsPath(), "proguard" + File.separator + "lib" + File.separator);
        File proguardJar = new File(directory, "proguard.jar");
        if (proguardJar.exists()) {
            return proguardJar.getAbsolutePath();
        }
        throw new InvalidSdkException("Cannot find " + proguardJar);
    }

    public String getShrinkedAndroidJarPath() {
        File shrinkedAndroidJar = new File(this.getBuildToolsLibDirectoryPath(), "shrinkedAndroid.jar");
        if (shrinkedAndroidJar.exists()) {
            return shrinkedAndroidJar.getAbsolutePath();
        }
        throw new InvalidSdkException("Cannot find " + shrinkedAndroidJar);
    }

    public String getBuildToolsLibDirectoryPath() {
        File buildToolsLib = new File(this.getBuildToolInfo().getLocation(), "lib");
        if (buildToolsLib.exists()) {
            return buildToolsLib.getAbsolutePath();
        }
        throw new InvalidSdkException("Cannot find " + buildToolsLib);
    }

    public String getMainDexClassesRulesPath() {
        File mainDexClassesRules = new File(this.getBuildToolInfo().getLocation(), "mainDexClasses.rules");
        if (mainDexClassesRules.exists()) {
            return mainDexClassesRules.getAbsolutePath();
        }
        throw new InvalidSdkException("Cannot find " + mainDexClassesRules);
    }

    public void assertThatBuildToolsVersionIsAtLeast(String version, String feature) throws InvalidSdkException, NumberFormatException {
        if (this.getBuildToolInfo().getRevision().compareTo(Revision.parseRevision((String)version)) < 0) {
            throw new InvalidSdkException("Version of build tools must be at least " + version + " for " + feature + " to work");
        }
    }

    public String getAdbPath() {
        return this.getPathForPlatformTool(SdkConstants.FN_ADB);
    }

    public String getZipalignPath() {
        return this.getPathForBuildTool(BuildToolInfo.PathId.ZIP_ALIGN);
    }

    public String getLintPath() {
        return this.getPathForTool("bin/lint" + AndroidSdk.ext(".bat", ""));
    }

    public String getMonkeyRunnerPath() {
        return this.getPathForTool("bin/monkeyrunner" + AndroidSdk.ext(".bat", ""));
    }

    public String getApkBuilderPath() {
        return this.getPathForTool("apkbuilder" + AndroidSdk.ext(".bat", ""));
    }

    public String getAndroidPath() {
        String cmd = "android";
        String ext = SdkConstants.currentPlatform() == 2 ? ".bat" : "";
        return this.getPathForTool(cmd + ext);
    }

    public File getToolsPath() {
        return this.toolsPath;
    }

    private String getPathForBuildTool(BuildToolInfo.PathId pathId) {
        return this.getBuildToolInfo().getPath(pathId);
    }

    private BuildToolInfo getBuildToolInfo() {
        BuildToolInfo buildToolInfo;
        if (this.buildToolsVersion != null && !this.buildToolsVersion.equals("")) {
            BuildToolInfo buildToolInfo2 = this.sdkManager.getBuildToolInfo(Revision.parseRevision((String)this.buildToolsVersion), (ProgressIndicator)this.progressIndicator);
            if (buildToolInfo2 != null) {
                return buildToolInfo2;
            }
            throw new InvalidSdkException("Invalid SDK: Build-tools " + this.buildToolsVersion + " not found. Check your Android SDK to install the build tools " + this.buildToolsVersion);
        }
        if (this.androidTarget != null && (buildToolInfo = this.androidTarget.getBuildToolInfo()) != null) {
            return buildToolInfo;
        }
        BuildToolInfo latestBuildToolInfo = this.sdkManager.getLatestBuildTool((ProgressIndicator)this.progressIndicator, true);
        if (latestBuildToolInfo == null) {
            throw new InvalidSdkException("Invalid SDK: Build-tools not found. Check the content of '" + this.sdkPath.getAbsolutePath() + File.separator + "build-tools', or run '" + this.sdkPath.getAbsolutePath() + File.separator + "tools" + File.separator + "android sdk' to install them");
        }
        return latestBuildToolInfo;
    }

    private String getPathForPlatformTool(String tool) {
        return new File(this.platformToolsPath, tool).getAbsolutePath();
    }

    private String getPathForTool(String tool) {
        return new File(this.toolsPath, tool).getAbsolutePath();
    }

    private static String ext(String windowsExtension, String nonWindowsExtension) {
        if (SdkConstants.currentPlatform() == 2) {
            return windowsExtension;
        }
        return nonWindowsExtension;
    }

    public String getPathForFrameworkAidl() {
        return this.androidTarget.getPath(2);
    }

    public File getAndroidJar() throws MojoExecutionException {
        String androidJarPath = this.androidTarget.getPath(1);
        if (androidJarPath == null) {
            throw new MojoExecutionException("No AndroidJar found for " + this.androidTarget.getLocation());
        }
        return new File(androidJarPath);
    }

    public File getSdkPath() throws MojoExecutionException {
        if (this.sdkPath.exists()) {
            return this.sdkPath;
        }
        throw new MojoExecutionException("Can't find the SDK directory : " + this.sdkPath.getAbsolutePath());
    }

    public File getPlatform() {
        File platformDirectory;
        this.assertPathIsDirectory(this.sdkPath);
        File platformsDirectory = new File(this.sdkPath, PLATFORMS_FOLDER_NAME);
        this.assertPathIsDirectory(platformsDirectory);
        if (this.androidTarget == null) {
            IAndroidTarget latestTarget = null;
            AndroidTargetManager targetManager = this.sdkManager.getAndroidTargetManager((ProgressIndicator)this.progressIndicator);
            for (IAndroidTarget target : targetManager.getTargets((ProgressIndicator)this.progressIndicator)) {
                if (!target.isPlatform() || latestTarget != null && target.getVersion().getApiLevel() <= latestTarget.getVersion().getApiLevel()) continue;
                latestTarget = target;
            }
            platformDirectory = new File(latestTarget.getLocation());
        } else {
            platformDirectory = new File(this.androidTarget.getLocation());
        }
        this.assertPathIsDirectory(platformDirectory);
        return platformDirectory;
    }

    private void loadSDKToolsMajorVersion() {
        File propFile = new File(this.sdkPath, "tools/source.properties");
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(propFile));
        }
        catch (IOException e) {
            throw new InvalidSdkException("Error reading " + propFile.getAbsoluteFile());
        }
        if (properties.containsKey(SDK_TOOLS_REVISION_PROPERTY)) {
            try {
                String majorVersion;
                String versionString = properties.getProperty(SDK_TOOLS_REVISION_PROPERTY);
                if (versionString.matches(".*[\\.| ].*")) {
                    String[] versions = versionString.split("[\\.| ]");
                    majorVersion = versions[0];
                } else {
                    majorVersion = versionString;
                }
                this.sdkMajorVersion = Integer.parseInt(majorVersion);
            }
            catch (NumberFormatException e) {
                throw new InvalidSdkException("Error - The property 'Pkg.Revision' in the SDK source.properties file  number is not an Integer: " + properties.getProperty(SDK_TOOLS_REVISION_PROPERTY));
            }
        }
    }

    public int getSdkMajorVersion() {
        return this.sdkMajorVersion;
    }
}

