/*
 * Decompiled with CFR 0.152.
 */
package com.simpligility.maven.plugins.android;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.simpligility.maven.plugins.android.AbstractAndroidMojo;
import com.simpligility.maven.plugins.android.CommandExecutor;
import com.simpligility.maven.plugins.android.common.DeviceHelper;
import com.simpligility.maven.plugins.android.configuration.Emulator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractEmulatorMojo
extends AbstractAndroidMojo {
    public static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    private static final int MILLIS_TO_SLEEP_BETWEEN_DEVICE_ONLINE_CHECKS = 200;
    private static final int MILLIS_TO_SLEEP_BETWEEN_SYS_BOOTED_CHECKS = 5000;
    private static final String[] BOOT_INDICATOR_PROP_NAMES = new String[]{"dev.bootcomplete", "sys.boot_completed", "init.svc.bootanim"};
    private static final String[] BOOT_INDICATOR_PROP_TARGET_VALUES = new String[]{"1", "1", "stopped"};
    private static final boolean[] BOOT_INDICATOR_PROP_WAIT_FOR = new boolean[]{false, false, true};
    private static final long START_TIMEOUT_REMAINING_TIME_WARNING_THRESHOLD = 5000L;
    @Parameter
    private Emulator emulator;
    @Parameter(property="android.emulator.avd")
    private String emulatorAvd;
    @Parameter(property="android.emulatorUnlock", defaultValue="false")
    private boolean emulatorUnlock;
    @Parameter(property="android.emulator.wait")
    private String emulatorWait;
    @Parameter(property="android.emulator.options")
    private String emulatorOptions;
    @Parameter(property="android.emulator.executable")
    private String emulatorExecutable;
    @Parameter(property="android.emulator.location")
    private String emulatorLocation;
    private String parsedAvd;
    private String parsedOptions;
    private String parsedWait;
    private String parsedExecutable;
    private String parsedEmulatorLocation;
    private static final String START_EMULATOR_MSG = "Starting android emulator with script: ";
    private static final String START_EMULATOR_WAIT_MSG = "Waiting for emulator start:";
    private static final String SCRIPT_FOLDER = System.getProperty("java.io.tmpdir");

    private boolean isWindows() {
        boolean result = OS_NAME.toLowerCase().contains("windows");
        this.getLog().debug((CharSequence)("isWindows: " + result));
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void startAndroidEmulator() throws MojoExecutionException {
        this.parseParameters();
        CommandExecutor executor = CommandExecutor.Factory.createDefaultCommmandExecutor();
        executor.setLogger(this.getLog());
        try {
            String filename = this.isWindows() ? this.writeEmulatorStartScriptWindows() : this.writeEmulatorStartScriptUnix();
            AndroidDebugBridge androidDebugBridge = this.initAndroidDebugBridge();
            if (!androidDebugBridge.isConnected()) return;
            this.waitForInitialDeviceList(androidDebugBridge);
            List<IDevice> devices = Arrays.asList(androidDebugBridge.getDevices());
            int numberOfDevices = devices.size();
            this.getLog().info((CharSequence)("Found " + numberOfDevices + " devices connected with the Android Debug Bridge"));
            IDevice existingEmulator = this.findExistingEmulator(devices);
            if (existingEmulator == null) {
                this.getLog().info((CharSequence)(START_EMULATOR_MSG + filename));
                executor.executeCommand(filename, null);
                this.getLog().info((CharSequence)(START_EMULATOR_WAIT_MSG + this.parsedWait));
                boolean booted = this.waitUntilDeviceIsBootedOrTimeout(androidDebugBridge);
                if (!booted) throw new MojoExecutionException("Timeout while waiting for emulator to startup.");
                this.getLog().info((CharSequence)"Emulator is up and running.");
                this.unlockEmulator(androidDebugBridge);
                return;
            } else {
                this.getLog().info((CharSequence)String.format("Emulator already running [Serial No: '%s', AVD Name '%s']. Skipping start and wait.", existingEmulator.getSerialNumber(), existingEmulator.getAvdName()));
            }
            return;
        }
        catch (Exception e) {
            throw new MojoExecutionException("", e);
        }
    }

    void unlockEmulator(AndroidDebugBridge androidDebugBridge) {
        if (this.emulatorUnlock) {
            IDevice myEmulator = this.findExistingEmulator(Arrays.asList(androidDebugBridge.getDevices()));
            int devicePort = this.extractPortFromDevice(myEmulator);
            if (devicePort == -1) {
                this.getLog().info((CharSequence)("Unable to retrieve port to unlock emulator " + DeviceHelper.getDescriptiveName(myEmulator)));
            } else {
                this.getLog().info((CharSequence)("Unlocking emulator " + DeviceHelper.getDescriptiveName(myEmulator)));
                this.sendEmulatorCommand(devicePort, "event send EV_KEY:KEY_SOFT1:1");
                this.sendEmulatorCommand(devicePort, "event send EV_KEY:KEY_SOFT1:0");
                this.sendEmulatorCommand(devicePort, "event send EV_KEY:KEY_SOFT1:1");
                this.sendEmulatorCommand(devicePort, "event send EV_KEY:KEY_SOFT1:0");
            }
        }
    }

    boolean waitUntilDeviceIsBootedOrTimeout(AndroidDebugBridge androidDebugBridge) throws MojoExecutionException {
        IDevice myEmulator;
        boolean devOnline;
        long timeout = System.currentTimeMillis() + Long.parseLong(this.parsedWait);
        boolean sysBootCompleted = false;
        long remainingTime = 0L;
        boolean waitingForConnection = false;
        do {
            boolean bl = devOnline = (myEmulator = this.findExistingEmulator(Arrays.asList(androidDebugBridge.getDevices()))) != null && myEmulator.isOnline();
            if (devOnline) break;
            myEmulator = null;
            if (!waitingForConnection) {
                waitingForConnection = true;
                this.getLog().info((CharSequence)"Waiting for the device to go online...");
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                throw new MojoExecutionException("Interrupted waiting for device to become ready");
            }
        } while ((remainingTime = timeout - System.currentTimeMillis()) > 0L);
        if (devOnline) {
            boolean waitingForBootCompleted = false;
            String[] bootIndicatorPropValues = new String[BOOT_INDICATOR_PROP_NAMES.length];
            boolean anyTargetStateReached = false;
            boolean requiredTargetStatesReached = false;
            do {
                try {
                    anyTargetStateReached = false;
                    requiredTargetStatesReached = true;
                    for (int indicatorProp = 0; indicatorProp < BOOT_INDICATOR_PROP_NAMES.length; ++indicatorProp) {
                        boolean targetStateReached;
                        boolean bl = targetStateReached = bootIndicatorPropValues[indicatorProp] != null && bootIndicatorPropValues[indicatorProp].equals(BOOT_INDICATOR_PROP_TARGET_VALUES[indicatorProp]);
                        if (!targetStateReached) {
                            bootIndicatorPropValues[indicatorProp] = myEmulator.getPropertySync(BOOT_INDICATOR_PROP_NAMES[indicatorProp]);
                            targetStateReached = bootIndicatorPropValues[indicatorProp] != null && bootIndicatorPropValues[indicatorProp].equals(BOOT_INDICATOR_PROP_TARGET_VALUES[indicatorProp]);
                        }
                        anyTargetStateReached |= targetStateReached;
                        requiredTargetStatesReached &= BOOT_INDICATOR_PROP_WAIT_FOR[indicatorProp] ? targetStateReached : true;
                        this.getLog().debug((CharSequence)(BOOT_INDICATOR_PROP_NAMES[indicatorProp] + " : " + bootIndicatorPropValues[indicatorProp] + (targetStateReached ? " == " : " != ") + BOOT_INDICATOR_PROP_TARGET_VALUES[indicatorProp] + " [" + (targetStateReached ? "OK" : "PENDING") + ']'));
                    }
                }
                catch (TimeoutException indicatorProp) {
                }
                catch (AdbCommandRejectedException indicatorProp) {
                }
                catch (ShellCommandUnresponsiveException indicatorProp) {
                }
                catch (IOException e) {
                    throw new MojoExecutionException("IO error during status request", (Exception)e);
                }
                remainingTime = timeout - System.currentTimeMillis();
                sysBootCompleted = remainingTime > 0L ? requiredTargetStatesReached : anyTargetStateReached;
                if (remainingTime <= 0L || sysBootCompleted) continue;
                if (!waitingForBootCompleted) {
                    waitingForBootCompleted = true;
                    this.getLog().info((CharSequence)"Waiting for the device to finish booting...");
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    throw new MojoExecutionException("Interrupted while waiting for the device to finish booting");
                }
            } while (!sysBootCompleted && remainingTime > 0L);
            if (sysBootCompleted && remainingTime < 5000L) {
                this.getLog().warn((CharSequence)("Boot indicators have been signalled, but remaining time was " + remainingTime + " ms"));
            }
        }
        return sysBootCompleted;
    }

    private IDevice findExistingEmulator(List<IDevice> devices) {
        IDevice existingEmulator = null;
        for (IDevice device : devices) {
            if (!device.isEmulator() || !this.isExistingEmulator(device)) continue;
            existingEmulator = device;
            break;
        }
        return existingEmulator;
    }

    private boolean isExistingEmulator(IDevice device) {
        return device.getAvdName() != null && device.getAvdName().equalsIgnoreCase(this.parsedAvd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeEmulatorStartScriptWindows() throws MojoExecutionException {
        String filename = SCRIPT_FOLDER + "\\android-maven-plugin-emulator-start.vbs";
        File file = new File(filename);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(file));
            String command = this.assembleStartCommandLine();
            String uniqueWindowTitle = "AndroidMavenPlugin-AVD" + this.parsedAvd;
            writer.println("Dim oShell");
            writer.println("Set oShell = WScript.CreateObject(\"WScript.shell\")");
            String cmdPath = System.getenv("COMSPEC");
            if (cmdPath == null) {
                cmdPath = "cmd.exe";
            }
            String cmd = cmdPath + " /X /C START /SEPARATE \"\"" + uniqueWindowTitle + "\"\"  " + command.trim();
            writer.println("oShell.run \"" + cmd + "\"");
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Failure writing file " + filename));
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        file.setExecutable(true);
        return filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeEmulatorStartScriptUnix() throws MojoExecutionException {
        String filename = SCRIPT_FOLDER + "/android-maven-plugin-emulator-start.sh";
        File sh = new File("/bin/bash");
        if (!sh.exists()) {
            sh = new File("/usr/bin/bash");
        }
        if (!sh.exists()) {
            sh = new File("/bin/sh");
        }
        File file = new File(filename);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(file));
            writer.println("#!" + sh.getAbsolutePath());
            writer.print(this.assembleStartCommandLine());
            writer.print(" 1>/dev/null 2>&1 &");
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Failure writing file " + filename));
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        file.setExecutable(true);
        return filename;
    }

    protected void stopAndroidEmulator() throws MojoExecutionException {
        this.parseParameters();
        AndroidDebugBridge androidDebugBridge = this.initAndroidDebugBridge();
        if (androidDebugBridge.isConnected()) {
            List<IDevice> devices = Arrays.asList(androidDebugBridge.getDevices());
            int numberOfDevices = devices.size();
            this.getLog().info((CharSequence)("Found " + numberOfDevices + " devices connected with the Android Debug Bridge"));
            for (IDevice device : devices) {
                if (device.isEmulator()) {
                    if (!this.isExistingEmulator(device)) continue;
                    this.stopEmulator(device);
                    continue;
                }
                this.getLog().info((CharSequence)("Skipping stop. Not an emulator. " + DeviceHelper.getDescriptiveName(device)));
            }
        }
    }

    protected void stopAndroidEmulators() throws MojoExecutionException {
        AndroidDebugBridge androidDebugBridge = this.initAndroidDebugBridge();
        if (androidDebugBridge.isConnected()) {
            List<IDevice> devices = Arrays.asList(androidDebugBridge.getDevices());
            int numberOfDevices = devices.size();
            this.getLog().info((CharSequence)("Found " + numberOfDevices + " devices connected with the Android Debug Bridge"));
            for (IDevice device : devices) {
                if (device.isEmulator()) {
                    this.stopEmulator(device);
                    continue;
                }
                this.getLog().info((CharSequence)("Skipping stop. Not an emulator. " + DeviceHelper.getDescriptiveName(device)));
            }
        }
    }

    private void stopEmulator(IDevice device) {
        int devicePort = this.extractPortFromDevice(device);
        if (devicePort == -1) {
            this.getLog().info((CharSequence)("Unable to retrieve port to stop emulator " + DeviceHelper.getDescriptiveName(device)));
        } else {
            this.getLog().info((CharSequence)("Stopping emulator " + DeviceHelper.getDescriptiveName(device)));
            this.sendEmulatorCommand(devicePort, "avd stop");
            boolean killed = this.sendEmulatorCommand(devicePort, "kill");
            if (!killed) {
                this.getLog().info((CharSequence)("Emulator failed to stop " + DeviceHelper.getDescriptiveName(device)));
            } else {
                this.getLog().info((CharSequence)("Emulator stopped successfully " + DeviceHelper.getDescriptiveName(device)));
            }
        }
    }

    private int extractPortFromDevice(IDevice device) {
        String portStr = StringUtils.substringAfterLast((String)device.getSerialNumber(), (String)"-");
        if (StringUtils.isNotBlank((CharSequence)portStr) && StringUtils.isNumeric((CharSequence)portStr)) {
            return Integer.parseInt(portStr);
        }
        return -1;
    }

    private boolean sendEmulatorCommand(final int port, final String command) {
        Callable<Boolean> task = new Callable<Boolean>(){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws IOException {
                Socket socket = null;
                BufferedReader in = null;
                PrintWriter out = null;
                try {
                    socket = new Socket("127.0.0.1", port);
                    out = new PrintWriter(socket.getOutputStream(), true);
                    in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    if (in.readLine() == null) {
                        Boolean bl = false;
                        return bl;
                    }
                    out.write(command);
                    out.write("\r\n");
                }
                finally {
                    try {
                        out.close();
                        in.close();
                        socket.close();
                    }
                    catch (Exception exception) {}
                }
                return true;
            }
        };
        boolean result = false;
        try {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Future<Boolean> future = executor.submit(task);
            result = future.get();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)String.format("Failed to execute emulator command '%s': %s", command, e));
        }
        return result;
    }

    private String assembleStartCommandLine() throws MojoExecutionException {
        String emulatorPath = !"SdkTools".equals(this.parsedEmulatorLocation) ? new File(this.parsedEmulatorLocation, this.parsedExecutable).getAbsolutePath() : new File(this.getAndroidSdk().getToolsPath(), this.parsedExecutable).getAbsolutePath();
        StringBuilder startCommandline = new StringBuilder("\"\"").append(emulatorPath).append("\"\"").append(" -avd ").append(this.parsedAvd).append(" ");
        if (!StringUtils.isEmpty((CharSequence)this.parsedOptions)) {
            startCommandline.append(this.parsedOptions);
        }
        this.getLog().info((CharSequence)("Android emulator command: " + startCommandline));
        return startCommandline.toString();
    }

    private void parseParameters() {
        if (this.emulator != null) {
            this.parsedAvd = this.emulator.getAvd() != null ? this.emulator.getAvd() : this.determineAvd();
            this.parsedOptions = this.emulator.getOptions() != null ? this.emulator.getOptions() : this.determineOptions();
            this.parsedWait = this.emulator.getWait() != null ? this.emulator.getWait() : this.determineWait();
            this.parsedExecutable = this.emulator.getExecutable() != null ? this.emulator.getExecutable() : this.determineExecutable();
            this.parsedEmulatorLocation = this.emulator.getLocation() != null ? this.emulator.getLocation() : this.determineEmulatorLocation();
        } else {
            this.parsedAvd = this.determineAvd();
            this.parsedOptions = this.determineOptions();
            this.parsedWait = this.determineWait();
            this.parsedExecutable = this.determineExecutable();
            this.parsedEmulatorLocation = this.determineEmulatorLocation();
        }
    }

    private String determineExecutable() {
        String emulator = this.emulatorExecutable != null ? this.emulatorExecutable : "emulator";
        return emulator;
    }

    String determineWait() {
        String wait = this.emulatorWait != null ? this.emulatorWait : "5000";
        return wait;
    }

    private String determineOptions() {
        String options = this.emulatorOptions != null ? this.emulatorOptions : "";
        return options;
    }

    String determineAvd() {
        String avd = this.emulatorAvd != null ? this.emulatorAvd : "Default";
        return avd;
    }

    String determineEmulatorLocation() {
        String location = this.emulatorLocation != null ? this.emulatorLocation : "SdkTools";
        return location;
    }
}

