/*
 * Decompiled with CFR 0.152.
 */
package com.shazam.shazamcrest;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;

public class CyclicReferenceDetector {
    private Set<Object> nodesInPaths = Collections.newSetFromMap(new IdentityHashMap());
    private Set<Object> objectsWithCircularReferences = Collections.newSetFromMap(new IdentityHashMap());

    public static Set<Class<?>> getClassesWithCircularReferences(Object object) {
        CyclicReferenceDetector cyclicReferenceDetector = new CyclicReferenceDetector();
        if (object != null) {
            cyclicReferenceDetector.detectCircularReferenceOnObject(object);
        }
        return CyclicReferenceDetector.getClasses(cyclicReferenceDetector.objectsWithCircularReferences);
    }

    private static Set<Class<?>> getClasses(Set<Object> objects) {
        HashSet circularReferenceTypes = new HashSet();
        for (Object objectInPath : objects) {
            circularReferenceTypes.add(objectInPath.getClass());
        }
        return circularReferenceTypes;
    }

    private void detectCircularReferenceOnFields(Object object, Class<?> clazz) {
        if (this.objectsWithCircularReferences.contains(object)) {
            return;
        }
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                Object fieldValue = field.get(object);
                if (fieldValue == null) continue;
                this.detectCircularReferenceOnObject(fieldValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        this.detectCircularReferencesFromTheSuperClass(object, clazz);
    }

    private void detectCircularReferenceOnObject(Object object) {
        boolean isValid = this.validateAnObject(object);
        boolean isInPath = this.nodesInPaths.contains(object);
        if (!isValid && isInPath) {
            return;
        }
        if (isInPath) {
            this.objectsWithCircularReferences.add(object);
            return;
        }
        if (object instanceof Iterable) {
            this.nodesInPaths.add(object);
            this.detectCircularReferenceFromObjectsContainedInAnIterable((Iterable)object);
        } else if (object instanceof Map) {
            this.nodesInPaths.add(object);
            this.detectCircularReferencesFromObjectsInAMap((Map)object);
        }
        if (isValid) {
            this.nodesInPaths.add(object);
            this.detectCircularReferenceOnFields(object, object.getClass());
            this.nodesInPaths.remove(object);
        }
    }

    private void detectCircularReferencesFromTheSuperClass(Object object, Class<?> clazz) {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null && this.validateAnObject(object)) {
            this.detectCircularReferenceOnFields(object, superclass);
        }
    }

    private void detectCircularReferencesFromObjectsInAMap(Map<Object, Object> map) {
        this.detectCircularReferenceFromObjectsContainedInAnIterable(map.values());
        this.detectCircularReferenceFromObjectsContainedInAnIterable(map.keySet());
    }

    private void detectCircularReferenceFromObjectsContainedInAnIterable(Iterable<Object> iterable) {
        for (Object elementInCollection : iterable) {
            if (elementInCollection == null) continue;
            this.detectCircularReferenceOnObject(elementInCollection);
        }
    }

    private boolean validateAnObject(Object object) {
        return !ClassUtils.isPrimitiveOrWrapper(object.getClass()) && object.getClass() != String.class && object.getClass() != Class.class && !(object instanceof Iterable) && !(object instanceof Map) && !(object instanceof Enum);
    }
}

