/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;

public class Scope {
    private JsonNode[] globalStackFrame;
    private Deque<JsonNode[]> localStackFrames;
    private static final int BITMASK = 0x10000000;
    private static final int INVERSE = -268435457;

    public static Scope getRoot(int stackFrameSize) {
        return new Scope(stackFrameSize);
    }

    public static Scope makeScope(Map<String, JsonNode> variables, int stackFrameSize, Map<String, Integer> parameterSlots) {
        Scope scope = new Scope(stackFrameSize);
        for (String variable : variables.keySet()) {
            if (!parameterSlots.containsKey(variable)) continue;
            scope.setValue(parameterSlots.get(variable), variables.get(variable));
        }
        return scope;
    }

    public Scope(int stackFrameSize) {
        this.globalStackFrame = new JsonNode[stackFrameSize];
        this.localStackFrames = new ArrayDeque<JsonNode[]>();
    }

    public void enterFunction(int stackFrameSize) {
        this.localStackFrames.push(new JsonNode[stackFrameSize]);
    }

    public void leaveFunction() {
        this.localStackFrames.pop();
    }

    public JsonNode getValue(int slot) {
        if ((slot & 0x10000000) != 0) {
            return this.globalStackFrame[slot & 0xEFFFFFFF];
        }
        return this.localStackFrames.peek()[slot];
    }

    public void setValue(int slot, JsonNode value) {
        if ((slot & 0x10000000) != 0) {
            this.globalStackFrame[slot & 0xEFFFFFFF] = value;
        } else {
            this.localStackFrames.peek()[slot] = value;
        }
    }
}

