/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.ResourceResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;

public final class FileSystemResourceResolver
implements ResourceResolver {
    private File rootPath;
    private Charset charset;

    public FileSystemResourceResolver(File rootPath, Charset charset) {
        this.rootPath = rootPath;
        this.charset = charset;
    }

    public FileSystemResourceResolver(File rootPath) {
        this(rootPath, StandardCharsets.UTF_8);
    }

    public FileSystemResourceResolver(Path rootPath, Charset charset) {
        this.rootPath = rootPath.toAbsolutePath().toFile();
        this.charset = charset;
    }

    public FileSystemResourceResolver(Path rootPath) {
        this(rootPath.toFile(), StandardCharsets.UTF_8);
    }

    public FileSystemResourceResolver(Charset charset) {
        this((File)null, charset);
    }

    public FileSystemResourceResolver() {
        this((File)null, StandardCharsets.UTF_8);
    }

    @Override
    public Reader resolve(String jslt) {
        try {
            File file = new File(this.rootPath, jslt);
            FileInputStream is = new FileInputStream(file);
            return new InputStreamReader((InputStream)is, this.charset);
        }
        catch (IOException e) {
            throw new JsltException("Could not resolve file '" + jslt + "': " + e, e);
        }
    }
}

