/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.spt.data.jslt.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.schibsted.spt.data.jslt.JsltException;
import com.schibsted.spt.data.jslt.impl.AbstractNode;
import com.schibsted.spt.data.jslt.impl.Location;
import com.schibsted.spt.data.jslt.impl.NodeUtils;
import com.schibsted.spt.data.jslt.impl.Scope;

public class LiteralExpression
extends AbstractNode {
    private JsonNode value;

    public LiteralExpression(JsonNode value, Location location) {
        super(location);
        this.value = value;
    }

    @Override
    public JsonNode apply(Scope scope, JsonNode input) {
        return this.value;
    }

    @Override
    public void dump(int level) {
        System.out.println(NodeUtils.indent(level) + this.value);
    }

    public String toString() {
        try {
            return NodeUtils.mapper.writeValueAsString((Object)this.value);
        }
        catch (JsonProcessingException e) {
            throw new JsltException("Couldn't serialize literal value: " + (Object)((Object)e));
        }
    }
}

