/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.FetchInfo;
import com.sap.db.jdbc.HanaResultSet;
import com.sap.db.jdbc.HanaResultSetClean;
import com.sap.db.jdbc.HanaResultSetFinalize;
import com.sap.db.jdbc.HanaResultSetPhantom;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.trace.TraceRecord;
import java.sql.SQLException;
import java.util.regex.Pattern;

@ThreadSafe
public interface StatementSapDB9Interface {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public String enquoteLiteral(StatementSapDB statementSapDB, String string) throws SQLException {
        boolean bl = statementSapDB._tracer.on();
        boolean bl2 = statementSapDB._tracer.pon();
        TraceRecord traceRecord = bl2 ? statementSapDB._newTraceRecord("Statement", "enquoteLiteral") : null;
        try {
            if (bl) {
                statementSapDB._tracer.printCall(this, "enquoteLiteral", string);
            }
            String string2 = "'" + string.replace("'", "''") + "'";
            return string2;
        }
        finally {
            if (bl2) {
                statementSapDB._publish(traceRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public String enquoteNCharLiteral(StatementSapDB statementSapDB, String string) throws SQLException {
        boolean bl = statementSapDB._tracer.on();
        boolean bl2 = statementSapDB._tracer.pon();
        TraceRecord traceRecord = bl2 ? statementSapDB._newTraceRecord("Statement", "enquoteNCharLiteral") : null;
        try {
            if (bl) {
                statementSapDB._tracer.printCall(this, "enquoteNCharLiteral", string);
            }
            String string2 = "N'" + string.replace("'", "''") + "'";
            return string2;
        }
        finally {
            if (bl2) {
                statementSapDB._publish(traceRecord);
            }
        }
    }

    default public String enquoteIdentifier(StatementSapDB statementSapDB, String string, boolean bl) throws SQLException {
        boolean bl2 = statementSapDB._tracer.on();
        boolean bl3 = statementSapDB._tracer.pon();
        TraceRecord traceRecord = bl3 ? statementSapDB._newTraceRecord("Statement", "enquoteIdentifier") : null;
        try {
            int n;
            if (bl2) {
                statementSapDB._tracer.printCall(this, "enquoteIdentifier", string, bl);
            }
            if ((n = string.length()) < 1 || n > 127) {
                throw new SQLException("Invalid name");
            }
            if (Pattern.compile("[\\p{Alpha}][\\p{Alnum}_]*").matcher(string).matches()) {
                Object object = bl ? "\"" + string + "\"" : string;
                return object;
            }
            if (string.matches("^\".+\"$")) {
                string = string.substring(1, n - 1);
            }
            if (Pattern.compile("[^\u0000\"]+").matcher(string).matches()) {
                String string2 = "\"" + string + "\"";
                return string2;
            }
            throw new SQLException("Invalid name");
        }
        finally {
            if (bl3) {
                statementSapDB._publish(traceRecord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean isSimpleIdentifier(StatementSapDB statementSapDB, String string) throws SQLException {
        boolean bl = statementSapDB._tracer.on();
        boolean bl2 = statementSapDB._tracer.pon();
        TraceRecord traceRecord = bl2 ? statementSapDB._newTraceRecord("Statement", "isSimpleIdentifier") : null;
        try {
            int n;
            if (bl) {
                statementSapDB._tracer.printCall(this, "isSimpleIdentifier", string);
            }
            boolean bl3 = (n = string.length()) >= 1 && n <= 127 && Pattern.compile("[\\p{Alpha}][\\p{Alnum}_]*").matcher(string).matches();
            return bl3;
        }
        finally {
            if (bl2) {
                statementSapDB._publish(traceRecord);
            }
        }
    }

    default public void _createResultSet(StatementSapDB statementSapDB, Session session, FetchInfo fetchInfo, boolean bl, HDataPart hDataPart, ConnectionProperties connectionProperties) throws SQLException {
        ConnectionSapDB connectionSapDB = statementSapDB._connection;
        if (Driver._createPhantomClass(connectionProperties)) {
            HanaResultSetPhantom.newInstance(connectionSapDB.getTracer(), connectionSapDB, session, statementSapDB, fetchInfo, bl, hDataPart);
        } else if (Driver._createCleanerClass(connectionProperties)) {
            HanaResultSetClean.newInstance(connectionSapDB.getTracer(), connectionSapDB, session, statementSapDB, fetchInfo, bl, hDataPart);
        } else if (Driver._createFinalizerClass(connectionProperties)) {
            HanaResultSetFinalize.newInstance(connectionSapDB.getTracer(), connectionSapDB, session, statementSapDB, fetchInfo, bl, hDataPart);
        } else {
            HanaResultSet.newInstance(connectionSapDB.getTracer(), connectionSapDB, session, statementSapDB, fetchInfo, bl, hDataPart);
        }
    }
}

