/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.JDBCAPI;
import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.AbstractClientLob;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.trace.TraceRecord;
import com.sap.db.util.HexUtils;
import com.sap.db.util.OutputBuffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;

@NotThreadSafe
public class HanaClientBlob
extends AbstractClientLob
implements Blob {
    private OutputBuffer _data = new OutputBuffer();

    public HanaClientBlob(ConnectionSapDB connection) {
        super(connection);
    }

    public InputStream getStreamForTransfer() {
        return new ByteArrayInputStream(Arrays.copyOfRange(this._data.getArray(), 0, this._data.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public long length() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Blob", "length") : null;
        try {
            long result;
            if (on) {
                this._tracer.printCall(this, "length", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._length();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            long l = result;
            return l;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public byte[] getBytes(long pos, int length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Blob", "getBytes") : null;
        try {
            byte[] result;
            if (on) {
                this._tracer.printCall(this, "getBytes", pos, length);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getBytes(pos, length);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public InputStream getBinaryStream() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Blob", "getBinaryStream") : null;
        try {
            InputStream result;
            if (on) {
                this._tracer.printCall(this, "getBinaryStream", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getBinaryStream(1L, this._data != null ? (long)this._data.size() : 0L);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            InputStream inputStream = result;
            return inputStream;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public long position(byte[] pattern, long start) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Blob", "position") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "position", HexUtils.toDisplayHexString(pattern, 20), start);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw HanaClientBlob._getUnsupportedMethodException("Blob", "position( byte[], long )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    @Override
    @JDBCAPI(packetExchange="false")
    public long position(Blob pattern, long start) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Blob", "position") : null;
        try {
            try {
                if (on) {
                    this._tracer.printCall(this, "position", pattern, start);
                }
                try {
                    if (aon) {
                        this._connection.apiStart();
                    }
                    throw HanaClientBlob._getUnsupportedMethodException("Blob", "position( Blob, long )");
                }
                catch (Throwable throwable) {
                    if (aon) {
                        this._connection.apiFinish();
                    }
                    throw throwable;
                }
            }
            catch (Throwable e) {
                if (on) {
                    this._tracer.printException(e);
                }
                if (pon) {
                    r.setException(e);
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            if (pon) {
                this._publish(r);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Blob", "setBytes") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "setBytes", pos, HexUtils.toDisplayHexString(bytes, 20));
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._setBytes(pos, bytes, 0, bytes != null ? bytes.length : 0);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Blob", "setBytes") : null;
        try {
            int result;
            if (on) {
                this._tracer.printCall(this, "setBytes", pos, HexUtils.toDisplayHexString(bytes, 20), offset, len);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._setBytes(pos, bytes, offset, len);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public OutputStream setBinaryStream(long pos) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Blob", "setBinaryStream") : null;
        try {
            OutputStream result;
            if (on) {
                this._tracer.printCall(this, "setBinaryStream", pos);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._setBinaryStream(pos);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            OutputStream outputStream = result;
            return outputStream;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public void truncate(long len) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Blob", "truncate") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "truncate", len);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                this._truncate(len);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public void free() throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Blob", "free") : null;
        try {
            if (on) {
                this._tracer.printCall(this, "free", new Object[0]);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                this._free();
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printVoidResult();
            }
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JDBCAPI(packetExchange="false")
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        boolean on = this._tracer.on();
        boolean pon = this._tracer.pon();
        boolean aon = on ? this._tracer.aon() : false;
        TraceRecord r = pon ? this._newTraceRecord("Blob", "getBinaryStream") : null;
        try {
            InputStream result;
            if (on) {
                this._tracer.printCall(this, "getBinaryStream", pos, length);
            }
            try {
                if (aon) {
                    this._connection.apiStart();
                }
                result = this._getBinaryStream(pos, length);
            }
            finally {
                if (aon) {
                    this._connection.apiFinish();
                }
            }
            if (on) {
                this._tracer.printResult(result);
            }
            InputStream inputStream = result;
            return inputStream;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            if (pon) {
                r.setException(e);
            }
            throw e;
        }
        finally {
            if (pon) {
                this._publish(r);
            }
        }
    }

    private long _length() throws SQLException {
        HanaClientBlob._checkFreed(this._data);
        return this._data.size();
    }

    private byte[] _getBytes(long pos, int length) throws SQLException {
        HanaClientBlob._checkFreed(this._data);
        HanaClientBlob._checkGetPositionAndLength(this._data.size(), pos, length);
        int ipos = (int)pos - 1;
        try {
            return Arrays.copyOfRange(this._data.getArray(), ipos, ipos + length);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    private InputStream _getBinaryStream(long pos, long length) throws SQLException {
        HanaClientBlob._checkFreed(this._data);
        HanaClientBlob._checkGetPositionAndLength(this._data.size(), pos, length);
        int ipos = (int)pos - 1;
        int ilength = (int)length;
        try {
            return new ByteArrayInputStream(Arrays.copyOfRange(this._data.getArray(), ipos, ipos + ilength));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SQLException(e.getMessage(), e);
        }
    }

    private int _setBytes(long pos, byte[] bytes, int offset, int length) throws SQLException {
        int byteLen;
        HanaClientBlob._checkFreed(this._data);
        HanaClientBlob._checkSetPosition(pos);
        HanaClientBlob._checkSourceOffsetAndLength(bytes != null ? bytes.length : 0, offset, length);
        int n = byteLen = bytes != null ? bytes.length : 0;
        if (byteLen == 0 || length == 0) {
            return 0;
        }
        int ipos = (int)pos - 1;
        this._nullPad(ipos);
        int p = ipos;
        int o = offset;
        int n2 = ipos + length;
        while (p < n2) {
            this._data.setByte(p, bytes[o]);
            ++p;
            ++o;
        }
        return length;
    }

    private void _setByte(long pos, byte b) throws SQLException {
        HanaClientBlob._checkFreed(this._data);
        int ipos = (int)pos - 1;
        this._data.setByte(ipos, b);
    }

    private OutputStream _setBinaryStream(long pos) throws SQLException {
        HanaClientBlob._checkFreed(this._data);
        HanaClientBlob._checkSetPosition(pos);
        int ipos = (int)pos - 1;
        this._nullPad(ipos);
        return new BlobOutputStream(this, pos);
    }

    private void _truncate(long len) throws SQLException {
        HanaClientBlob._checkFreed(this._data);
        HanaClientBlob._checkLength(this._data.size(), len);
        int ilen = (int)len;
        this._data.setSize(ilen);
    }

    private void _free() throws SQLException {
        this._data = null;
    }

    private void _nullPad(int ipos) {
        for (int p = this._data.size(); p < ipos; ++p) {
            this._data.write(0);
        }
    }

    private static class BlobOutputStream
    extends OutputStream {
        private final HanaClientBlob _blob;
        private long _pos;

        public BlobOutputStream(HanaClientBlob blob, long pos) {
            this._blob = blob;
            this._pos = pos;
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this._blob._setByte(this._pos++, (byte)b);
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
    }
}

