/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.packet.ClientRoutingInfoDescriptionType;

@Immutable
public class ClientRoutingInfo {
    private final ClientRoutingInfoDescriptionType _descriptionType;
    private final String _description;
    private final ConnectionLevelDecision _connectionLevelDecision;

    ClientRoutingInfo(ClientRoutingInfoDescriptionType descriptionType, String description, ConnectionLevelDecision connectionLevelDecision) {
        this._descriptionType = descriptionType;
        this._description = description;
        this._connectionLevelDecision = connectionLevelDecision;
    }

    public ClientRoutingInfoDescriptionType getDescriptionType() {
        return this._descriptionType;
    }

    public String getDescription() {
        return this._description;
    }

    public ConnectionLevelDecision getDecisionLevel() {
        return this._connectionLevelDecision;
    }

    public static enum ConnectionLevelDecision {
        STATEMENT(false),
        CONNECTION(true);

        private final boolean _value;

        public static ConnectionLevelDecision decode(boolean value) {
            return value ? CONNECTION : STATEMENT;
        }

        public static String getDisplayName(boolean value) {
            return ConnectionLevelDecision.decode(value).name() + '(' + value + ')';
        }

        private ConnectionLevelDecision(boolean value) {
            this._value = value;
        }

        public boolean getValue() {
            return this._value;
        }
    }
}

