/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.servicelibs.com.github.mustachejava.reflect.guards;

import com.salesforce.servicelibs.com.github.mustachejava.ObjectHandler;
import com.salesforce.servicelibs.com.github.mustachejava.reflect.Guard;
import com.salesforce.servicelibs.com.github.mustachejava.reflect.ReflectionObjectHandler;
import com.salesforce.servicelibs.com.github.mustachejava.util.Wrapper;
import java.util.List;
import java.util.Map;

public class MapGuard
implements Guard {
    protected final ObjectHandler oh;
    protected final int scopeIndex;
    protected final String name;
    protected final boolean contains;
    protected final Wrapper[] wrappers;

    public MapGuard(ObjectHandler oh, int scopeIndex, String name, boolean contains, Wrapper[] wrappers) {
        this.oh = oh;
        this.scopeIndex = scopeIndex;
        this.name = name;
        this.contains = contains;
        this.wrappers = wrappers;
    }

    @Override
    public boolean apply(List<Object> objects) {
        Object scope = ReflectionObjectHandler.unwrap(this.oh, this.scopeIndex, this.wrappers, objects);
        if (scope instanceof Map) {
            Map map = (Map)scope;
            if (this.contains) {
                return map.containsKey(this.name);
            }
            return !map.containsKey(this.name);
        }
        return false;
    }

    public String toString() {
        return "[MapGuard: " + this.scopeIndex + " " + this.name + " " + this.contains + "]";
    }
}

