/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.servicelibs.com.github.mustachejava.codes;

import com.salesforce.servicelibs.com.github.mustachejava.DefaultMustacheFactory;
import com.salesforce.servicelibs.com.github.mustachejava.FragmentKey;
import com.salesforce.servicelibs.com.github.mustachejava.MustacheException;
import com.salesforce.servicelibs.com.github.mustachejava.TemplateContext;
import com.salesforce.servicelibs.com.github.mustachejava.codes.DefaultCode;
import com.salesforce.servicelibs.com.github.mustachejava.util.LatchedWriter;
import com.salesforce.servicelibs.com.github.mustachejava.util.Node;
import com.salesforce.servicelibs.com.github.mustachejava.util.NodeValue;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValueCode
extends DefaultCode {
    protected final boolean encoded;
    protected final ExecutorService les;
    private Pattern compiledAppended;

    @Override
    public void identity(Writer writer) {
        try {
            if (this.name != null) {
                writer.write(this.tc.startChars());
                if (!this.encoded) {
                    writer.write("{");
                }
                writer.write(this.type);
                writer.write(this.name);
                if (!this.encoded) {
                    writer.write("}");
                }
                writer.write(this.tc.endChars());
            }
            this.appendText(writer);
        }
        catch (IOException e) {
            throw new MustacheException(e, this.tc);
        }
    }

    public ValueCode(TemplateContext tc, DefaultMustacheFactory df, String variable, boolean encoded) {
        super(tc, df, null, variable, "");
        this.encoded = encoded;
        this.les = df.getExecutorService();
    }

    @Override
    public Writer execute(Writer writer, List<Object> scopes) {
        try {
            Object object = this.get(scopes);
            if (object != null) {
                if (object instanceof Function) {
                    this.handleFunction(writer, (Function)object, scopes);
                } else {
                    if (object instanceof Callable) {
                        return this.handleCallable(writer, (Callable)object, scopes);
                    }
                    this.execute(writer, this.oh.stringify(object));
                }
            }
            return super.execute(writer, scopes);
        }
        catch (Exception e) {
            throw new MustacheException("Failed to get value for " + this.name, e, this.tc);
        }
    }

    protected Writer handleCallable(Writer writer, Callable callable, List<Object> scopes) throws Exception {
        if (this.les == null) {
            this.execute(writer, callable);
            return super.execute(writer, scopes);
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new MustacheException("Failed to flush writer", e, this.tc);
        }
        LatchedWriter latchedWriter = new LatchedWriter(writer);
        Writer finalWriter = writer;
        this.les.execute(() -> {
            try {
                this.execute(finalWriter, callable);
                latchedWriter.done();
            }
            catch (Throwable e) {
                latchedWriter.failed(e);
            }
        });
        return super.execute(latchedWriter, scopes);
    }

    private void execute(Writer writer, Callable callable) throws Exception {
        Object call = callable.call();
        this.execute(writer, call == null ? null : this.oh.stringify(call));
    }

    protected void handleFunction(Writer writer, Function function, List<Object> scopes) throws IOException {
        String value;
        Object newtemplate = function.apply(null);
        if (newtemplate == null) {
            value = "";
        } else {
            String templateText = newtemplate.toString();
            StringWriter sw = new StringWriter();
            TemplateContext newTC = new TemplateContext("{{", "}}", this.tc.file(), this.tc.line(), this.tc.startOfLine());
            this.df.getFragment(new FragmentKey(newTC, templateText)).execute((Writer)sw, scopes).close();
            value = sw.toString();
        }
        this.execute(writer, value);
    }

    protected void execute(Writer writer, String value) throws IOException {
        if (value != null) {
            if (this.encoded) {
                this.df.encode(value, writer);
            } else {
                writer.write(value);
            }
        }
    }

    @Override
    public Node invert(Node node, String text, AtomicInteger position) {
        if (this.compiledAppended == null) {
            this.compiledAppended = this.appended == null ? Pattern.compile("$") : Pattern.compile(this.appended);
        }
        int start = position.get();
        Matcher matcher = this.compiledAppended.matcher(text);
        if (matcher.find(position.get())) {
            String value = text.substring(start, matcher.start());
            position.set(matcher.start() + matcher.group(0).length());
            node.put(this.name, NodeValue.value(value));
            return node;
        }
        return null;
    }
}

