/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.servicelibs.com.github.mustachejava.codes;

import com.salesforce.servicelibs.com.github.mustachejava.Binding;
import com.salesforce.servicelibs.com.github.mustachejava.Code;
import com.salesforce.servicelibs.com.github.mustachejava.DefaultMustacheFactory;
import com.salesforce.servicelibs.com.github.mustachejava.Mustache;
import com.salesforce.servicelibs.com.github.mustachejava.MustacheException;
import com.salesforce.servicelibs.com.github.mustachejava.ObjectHandler;
import com.salesforce.servicelibs.com.github.mustachejava.TemplateContext;
import com.salesforce.servicelibs.com.github.mustachejava.util.Node;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultCode
implements Code,
Cloneable {
    protected String appended;
    protected Mustache mustache;
    protected final ObjectHandler oh;
    protected final String name;
    protected final TemplateContext tc;
    protected final String type;
    protected final boolean returnThis;
    protected final Binding binding;
    protected final DefaultMustacheFactory df;
    private char[] appendedChars;

    @Override
    public Object clone() {
        HashSet<Code> seen = new HashSet<Code>();
        seen.add(this);
        return this.clone(seen);
    }

    @Override
    public Object clone(Set<Code> seen) {
        try {
            DefaultCode code = (DefaultCode)super.clone();
            Code[] codes = code.getCodes();
            if (codes != null) {
                codes = (Code[])codes.clone();
                for (int i = 0; i < codes.length; ++i) {
                    if (seen.add(codes[i])) continue;
                    codes[i] = (Code)codes[i].clone(seen);
                    seen.remove(codes[i]);
                }
                code.setCodes(codes);
            }
            if (this.mustache != null && !seen.add(this.mustache)) {
                code.mustache = (Mustache)this.mustache.clone(seen);
                seen.remove(this.mustache);
            }
            return code;
        }
        catch (CloneNotSupportedException e) {
            throw new MustacheException("Clone not supported", e, this.tc);
        }
    }

    public DefaultCode() {
        this(null, null, null, null, null);
    }

    public DefaultCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache, String name, String type) {
        this.df = df;
        this.oh = df == null ? null : df.getObjectHandler();
        this.mustache = mustache;
        this.type = type;
        this.name = name;
        this.tc = tc;
        this.binding = this.oh == null ? null : this.oh.createBinding(name, tc, this);
        this.returnThis = ".".equals(name);
    }

    @Override
    public Node invert(Node node, String text, AtomicInteger position) {
        int start = position.get();
        Code[] codes = this.getCodes();
        if (codes != null) {
            for (Code code : codes) {
                Node invert = code.invert(node, text, position);
                if (invert != null) continue;
                position.set(start);
                return null;
            }
        }
        return this.matchAppended(node, text, position, start);
    }

    protected Node matchAppended(Node node, String text, AtomicInteger position, int start) {
        if (this.appended == null) {
            return node;
        }
        if (text.substring(position.get()).startsWith(this.appended)) {
            position.addAndGet(this.appended.length());
            return node;
        }
        position.set(start);
        return null;
    }

    @Override
    public Code[] getCodes() {
        return this.mustache == null ? null : this.mustache.getCodes();
    }

    @Override
    public synchronized void init() {
        this.filterText();
        Code[] codes = this.getCodes();
        if (codes != null) {
            for (Code code : codes) {
                code.init();
            }
        }
    }

    protected void filterText() {
        if (this.df != null && this.appended != null) {
            this.appended = this.df.filterText(this.appended, this.tc.startOfLine());
        }
    }

    @Override
    public void setCodes(Code[] newcodes) {
        this.mustache.setCodes(newcodes);
    }

    public Object get(List<Object> scopes) {
        if (this.returnThis) {
            int length = scopes == null ? 0 : scopes.size();
            return length == 0 ? null : scopes.get(length - 1);
        }
        try {
            return this.binding.get(scopes);
        }
        catch (MustacheException e) {
            e.setContext(this.tc);
            throw e;
        }
        catch (Throwable e) {
            throw new MustacheException(e.getMessage(), e, this.tc);
        }
    }

    @Override
    public Writer execute(Writer writer, List<Object> scopes) {
        return this.appendText(this.run(writer, scopes));
    }

    @Override
    public void identity(Writer writer) {
        try {
            if (this.name != null) {
                this.tag(writer, this.type);
                if (this.getCodes() != null) {
                    this.runIdentity(writer);
                    this.tag(writer, "/");
                }
            }
            this.appendText(writer);
        }
        catch (IOException e) {
            throw new MustacheException("Failed to write", e, this.tc);
        }
    }

    protected void runIdentity(Writer writer) {
        int length = this.getCodes().length;
        for (int i = 0; i < length; ++i) {
            this.getCodes()[i].identity(writer);
        }
    }

    protected void tag(Writer writer, String tag) throws IOException {
        writer.write(this.tc.startChars());
        writer.write(tag);
        writer.write(this.name);
        writer.write(this.tc.endChars());
    }

    protected Writer appendText(Writer writer) {
        if (this.appended != null) {
            try {
                writer.write(this.appended);
            }
            catch (IOException e) {
                throw new MustacheException("Failed to write", e, this.tc);
            }
        }
        return writer;
    }

    protected Writer run(Writer writer, List<Object> scopes) {
        return this.mustache == null ? writer : this.mustache.run(writer, scopes);
    }

    @Override
    public void append(String text) {
        this.appended = this.appended == null ? text : this.appended + text;
    }

    protected boolean addScope(List<Object> scopes, Object scope) {
        if (scope != null) {
            scopes.add(scope);
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

