/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence.query.journal.redis;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.persistence.query.EventEnvelope;
import akka.persistence.query.NoOffset$;
import akka.persistence.query.Offset;
import akka.persistence.query.Sequence;
import akka.persistence.query.journal.redis.CurrentPersistenceIdsSource;
import akka.persistence.query.journal.redis.EventsByPersistenceIdSource;
import akka.persistence.query.journal.redis.EventsByTagSource;
import akka.persistence.query.journal.redis.PersistenceIdsSource;
import akka.persistence.query.scaladsl.CurrentEventsByPersistenceIdQuery;
import akka.persistence.query.scaladsl.CurrentEventsByTagQuery;
import akka.persistence.query.scaladsl.CurrentPersistenceIdsQuery;
import akka.persistence.query.scaladsl.EventsByPersistenceIdQuery;
import akka.persistence.query.scaladsl.EventsByTagQuery;
import akka.persistence.query.scaladsl.PersistenceIdsQuery;
import akka.persistence.redis.RedisUtils$;
import akka.stream.Graph;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.typesafe.config.Config;
import redis.RedisClient;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb\u0001\u0002\u0007\u000e\u0001aA\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!1\u0011\n\u0001C\u0001\u001b)CqA\u0004\u0001C\u0002\u0013\u0005q\n\u0003\u0004V\u0001\u0001\u0006I\u0001\u0015\u0005\u0006-\u0002!\ta\u0016\u0005\u0006]\u0002!\ta\u0016\u0005\u0006_\u0002!\t\u0001\u001d\u0005\u0007\u007f\u0002!\t!!\u0001\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f!9\u00111\u0004\u0001\u0005\u0002\u0005u!\u0001E*dC2\f'+Z1e\u0015>,(O\\1m\u0015\tqq\"A\u0003sK\u0012L7O\u0003\u0002\u0011#\u00059!n\\;s]\u0006d'B\u0001\n\u0014\u0003\u0015\tX/\u001a:z\u0015\t!R#A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,'\"\u0001\f\u0002\t\u0005\\7.Y\u0002\u0001'%\u0001\u0011dH\u0013)W9\nD\u0007\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VM\u001a\t\u0003A\rj\u0011!\t\u0006\u0003EE\t\u0001b]2bY\u0006$7\u000f\\\u0005\u0003I\u0005\u00121BU3bI*{WO\u001d8bYB\u0011\u0001EJ\u0005\u0003O\u0005\u0012\u0001#\u0012<f]R\u001c()\u001f+bOF+XM]=\u0011\u0005\u0001J\u0013B\u0001\u0016\"\u0005i)e/\u001a8ug\nK\b+\u001a:tSN$XM\\2f\u0013\u0012\fV/\u001a:z!\t\u0001C&\u0003\u0002.C\t\u0019\u0002+\u001a:tSN$XM\\2f\u0013\u0012\u001c\u0018+^3ssB\u0011\u0001eL\u0005\u0003a\u0005\u0012!dQ;se\u0016tG\u000fU3sg&\u001cH/\u001a8dK&#7/U;fef\u0004\"\u0001\t\u001a\n\u0005M\n#!I\"veJ,g\u000e^#wK:$8OQ=QKJ\u001c\u0018n\u001d;f]\u000e,\u0017\nZ)vKJL\bC\u0001\u00116\u0013\t1\u0014EA\fDkJ\u0014XM\u001c;Fm\u0016tGo\u001d\"z)\u0006<\u0017+^3ss\u000611/_:uK6\u0004\"!\u000f\u001f\u000e\u0003iR!aO\u000b\u0002\u000b\u0005\u001cGo\u001c:\n\u0005uR$aE#yi\u0016tG-\u001a3BGR|'oU=ti\u0016l\u0017\u0001B2p]\u001a\u0004\"\u0001Q$\u000e\u0003\u0005S!AQ\"\u0002\r\r|gNZ5h\u0015\t!U)\u0001\u0005usB,7/\u00194f\u0015\u00051\u0015aA2p[&\u0011\u0001*\u0011\u0002\u0007\u0007>tg-[4\u0002\rqJg.\u001b;?)\rYUJ\u0014\t\u0003\u0019\u0002i\u0011!\u0004\u0005\u0006o\r\u0001\r\u0001\u000f\u0005\u0006}\r\u0001\raP\u000b\u0002!B\u0011\u0011kU\u0007\u0002%*\ta\"\u0003\u0002U%\nY!+\u001a3jg\u000ec\u0017.\u001a8u\u0003\u0019\u0011X\rZ5tA\u0005q\u0001/\u001a:tSN$XM\\2f\u0013\u0012\u001cH#\u0001-\u0011\tekvL[\u0007\u00025*\u0011!e\u0017\u0006\u00039V\taa\u001d;sK\u0006l\u0017B\u00010[\u0005\u0019\u0019v.\u001e:dKB\u0011\u0001m\u001a\b\u0003C\u0016\u0004\"AY\u000e\u000e\u0003\rT!\u0001Z\f\u0002\rq\u0012xn\u001c;?\u0013\t17$\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q&\u0014aa\u0015;sS:<'B\u00014\u001c!\tYG.D\u0001\u0016\u0013\tiWCA\u0004O_R,6/\u001a3\u0002+\r,(O]3oiB+'o]5ti\u0016t7-Z%eg\u0006)RM^3oiN\u0014\u0015\u0010U3sg&\u001cH/\u001a8dK&#G\u0003B9wqv\u0004B!W/sUB\u00111\u000f^\u0007\u0002#%\u0011Q/\u0005\u0002\u000e\u000bZ,g\u000e^#om\u0016dw\u000e]3\t\u000b]D\u0001\u0019A0\u0002\u001bA,'o]5ti\u0016t7-Z%e\u0011\u0015I\b\u00021\u0001{\u000391'o\\7TKF,XM\\2f\u001dJ\u0004\"AG>\n\u0005q\\\"\u0001\u0002'p]\u001eDQA \u0005A\u0002i\fA\u0002^8TKF,XM\\2f\u001dJ\fAdY;se\u0016tG/\u0012<f]R\u001c()\u001f)feNL7\u000f^3oG\u0016LE\rF\u0004r\u0003\u0007\t)!a\u0002\t\u000b]L\u0001\u0019A0\t\u000beL\u0001\u0019\u0001>\t\u000byL\u0001\u0019\u0001>\u0002\u0017\u00154XM\u001c;t\u0005f$\u0016m\u001a\u000b\u0006c\u00065\u0011\u0011\u0003\u0005\u0007\u0003\u001fQ\u0001\u0019A0\u0002\u0007Q\fw\rC\u0004\u0002\u0014)\u0001\r!!\u0006\u0002\r=4gm]3u!\r\u0019\u0018qC\u0005\u0004\u00033\t\"AB(gMN,G/\u0001\ndkJ\u0014XM\u001c;Fm\u0016tGo\u001d\"z)\u0006<G#B9\u0002 \u0005\u0005\u0002BBA\b\u0017\u0001\u0007q\fC\u0004\u0002\u0014-\u0001\r!!\u0006")
public class ScalaReadJournal
implements EventsByTagQuery,
EventsByPersistenceIdQuery,
PersistenceIdsQuery,
CurrentPersistenceIdsQuery,
CurrentEventsByPersistenceIdQuery,
CurrentEventsByTagQuery {
    private final ExtendedActorSystem system;
    private final Config conf;
    private final RedisClient redis;

    public RedisClient redis() {
        return this.redis;
    }

    public Source<String, NotUsed> persistenceIds() {
        return Source$.MODULE$.fromGraph((Graph)new PersistenceIdsSource(this.conf, this.redis(), (ActorSystem)this.system));
    }

    public Source<String, NotUsed> currentPersistenceIds() {
        return Source$.MODULE$.fromGraph((Graph)new CurrentPersistenceIdsSource(this.redis()));
    }

    public Source<EventEnvelope, NotUsed> eventsByPersistenceId(String persistenceId, long fromSequenceNr, long toSequenceNr) {
        return Source$.MODULE$.fromGraph((Graph)new EventsByPersistenceIdSource(this.conf, this.redis(), persistenceId, fromSequenceNr, toSequenceNr, (ActorSystem)this.system, true));
    }

    public Source<EventEnvelope, NotUsed> currentEventsByPersistenceId(String persistenceId, long fromSequenceNr, long toSequenceNr) {
        return Source$.MODULE$.fromGraph((Graph)new EventsByPersistenceIdSource(this.conf, this.redis(), persistenceId, fromSequenceNr, toSequenceNr, (ActorSystem)this.system, false));
    }

    public Source<EventEnvelope, NotUsed> eventsByTag(String tag, Offset offset) {
        Source source;
        Offset offset2 = offset;
        if (NoOffset$.MODULE$.equals(offset2)) {
            source = Source$.MODULE$.fromGraph((Graph)new EventsByTagSource(this.conf, this.redis(), tag, 0L, (ActorSystem)this.system, true));
        } else if (offset2 instanceof Sequence) {
            Sequence sequence = (Sequence)offset2;
            long offsetValue = sequence.value();
            source = Source$.MODULE$.fromGraph((Graph)new EventsByTagSource(this.conf, this.redis(), tag, offsetValue, (ActorSystem)this.system, true));
        } else {
            throw new IllegalArgumentException(new StringBuilder(31).append("Redis does not support ").append(offset.getClass().getName()).append(" offsets").toString());
        }
        return source;
    }

    public Source<EventEnvelope, NotUsed> currentEventsByTag(String tag, Offset offset) {
        Source source;
        Offset offset2 = offset;
        if (NoOffset$.MODULE$.equals(offset2)) {
            source = Source$.MODULE$.fromGraph((Graph)new EventsByTagSource(this.conf, this.redis(), tag, 0L, (ActorSystem)this.system, false));
        } else if (offset2 instanceof Sequence) {
            Sequence sequence = (Sequence)offset2;
            long offsetValue = sequence.value();
            source = Source$.MODULE$.fromGraph((Graph)new EventsByTagSource(this.conf, this.redis(), tag, offsetValue, (ActorSystem)this.system, false));
        } else {
            throw new IllegalArgumentException(new StringBuilder(31).append("Redis does not support ").append(offset.getClass().getName()).append(" offsets").toString());
        }
        return source;
    }

    public ScalaReadJournal(ExtendedActorSystem system, Config conf) {
        this.system = system;
        this.conf = conf;
        this.redis = RedisUtils$.MODULE$.create(conf, (ActorSystem)system);
    }
}

