/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.config;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class RegisterMetricBeanDefinitionParser
implements BeanDefinitionParser {
    RegisterMetricBeanDefinitionParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        CompositeComponentDefinition compDefinition = new CompositeComponentDefinition(element.getTagName(), parserContext.extractSource((Object)element));
        parserContext.pushContainingComponent(compDefinition);
        String metricRegistryBeanName = element.getAttribute("metric-registry");
        if (!StringUtils.hasText((String)metricRegistryBeanName)) {
            throw new RuntimeException();
        }
        RuntimeBeanReference metricRegistryBeanRef = new RuntimeBeanReference(metricRegistryBeanName);
        List metricElements = DomUtils.getChildElementsByTagName((Element)element, (String[])new String[]{"bean", "ref"});
        for (Element metricElement : metricElements) {
            String name = metricElement.getAttributeNS("http://www.ryantenney.com/schema/metrics", "name");
            if (name != null) {
                metricElement.removeAttributeNS("http://www.ryantenney.com/schema/metrics", "name");
            }
            Object metric = parserContext.getDelegate().parsePropertySubElement(metricElement, null);
            RootBeanDefinition metricRegistererDef = new RootBeanDefinition(MetricRegisterer.class);
            metricRegistererDef.setSource(parserContext.extractSource((Object)metricElement));
            metricRegistererDef.setRole(2);
            ConstructorArgumentValues args = metricRegistererDef.getConstructorArgumentValues();
            args.addIndexedArgumentValue(0, (Object)metricRegistryBeanRef);
            args.addIndexedArgumentValue(1, (Object)name);
            args.addIndexedArgumentValue(2, metric);
            String beanName = parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)metricRegistererDef);
            parserContext.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)metricRegistererDef, beanName));
        }
        parserContext.popAndRegisterContainingComponent();
        return null;
    }

    public static class MetricRegisterer
    implements InitializingBean {
        private final MetricRegistry metricRegistry;
        private final String name;
        private final Metric metric;

        public MetricRegisterer(MetricRegistry metricRegistry, String name, Metric metric) {
            this.metricRegistry = metricRegistry;
            this.name = name;
            this.metric = metric;
            if (!StringUtils.hasText((String)name) && !(metric instanceof MetricSet)) {
                throw new RuntimeException();
            }
        }

        public void afterPropertiesSet() throws Exception {
            this.metricRegistry.register(this.name, this.metric);
        }
    }
}

