/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.search;

import io.lettuce.core.internal.LettuceAssert;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class Document<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private K id;
    private Double score;
    private V sortKey;
    private V payload;

    public K getId() {
        return this.id;
    }

    public void setId(K id) {
        this.id = id;
    }

    public Double getScore() {
        return this.score;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    public V getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(V sortKey) {
        this.sortKey = sortKey;
    }

    public V getPayload() {
        return this.payload;
    }

    public void setPayload(V payload) {
        this.payload = payload;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.id, this.payload, this.score, this.sortKey);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Document other = (Document)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.payload, other.payload) && Objects.equals(this.score, other.score) && Objects.equals(this.sortKey, other.sortKey);
    }

    public static <K, V> DocumentBuilder<K, V> id(K id) {
        return new DocumentBuilder(id);
    }

    public static class DocumentBuilder<K, V> {
        private final K id;
        private double score = 1.0;
        private V payload;
        private Map<K, V> fields = new HashMap();

        public DocumentBuilder(K id) {
            this.id = id;
        }

        public DocumentBuilder<K, V> score(double score) {
            this.score = score;
            return this;
        }

        public DocumentBuilder<K, V> payload(V payload) {
            this.payload = payload;
            return this;
        }

        public DocumentBuilder<K, V> field(K name, V value) {
            this.fields.put(name, value);
            return this;
        }

        public Document<K, V> build() {
            LettuceAssert.notNull(this.id, (String)"Id is required.");
            LettuceAssert.notNull(this.fields, (String)"Fields are required.");
            Document<K, V> document = new Document<K, V>();
            document.setId(this.id);
            document.setScore(this.score);
            document.setPayload(this.payload);
            document.putAll(this.fields);
            return document;
        }
    }
}

