/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.output;

import com.redis.lettucemod.search.Document;
import com.redis.lettucemod.search.SearchResults;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceStrings;
import io.lettuce.core.output.CommandOutput;
import java.nio.ByteBuffer;

public class SearchNoContentOutput<K, V>
extends CommandOutput<K, V, SearchResults<K, V>> {
    private Document<K, V> current;
    private final boolean withScores;

    public SearchNoContentOutput(RedisCodec<K, V> codec, boolean withScores) {
        super(codec, new SearchResults());
        this.withScores = withScores;
    }

    public void set(ByteBuffer bytes) {
        if (this.current == null) {
            this.current = new Document();
            if (bytes != null) {
                this.current.setId(this.codec.decodeKey(bytes));
            }
            ((SearchResults)this.output).add(this.current);
            if (!this.withScores) {
                this.current = null;
            }
        } else {
            if (this.withScores) {
                this.current.setScore(LettuceStrings.toDouble((String)this.decodeAscii(bytes)));
            }
            this.current = null;
        }
    }

    public void set(long integer) {
        ((SearchResults)this.output).setCount(integer);
    }

    public void set(double number) {
        if (this.withScores) {
            this.current.setScore(number);
        }
        this.current = null;
    }
}

