/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.cluster;

import com.redis.lettucemod.StatefulRedisModulesConnectionImpl;
import com.redis.lettucemod.cluster.StatefulRedisModulesClusterConnectionImpl;
import com.redis.lettucemod.cluster.api.StatefulRedisModulesClusterConnection;
import io.lettuce.core.RedisChannelWriter;
import io.lettuce.core.RedisURI;
import io.lettuce.core.cluster.ClusterPushHandler;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.RedisClusterURIUtil;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.PushHandler;
import io.lettuce.core.resource.ClientResources;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;

public class RedisModulesClusterClient
extends RedisClusterClient {
    protected RedisModulesClusterClient(ClientResources clientResources, Iterable<RedisURI> redisURIs) {
        super(clientResources, redisURIs);
    }

    public static RedisModulesClusterClient create(RedisURI redisURI) {
        RedisModulesClusterClient.assertNotNull(redisURI);
        return RedisModulesClusterClient.create(Collections.singleton(redisURI));
    }

    public static RedisModulesClusterClient create(Iterable<RedisURI> redisURIs) {
        RedisModulesClusterClient.assertNotEmpty(redisURIs);
        RedisModulesClusterClient.assertSameOptions(redisURIs);
        return new RedisModulesClusterClient(null, redisURIs);
    }

    private static void assertNotEmpty(Iterable<RedisURI> redisURIs) {
        LettuceAssert.notNull(redisURIs, (String)"RedisURIs must not be null");
        LettuceAssert.isTrue((boolean)redisURIs.iterator().hasNext(), (String)"RedisURIs must not be empty");
    }

    private static void assertSameOptions(Iterable<RedisURI> redisURIs) {
        Boolean ssl = null;
        Boolean startTls = null;
        Boolean verifyPeer = null;
        for (RedisURI redisURI : redisURIs) {
            if (ssl == null) {
                ssl = redisURI.isSsl();
            }
            if (startTls == null) {
                startTls = redisURI.isStartTls();
            }
            if (verifyPeer == null) {
                verifyPeer = redisURI.isVerifyPeer();
            }
            if (ssl.booleanValue() != redisURI.isSsl()) {
                RedisModulesClusterClient.fail("SSL is not consistent with the other seed URI SSL settings", redisURI);
            }
            if (startTls.booleanValue() != redisURI.isStartTls()) {
                RedisModulesClusterClient.fail("StartTLS is not consistent with the other seed URI StartTLS settings", redisURI);
            }
            if (verifyPeer.booleanValue() == redisURI.isVerifyPeer()) continue;
            RedisModulesClusterClient.fail("VerifyPeer is not consistent with the other seed URI VerifyPeer settings", redisURI);
        }
    }

    private static void fail(String message, RedisURI redisURI) {
        throw new IllegalArgumentException("RedisURI " + redisURI + " " + message);
    }

    public static RedisModulesClusterClient create(String uri) {
        LettuceAssert.notEmpty((CharSequence)uri, (String)"URI must not be empty");
        return RedisModulesClusterClient.create(RedisClusterURIUtil.toRedisURIs((URI)URI.create(uri)));
    }

    public static RedisModulesClusterClient create(ClientResources clientResources, RedisURI redisURI) {
        RedisModulesClusterClient.assertNotNull(clientResources);
        RedisModulesClusterClient.assertNotNull(redisURI);
        return RedisModulesClusterClient.create(clientResources, Collections.singleton(redisURI));
    }

    public static RedisClusterClient create(ClientResources clientResources, String uri) {
        RedisModulesClusterClient.assertNotNull(clientResources);
        LettuceAssert.notEmpty((CharSequence)uri, (String)"URI must not be empty");
        return RedisModulesClusterClient.create(clientResources, RedisClusterURIUtil.toRedisURIs((URI)URI.create(uri)));
    }

    public static RedisModulesClusterClient create(ClientResources clientResources, Iterable<RedisURI> redisURIs) {
        RedisModulesClusterClient.assertNotNull(clientResources);
        RedisModulesClusterClient.assertNotEmpty(redisURIs);
        RedisModulesClusterClient.assertSameOptions(redisURIs);
        return new RedisModulesClusterClient(clientResources, redisURIs);
    }

    private static void assertNotNull(RedisURI redisURI) {
        LettuceAssert.notNull((Object)redisURI, (String)"RedisURI must not be null");
    }

    private static void assertNotNull(ClientResources clientResources) {
        LettuceAssert.notNull((Object)clientResources, (String)"ClientResources must not be null");
    }

    public StatefulRedisModulesClusterConnection<String, String> connect() {
        return this.connect(this.newStringStringCodec());
    }

    public <K, V> StatefulRedisModulesClusterConnection<K, V> connect(RedisCodec<K, V> codec) {
        return (StatefulRedisModulesClusterConnection)super.connect(codec);
    }

    protected <K, V> StatefulRedisModulesConnectionImpl<K, V> newStatefulRedisConnection(RedisChannelWriter channelWriter, PushHandler pushHandler, RedisCodec<K, V> codec, Duration timeout) {
        return new StatefulRedisModulesConnectionImpl<K, V>(channelWriter, pushHandler, codec, timeout);
    }

    protected <V, K> StatefulRedisModulesClusterConnectionImpl<K, V> newStatefulRedisClusterConnection(RedisChannelWriter channelWriter, ClusterPushHandler pushHandler, RedisCodec<K, V> codec, Duration timeout) {
        return new StatefulRedisModulesClusterConnectionImpl<K, V>(channelWriter, pushHandler, codec, timeout);
    }
}

