/*
 * Decompiled with CFR 0.152.
 */
package com.redis.lettucemod.cluster;

import io.lettuce.core.cluster.SlotHash;
import io.lettuce.core.codec.RedisCodec;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModulesSlotHash {
    private ModulesSlotHash() {
    }

    public static <K, V> Map<Integer, List<K>> partition(RedisCodec<K, V> codec, Iterable<K> keys) {
        HashMap<Integer, List<Integer>> partitioned = new HashMap<Integer, List<Integer>>();
        for (K key : keys) {
            int slot = SlotHash.getSlot((ByteBuffer)codec.encodeKey(key));
            if (!partitioned.containsKey(slot)) {
                partitioned.put(slot, new ArrayList());
            }
            Collection list = (Collection)partitioned.get(slot);
            list.add(key);
        }
        return partitioned;
    }

    public static <K> Map<K, Integer> getSlots(Map<Integer, ? extends Iterable<K>> partitioned) {
        HashMap<K, Integer> result = new HashMap<K, Integer>();
        for (Map.Entry<Integer, Iterable<K>> entry : partitioned.entrySet()) {
            for (K key : entry.getValue()) {
                result.put(key, entry.getKey());
            }
        }
        return result;
    }
}

