/*
 * Decompiled with CFR 0.152.
 */
package com.rallyhealth.sbt.versioning;

import com.rallyhealth.sbt.versioning.BufferingProcessLogger;
import com.rallyhealth.sbt.versioning.GitFetcher;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxesRunTime;
import scala.sys.process.Process;
import scala.sys.process.Process$;
import scala.sys.process.ProcessLogger;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public final class GitFetcher$ {
    public static GitFetcher$ MODULE$;
    private final Regex tagResultRegex;

    static {
        new GitFetcher$();
    }

    private Regex tagResultRegex() {
        return this.tagResultRegex;
    }

    public Seq<GitFetcher.FetchResult> fetchRemotes(Seq<String> remotes, Duration timeout, Logger logger) {
        Seq seq;
        int processResult;
        BufferingProcessLogger outputLogger = new BufferingProcessLogger();
        int n = processResult = Process$.MODULE$.apply("git remote").$bang((ProcessLogger)outputLogger);
        switch (n) {
            case 0: {
                logger.debug((Function0 & Serializable & scala.Serializable)() -> "Fetching remote sources...");
                Buffer<String> remotes2 = outputLogger.stdout();
                Buffer tagsToFetch = (Buffer)remotes2.filter((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)remotes2.contains(elem)));
                if (tagsToFetch.nonEmpty()) {
                    logger.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Fetching tags from: ").append(tagsToFetch.mkString(", ")).toString());
                    seq = (Seq)tagsToFetch.flatMap((Function1 & Serializable & scala.Serializable)remote -> MODULE$.fetchTagsFromRemote((String)remote, timeout, logger), Buffer$.MODULE$.canBuildFrom());
                    break;
                }
                logger.debug((Function0 & Serializable & scala.Serializable)() -> "No tags to fetch");
                seq = (Seq)Seq$.MODULE$.empty();
                break;
            }
            default: {
                logger.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Fetching remotes failed enumerating remotes [git exitCode=").append(n).append("]").toString());
                seq = (Seq)Seq$.MODULE$.empty();
                break;
            }
        }
        return seq;
    }

    private Seq<GitFetcher.FetchResult> fetchTagsFromRemote(String remote, Duration timeout, Logger logger) {
        Seq seq;
        BufferingProcessLogger outputLogger = new BufferingProcessLogger();
        Process process = Process$.MODULE$.apply(new StringBuilder(17).append("git fetch ").append(remote).append(" --tags").toString()).run((ProcessLogger)outputLogger);
        Future resultFuture = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Seq seq;
            if (process.exitValue() == 0) {
                seq = (Seq)((TraversableLike)outputLogger.stderr().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.contains("[new tag]")))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Iterable iterable;
                    String string = x0$1;
                    Option option = MODULE$.tagResultRegex().unapplySeq((CharSequence)string);
                    if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                        String tag = (String)((LinearSeqOptimized)option.get()).apply(0);
                        logger.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Fetched from remote=").append(remote).append(" tag=").append(tag).toString());
                        iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new GitFetcher.FetchResult(remote, tag)));
                    } else {
                        logger.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Unable to parse git result=").append(string).append(", skipping").toString());
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    return iterable;
                }, Buffer$.MODULE$.canBuildFrom());
            } else {
                logger.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Fetching remote=").append(remote).append(" failed [git exitCode=").append(process.exitValue()).append("]").toString());
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        }, ExecutionContext.Implicits$.MODULE$.global());
        try {
            Seq result = (Seq)Await$.MODULE$.result((Awaitable)resultFuture, timeout);
            logger.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Successfully fetched ").append(remote).toString());
            seq = result;
        }
        catch (Throwable throwable) {
            Seq seq2;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof TimeoutException) {
                process.destroy();
                logger.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Fetching remote=").append(remote).append(" timed out [git exitCode=").append(process.exitValue()).append("]").toString());
                seq2 = (Seq)Seq$.MODULE$.empty();
            } else {
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable exc = (Throwable)option.get();
                    logger.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Fetching remote=").append(remote).append(" failed [git exitCode=").append(process.exitValue()).append("]").toString());
                    logger.trace((Function0 & Serializable & scala.Serializable)() -> exc);
                    seq2 = (Seq)Seq$.MODULE$.empty();
                } else {
                    throw throwable;
                }
            }
            seq = seq2;
        }
        return seq;
    }

    private GitFetcher$() {
        MODULE$ = this;
        this.tagResultRegex = new StringOps(Predef$.MODULE$.augmentString(" \\* \\[new tag\\][ ]+([\\S]+).*")).r();
    }
}

