/*
 * Decompiled with CFR 0.152.
 */
package com.rallyhealth.sbt.scripted;

import com.rallyhealth.sbt.scripted.BufferedLog;
import com.rallyhealth.sbt.scripted.BufferedLog$StartTestLogEvent$;
import com.rallyhealth.sbt.scripted.ScriptedUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import sbt.util.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class ScriptedUtils$ {
    public static ScriptedUtils$ MODULE$;
    private final BufferedLog bufferedLog;
    private final AtomicReference<String> currentTestName;

    static {
        new ScriptedUtils$();
    }

    private BufferedLog bufferedLog() {
        return this.bufferedLog;
    }

    private AtomicReference<String> currentTestName() {
        return this.currentTestName;
    }

    public void initialize() {
        this.bufferedLog().initialize();
    }

    public void startTest(Logger log, Seq<String> args) {
        Seq<String> seq = args;
        if (seq.isEmpty()) {
            throw scala.sys.package$.MODULE$.error("no name provided");
        }
        String testName = seq.mkString(" ").trim();
        if (this.bufferedLog().findTestNames().contains((Object)testName)) {
            throw new IllegalArgumentException(new StringBuilder(22).append("Duplicate test found: ").append(testName).toString());
        }
        log.info((Function0 & Serializable & scala.Serializable)() -> BufferedLog$StartTestLogEvent$.MODULE$.forTestName(testName));
        this.currentTestName().set(testName);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void applyChange(Logger log, Seq<String> args) {
        String string;
        String changeType = args.mkString(" ");
        File workingDir = Paths.get("src/main/scala/mlp", new String[0]).toAbsolutePath().normalize().toFile();
        Predef$.MODULE$.require(workingDir.exists());
        String string2 = changeType.toLowerCase();
        if ("major".equals(string2)) {
            string = "EquestriaMajor.scala";
        } else if ("minor".equals(string2)) {
            string = "EquestriaMinor.scala";
        } else if ("patch".equals(string2)) {
            string = "EquestriaPatch.scala";
        } else if ("original".equals(string2)) {
            string = "EquestriaOriginal.scala";
        } else {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(22).append("unexpected changeType=").append(changeType).toString());
        }
        String sourceFileName = string;
        BufferedReader reader = new BufferedReader(new FileReader(new File(workingDir, sourceFileName)));
        PrintWriter writer = new PrintWriter(new FileWriter(new File(workingDir, "Equestria.scala")));
        try {
            package$.MODULE$.Iterator().continually((Function0 & Serializable & scala.Serializable)() -> reader.readLine()).takeWhile((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ScriptedUtils$.$anonfun$applyChange$2(x$1))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.replaceFirst("^class Equestria\\w*", "class Equestria")).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                writer.println(x$1);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> reader.close());
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> writer.close());
        }
    }

    public void grepLog(Logger log, Seq<String> cmdArgs) {
        this.repeatTest((Function0<ScriptedUtils.TestResult>)(Function0 & Serializable & scala.Serializable)() -> this.impl$1(cmdArgs));
    }

    public void searchLog(Logger log, Seq<String> cmdArgs) {
        this.repeatTest((Function0<ScriptedUtils.TestResult>)(Function0 & Serializable & scala.Serializable)() -> this.impl$2(cmdArgs));
    }

    private void repeatTest(Function0<ScriptedUtils.TestResult> testFn) {
        int TestAttempts = 3;
        int TestAttemptSleepMs = 50;
        IntRef delay = IntRef.create((int)0);
        ScriptedUtils.TestResult finalResult = (ScriptedUtils.TestResult)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), TestAttempts).foldLeft((Object)new ScriptedUtils.TestResult(false, ""), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> ScriptedUtils$.$anonfun$repeatTest$1(testFn, TestAttemptSleepMs, delay, x0$1, BoxesRunTime.unboxToInt((Object)x1$1)));
        Predef$.MODULE$.assert(finalResult.pass(), (Function0 & Serializable & scala.Serializable)() -> finalResult.failMessage());
    }

    private String makeErrorSuffix(Seq<String> lines, String value) {
        String prettyLinesForError = ((TraversableOnce)((TraversableLike)((IterableLike)lines.zipWithIndex(Seq$.MODULE$.canBuildFrom())).takeRight(10)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String l = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            String string = new StringBuilder(8).append("    [").append(i + 1).append("/").append(lines.size()).append("] ").append(l).toString();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString("\n", "\n", "");
        String filePath = this.bufferedLog().bufferedFile().getAbsolutePath();
        return new StringBuilder(23).append("'").append(value).append("' for test '").append((Object)this.currentTestName().get()).append("' in log ").append(filePath).append(":").append(prettyLinesForError).toString();
    }

    public void listTestNames(Logger log) {
        List<String> testNames = this.bufferedLog().findTestNames();
        int count = testNames.size();
        log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Listing previously run test names, total=").append(count).toString());
        ((List)testNames.zipWithIndex(List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            ScriptedUtils$.$anonfun$listTestNames$2(log, count, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    public void replaceAllInFile(Logger log, Seq<String> args) {
        File workingDir = Paths.get("", new String[0]).toAbsolutePath().normalize().toFile();
        Predef$.MODULE$.require(workingDir.exists());
        List list = args.toList();
        Some some = List$.MODULE$.unapplySeq((Seq)list);
        if (some.isEmpty() || some.get() == null || ((LinearSeqOptimized)some.get()).lengthCompare(3) != 0) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(17).append("invalid command: ").append(args.mkString(" ")).toString());
        }
        String file = (String)((LinearSeqOptimized)some.get()).apply(0);
        String rex = (String)((LinearSeqOptimized)some.get()).apply(1);
        String rep = (String)((LinearSeqOptimized)some.get()).apply(2);
        Tuple3 tuple3 = new Tuple3((Object)new File(workingDir, file), (Object)rex, (Object)rep);
        Tuple3 tuple32 = tuple3;
        if (tuple32 == null) {
            throw new MatchError((Object)tuple32);
        }
        File sourceFile = (File)tuple32._1();
        String regex = (String)tuple32._2();
        String replacement = (String)tuple32._3();
        Tuple3 tuple33 = new Tuple3((Object)sourceFile, (Object)regex, (Object)replacement);
        Tuple3 tuple34 = tuple33;
        File sourceFile2 = (File)tuple34._1();
        String regex2 = (String)tuple34._2();
        String replacement2 = (String)tuple34._3();
        File destFile = new File(workingDir, new StringBuilder(8).append(sourceFile2.getName()).append(".changed").toString());
        BufferedReader reader = new BufferedReader(new FileReader(sourceFile2));
        PrintWriter writer = new PrintWriter(new FileWriter(destFile));
        try {
            package$.MODULE$.Iterator().continually((Function0 & Serializable & scala.Serializable)() -> reader.readLine()).takeWhile((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ScriptedUtils$.$anonfun$replaceAllInFile$2(x$6))).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.replaceAll(regex2, replacement2)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                writer.println(x$1);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> reader.close());
            Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> writer.close());
        }
        Files.move(destFile.toPath(), sourceFile2.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public void assertConfigError(Logger log) {
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not", "UNRESOLVED DEPENDENCIES"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Config problem"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not", "Checking DISABLED"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not", "Checking ENABLED"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[error]"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"java.lang.Illegal"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not", "published"}))));
    }

    public void assertDisabled(Logger log) {
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not", "UNRESOLVED DEPENDENCIES"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking DISABLED"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not", "Check aborted"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not", "Check starting"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not", "failing build"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not", "[error]"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not", "java.lang.Illegal"}))));
    }

    public void assertAborted(Logger log) {
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not", "UNRESOLVED DEPENDENCIES"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking ENABLED"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Check aborted"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not", "PASSED"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not", "FAILED"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not", "failing build"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not", "[error]"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not", "java.lang.Illegal"}))));
    }

    public void assertPassed(Logger log, Seq<String> args) {
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not", "UNRESOLVED DEPENDENCIES"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking ENABLED"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Check type"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Check starting"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"PASSED"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not", "failing build"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not", "[error]"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not", "java.lang.Illegal"}))));
        this.assertDiffType(log, args);
    }

    public void assertFailed(Logger log, Seq<String> args) {
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not", "UNRESOLVED DEPENDENCIES"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking ENABLED"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Check type"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Check starting"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FAILED"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"failing build"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[error]"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"java.lang.Illegal"}))));
        this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not", "published"}))));
        this.assertDiffType(log, args);
    }

    private void assertDiffType(Logger log, Seq<String> args) {
        String changeType = args.mkString(" ");
        String string = changeType.toLowerCase();
        if ("major".equals(string)) {
            this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"diffType=major"}))));
            this.grepLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"backward=[1-9][0-9]*, forward=[1-9][0-9]*"}))));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("minor".equals(string)) {
            this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"diffType=minor"}))));
            this.grepLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"backward=0, forward=[1-9][0-9]*"}))));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("patch".equals(string)) {
            this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"diffType=patch"}))));
            this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"backward=0, forward=0"}))));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("unchanged".equals(string)) {
            this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unchanged"}))));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("not normalized".equals(string)) {
            this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not normalized"}))));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if ("downgrade".equals(string)) {
            this.searchLog(log, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"downgrade"}))));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(22).append("unexpected changeType=").append(changeType).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$applyChange$2(String x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ String $anonfun$grepLog$1() {
        return "no test name; did you run 'reload' after 'startTest'?";
    }

    private final /* synthetic */ String errorSuffix$lzycompute$1(Pattern pattern$1, List lines$1, LazyRef errorSuffix$lzy$1) {
        String string;
        LazyRef lazyRef = errorSuffix$lzy$1;
        synchronized (lazyRef) {
            string = errorSuffix$lzy$1.initialized() ? (String)errorSuffix$lzy$1.value() : (String)errorSuffix$lzy$1.initialize((Object)this.makeErrorSuffix((Seq<String>)lines$1, pattern$1.pattern()));
        }
        return string;
    }

    private final String errorSuffix$1(Pattern pattern$1, List lines$1, LazyRef errorSuffix$lzy$1) {
        return errorSuffix$lzy$1.initialized() ? (String)errorSuffix$lzy$1.value() : this.errorSuffix$lzycompute$1(pattern$1, lines$1, errorSuffix$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$grepLog$2(Pattern pattern$1, String line) {
        return pattern$1.matcher(line).find();
    }

    public static final /* synthetic */ boolean $anonfun$grepLog$3(Pattern pattern$1, String line) {
        return !pattern$1.matcher(line).find();
    }

    /*
     * Unable to fully structure code
     */
    private final ScriptedUtils.TestResult impl$1(Seq cmdArgs$1) {
        errorSuffix$lzy = new LazyRef();
        var7_3 = cmdArgs$1.toList();
        if (var7_3.isEmpty()) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(17).append("invalid command: ").append(cmdArgs$1.mkString(" ")).toString());
        }
        var8_4 = List$.MODULE$.unapplySeq((Seq)var7_3);
        if (var8_4.isEmpty() || var8_4.get() == null || ((LinearSeqOptimized)var8_4.get()).lengthCompare(1) < 0) ** GOTO lbl-1000
        not = (String)((LinearSeqOptimized)var8_4.get()).apply(0);
        args = ((List)var8_4.get()).drop(1);
        v0 = not.toLowerCase();
        var11_7 = "not";
        if (!(v0 != null ? v0.equals(var11_7) == false : var11_7 != null)) {
            var3_8 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Pattern.compile(args.mkString(" ")));
        } else lbl-1000:
        // 2 sources

        {
            var3_8 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)Pattern.compile(var7_3.mkString(" ")));
        }
        var6_9 = var3_8;
        if (var6_9 == null) {
            throw new MatchError((Object)var6_9);
        }
        include = var6_9._1$mcZ$sp();
        pattern = (Pattern)var6_9._2();
        var2_12 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)include), (Object)pattern);
        var5_13 = var2_12;
        include = var5_13._1$mcZ$sp();
        pattern = (Pattern)var5_13._2();
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(this.currentTestName().get())).nonEmpty(), (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$grepLog$1(), ()Ljava/lang/String;)());
        lines = this.bufferedLog().readLogLines(this.currentTestName().get());
        return include != false ? new ScriptedUtils.TestResult(lines.exists((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$grepLog$2$adapted(java.util.regex.Pattern java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)((Pattern)pattern)), new StringBuilder(15).append("Could not find ").append(this.errorSuffix$1(pattern, lines, errorSuffix$lzy)).toString()) : new ScriptedUtils.TestResult(lines.forall((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$grepLog$3$adapted(java.util.regex.Pattern java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)((Pattern)pattern)), new StringBuilder(15).append("Found unwanted ").append(this.errorSuffix$1(pattern, lines, errorSuffix$lzy)).toString());
    }

    private final /* synthetic */ String errorSuffix$lzycompute$2(String value$1, List lines$3, LazyRef errorSuffix$lzy$2) {
        String string;
        LazyRef lazyRef = errorSuffix$lzy$2;
        synchronized (lazyRef) {
            string = errorSuffix$lzy$2.initialized() ? (String)errorSuffix$lzy$2.value() : (String)errorSuffix$lzy$2.initialize((Object)this.makeErrorSuffix((Seq<String>)lines$3, value$1));
        }
        return string;
    }

    private final String errorSuffix$2(String value$1, List lines$3, LazyRef errorSuffix$lzy$2) {
        return errorSuffix$lzy$2.initialized() ? (String)errorSuffix$lzy$2.value() : this.errorSuffix$lzycompute$2(value$1, lines$3, errorSuffix$lzy$2);
    }

    public static final /* synthetic */ boolean $anonfun$searchLog$2(String value$1, String line) {
        return !line.contains(value$1);
    }

    /*
     * Unable to fully structure code
     */
    private final ScriptedUtils.TestResult impl$2(Seq cmdArgs$2) {
        errorSuffix$lzy = new LazyRef();
        var7_3 = cmdArgs$2.toList();
        if (var7_3.isEmpty()) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(17).append("invalid command: ").append(cmdArgs$2.mkString(" ")).toString());
        }
        var8_4 = List$.MODULE$.unapplySeq((Seq)var7_3);
        if (var8_4.isEmpty() || var8_4.get() == null || ((LinearSeqOptimized)var8_4.get()).lengthCompare(1) < 0) ** GOTO lbl-1000
        not = (String)((LinearSeqOptimized)var8_4.get()).apply(0);
        args = ((List)var8_4.get()).drop(1);
        v0 = not.toLowerCase();
        var11_7 = "not";
        if (!(v0 != null ? v0.equals(var11_7) == false : var11_7 != null)) {
            var3_8 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)args.mkString(" "));
        } else lbl-1000:
        // 2 sources

        {
            var3_8 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)var7_3.mkString(" "));
        }
        var6_9 = var3_8;
        if (var6_9 == null) {
            throw new MatchError((Object)var6_9);
        }
        include = var6_9._1$mcZ$sp();
        value = (String)var6_9._2();
        var2_12 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)include), (Object)value);
        var5_13 = var2_12;
        include = var5_13._1$mcZ$sp();
        value = (String)var5_13._2();
        lines = this.bufferedLog().readLogLines(this.currentTestName().get());
        return include != false ? new ScriptedUtils.TestResult(lines.exists((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$searchLog$1$adapted(java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)((String)value)), new StringBuilder(15).append("Could not find ").append(this.errorSuffix$2(value, lines, errorSuffix$lzy)).toString()) : new ScriptedUtils.TestResult(lines.forall((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$searchLog$2$adapted(java.lang.String java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)((String)value)), new StringBuilder(15).append("Found unwanted ").append(this.errorSuffix$2(value, lines, errorSuffix$lzy)).toString());
    }

    public static final /* synthetic */ ScriptedUtils.TestResult $anonfun$repeatTest$1(Function0 testFn$1, int TestAttemptSleepMs$1, IntRef delay$1, ScriptedUtils.TestResult x0$1, int x1$1) {
        ScriptedUtils.TestResult testResult;
        ScriptedUtils.TestResult prevResult;
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)BoxesRunTime.boxToInteger((int)x1$1));
        if (tuple2 != null && (prevResult = (ScriptedUtils.TestResult)tuple2._1()).pass()) {
            testResult = prevResult;
        } else if (tuple2 != null) {
            Thread.sleep(delay$1.elem);
            delay$1.elem += TestAttemptSleepMs$1;
            testResult = (ScriptedUtils.TestResult)testFn$1.apply();
        } else {
            throw new MatchError((Object)tuple2);
        }
        return testResult;
    }

    public static final /* synthetic */ void $anonfun$listTestNames$2(Logger log$1, int count$1, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        int index = tuple2._2$mcI$sp();
        log$1.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(4).append("[").append(index + 1).append("/").append(count$1).append("] ").append(name).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$replaceAllInFile$2(String x$6) {
        return x$6 != null;
    }

    private ScriptedUtils$() {
        MODULE$ = this;
        this.bufferedLog = new BufferedLog();
        this.currentTestName = new AtomicReference<String>("");
    }

    public static final /* synthetic */ Object $anonfun$grepLog$2$adapted(Pattern pattern$1, String line) {
        return BoxesRunTime.boxToBoolean((boolean)ScriptedUtils$.$anonfun$grepLog$2(pattern$1, line));
    }

    public static final /* synthetic */ Object $anonfun$grepLog$3$adapted(Pattern pattern$1, String line) {
        return BoxesRunTime.boxToBoolean((boolean)ScriptedUtils$.$anonfun$grepLog$3(pattern$1, line));
    }

    public static final /* synthetic */ Object $anonfun$searchLog$1$adapted(String value$1, String line) {
        return BoxesRunTime.boxToBoolean((boolean)line.contains(value$1));
    }

    public static final /* synthetic */ Object $anonfun$searchLog$2$adapted(String value$1, String line) {
        return BoxesRunTime.boxToBoolean((boolean)ScriptedUtils$.$anonfun$searchLog$2(value$1, line));
    }
}

