/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.scd;

import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.impl.scd.SCDException;
import org.apache.xerces.impl.scd.SCDParser;
import org.apache.xerces.impl.scd.Step;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeGroupDefinition;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSFacet;
import org.apache.xerces.xs.XSIDCDefinition;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSModelGroupDefinition;
import org.apache.xerces.xs.XSMultiValueFacet;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSNotationDeclaration;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;

public class SCDResolver {
    private XSModel xsModel;
    private List result;
    private List currentComponents;
    private SCDParser parser;
    private static final short NO_FILTER = -1;
    private static final boolean IS_SPEC_COMPLIANT = false;
    private static final short LIST_SIZE = 30;

    public SCDResolver(XSModel xsModel) {
        this.xsModel = xsModel;
        this.result = new ArrayList(30);
        this.currentComponents = new ArrayList(30);
        this.parser = new SCDParser();
    }

    public XSObjectList resolve(String relativeSCD) throws SCDException {
        List steps = this.parser.parseRelativeSCD(relativeSCD, false);
        if (steps.size() == 1 && ((Step)steps.get(0)).getAxisType() == 100 && ((Step)steps.get(0)).getNametest() == null && ((Step)steps.get(0)).getPredicate() == 0) {
            throw new SCDException("Error in SCD: Schema step is not supported");
        }
        this.result.clear();
        this.applyFirstStep((Step)steps.get(0));
        return this.evaluate(steps, 1);
    }

    public XSObjectList resolve(String scp, NamespaceContext nsContext) throws SCDException {
        List steps = this.parser.parseSCP(scp, nsContext, false);
        if (steps.size() == 1 && ((Step)steps.get(0)).getAxisType() == 100 && ((Step)steps.get(0)).getNametest() == null && ((Step)steps.get(0)).getPredicate() == 0) {
            throw new SCDException("Error in SCD: Schema step is not supported");
        }
        this.result.clear();
        this.applyFirstStep((Step)steps.get(0));
        return this.evaluate(steps, 1);
    }

    public XSObjectList resolve(String incompleteSCP, NamespaceContext nsContext, XSObject currentComponent) throws SCDException {
        List steps = this.parser.parseSCP(incompleteSCP, nsContext, true);
        this.result.clear();
        this.result.add(currentComponent);
        return this.evaluate(steps, 0);
    }

    public XSObjectList resolve(String incompleteSCD, XSObject currentComponent) throws SCDException {
        List steps = this.parser.parseRelativeSCD(incompleteSCD, true);
        this.result.clear();
        this.result.add(currentComponent);
        return this.evaluate(steps, 0);
    }

    private XSObjectList evaluate(List steps, int startingStep) throws SCDException {
        int nSteps = steps.size();
        for (int i = startingStep; i < nSteps; ++i) {
            int j;
            this.currentComponents.clear();
            Step step = (Step)steps.get(i);
            short axisType = step.getAxisType();
            int n = this.result.size();
            for (j = 0; j < n; ++j) {
                this.currentComponents.add(this.result.get(j));
            }
            if (axisType != 27) {
                n = this.currentComponents.size();
                for (j = 0; j < n; ++j) {
                    this.addElidedComponents((XSObject)this.currentComponents.get(j));
                }
            }
            this.result.clear();
            this.applyStep(step);
            if (axisType != 27) continue;
            step = (Step)steps.get(++i);
            List tmp = this.currentComponents;
            this.currentComponents = this.result;
            this.result = tmp;
            this.result.clear();
            this.applyStep(step);
        }
        XSObjectListImpl resultComps = new XSObjectListImpl();
        int n = this.result.size();
        for (int i = 0; i < n; ++i) {
            resultComps.addXSObject((XSObject)this.result.get(i));
        }
        return resultComps;
    }

    private void addElidedComponents(XSObject sourceComponent) {
        for (int i = this.currentComponents.size() - 1; i < this.currentComponents.size(); ++i) {
            this.term((XSObject)this.currentComponents.get(i), (short)7, SCDParser.WILDCARD, this.currentComponents);
        }
        switch (sourceComponent.getType()) {
            case 2: {
                XSTypeDefinition typeDef = ((XSElementDeclaration)sourceComponent).getTypeDefinition();
                if (typeDef == null || this.currentComponents.contains(typeDef)) break;
                this.currentComponents.add(typeDef);
                break;
            }
            case 1: {
                XSSimpleTypeDefinition typeDef = ((XSAttributeDeclaration)sourceComponent).getTypeDefinition();
                if (typeDef == null || this.currentComponents.contains(typeDef)) break;
                this.currentComponents.add(typeDef);
            }
        }
    }

    private void applyFirstStep(Step step) throws SCDException {
        XSNamedMap map = null;
        switch (step.getAxisType()) {
            case 21: {
                XSObjectList annotations = this.xsModel.getAnnotations();
                int n = annotations.size();
                for (int i = 0; i < n; ++i) {
                    this.addComponent(annotations.item(i), step.getNametest(), this.result);
                }
                break;
            }
            case 1: {
                map = this.xsModel.getComponents((short)2);
                break;
            }
            case 2: {
                map = this.xsModel.getComponents((short)3);
                break;
            }
            case 0: {
                map = this.xsModel.getComponents((short)1);
                break;
            }
            case 3: {
                map = this.xsModel.getComponents((short)5);
                break;
            }
            case 4: {
                map = this.xsModel.getComponents((short)6);
                break;
            }
            case 8: {
                map = this.xsModel.getComponents((short)11);
                break;
            }
            case 22: 
            case 27: {
                int start;
                this.currentComponents.clear();
                this.addTopLevelComponents(step.getNametest());
                int size = this.currentComponents.size();
                for (int i = 0; i < this.currentComponents.size(); ++i) {
                    this.componentChildren((XSObject)this.currentComponents.get(i), (short)-1, SCDParser.WILDCARD, this.currentComponents);
                }
                for (int i = start = step.getAxisType() == 27 ? 0 : size; i < this.currentComponents.size(); ++i) {
                    this.addComponent((XSObject)this.currentComponents.get(i), step.getNametest(), this.result);
                }
                break;
            }
            default: {
                throw new SCDException("Error in SCD: Unsupported top level component type " + step.getAxisName());
            }
        }
        if (map != null && !map.isEmpty()) {
            int n = map.size();
            for (int i = 0; i < n; ++i) {
                this.addComponent(map.item(i), step.getNametest(), this.result);
            }
        }
        this.applyPredicate(step.getPredicate());
    }

    private void applyStep(Step step) throws SCDException {
        switch (step.getAxisType()) {
            case 1: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.term((XSObject)this.currentComponents.get(i), (short)2, step.getNametest(), this.result);
                }
                break;
            }
            case 0: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.componentLinked((XSObject)this.currentComponents.get(i), (short)1, step.getNametest(), this.result);
                }
                break;
            }
            case 2: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.componentChildren((XSObject)this.currentComponents.get(i), (short)3, step.getNametest(), this.result);
                }
                break;
            }
            case 23: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.result.add(this.currentComponents.get(i));
                }
                return;
            }
            case 22: 
            case 27: {
                int start;
                int size = this.currentComponents.size();
                for (int i = 0; i < this.currentComponents.size(); ++i) {
                    this.componentChildren((XSObject)this.currentComponents.get(i), (short)-1, SCDParser.WILDCARD, this.currentComponents);
                }
                for (int i = start = step.getAxisType() == 27 ? 0 : size; i < this.currentComponents.size(); ++i) {
                    this.addComponent((XSObject)this.currentComponents.get(i), step.getNametest(), this.result);
                }
                break;
            }
            case 3: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.componentLinked((XSObject)this.currentComponents.get(i), (short)5, step.getNametest(), this.result);
                }
                break;
            }
            case 4: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.componentLinked((XSObject)this.currentComponents.get(i), (short)6, step.getNametest(), this.result);
                }
                break;
            }
            case 5: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.componentLinked((XSObject)this.currentComponents.get(i), (short)10, step.getNametest(), this.result);
                }
                break;
            }
            case 6: {
                throw new SCDException("Error in SCD: Assertion axis is not supported");
            }
            case 7: {
                throw new SCDException("Error in SCD: Alternative axis is not supported");
            }
            case 8: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.componentLinked((XSObject)this.currentComponents.get(i), (short)11, step.getNametest(), this.result);
                }
                break;
            }
            case 9: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.term((XSObject)this.currentComponents.get(i), (short)7, step.getNametest(), this.result);
                }
                break;
            }
            case 10: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    XSObject comp = (XSObject)this.currentComponents.get(i);
                    short type = comp.getType();
                    if (type == 3) {
                        type = ((XSTypeDefinition)comp).getTypeCategory();
                        if (type != 15) continue;
                        this.addComponent(((XSComplexTypeDefinition)comp).getAttributeWildcard(), step.getNametest(), this.result);
                        continue;
                    }
                    if (type != 5) continue;
                    this.addComponent(((XSAttributeGroupDefinition)comp).getAttributeWildcard(), step.getNametest(), this.result);
                }
                break;
            }
            case 11: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.term((XSObject)this.currentComponents.get(i), (short)9, step.getNametest(), this.result);
                }
                break;
            }
            case 12: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.componentLinked((XSObject)this.currentComponents.get(i), (short)13, step.getNametest(), this.result);
                }
                break;
            }
            case 13: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.componentScope((XSObject)this.currentComponents.get(i), this.result);
                }
                break;
            }
            case 14: {
                throw new SCDException("Error in SCD: Context axis is not supported");
            }
            case 15: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    XSObject comp = (XSObject)this.currentComponents.get(i);
                    if (comp.getType() != 2) continue;
                    this.addComponent(((XSElementDeclaration)comp).getSubstitutionGroupAffiliation(), step.getNametest(), this.result);
                }
                break;
            }
            case 16: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    if (((XSObject)this.currentComponents.get(i)).getType() != 3) continue;
                    this.addComponent(((XSTypeDefinition)this.currentComponents.get(i)).getBaseType(), step.getNametest(), this.result);
                }
                break;
            }
            case 17: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    XSObject comp;
                    if (((XSObject)this.currentComponents.get(i)).getType() != 3 || ((XSTypeDefinition)(comp = (XSObject)this.currentComponents.get(i))).getTypeCategory() != 16) continue;
                    this.addComponent(((XSSimpleTypeDefinition)comp).getItemType(), step.getNametest(), this.result);
                }
                break;
            }
            case 18: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    XSObject comp;
                    if (((XSObject)this.currentComponents.get(i)).getType() != 3 || ((XSTypeDefinition)(comp = (XSObject)this.currentComponents.get(i))).getTypeCategory() != 16) continue;
                    XSObjectList memberTypes = ((XSSimpleTypeDefinition)comp).getMemberTypes();
                    int nt = memberTypes.size();
                    for (int j = 0; j < nt; ++j) {
                        this.addComponent((XSObject)memberTypes.get(j), step.getNametest(), this.result);
                    }
                }
                break;
            }
            case 19: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    XSObject comp;
                    if (((XSObject)this.currentComponents.get(i)).getType() != 3 || ((XSTypeDefinition)(comp = (XSObject)this.currentComponents.get(i))).getTypeCategory() != 16) continue;
                    this.addComponent(((XSSimpleTypeDefinition)comp).getPrimitiveType(), step.getNametest(), this.result);
                }
                break;
            }
            case 20: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    if (((XSObject)this.currentComponents.get(i)).getType() != 10) continue;
                    this.addComponent(((XSIDCDefinition)this.currentComponents.get(i)).getRefKey(), step.getNametest(), this.result);
                }
                break;
            }
            case 21: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    this.annotations((XSObject)this.currentComponents.get(i), this.result);
                }
                break;
            }
            case 24: {
                XSObjectList attribUses = null;
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    XSObject comp = (XSObject)this.currentComponents.get(i);
                    if (comp.getType() == 3) {
                        if (((XSTypeDefinition)comp).getTypeCategory() == 15) {
                            attribUses = ((XSComplexTypeDefinition)comp).getAttributeUses();
                        }
                    } else if (comp.getType() == 5) {
                        attribUses = ((XSAttributeGroupDefinition)comp).getAttributeUses();
                    }
                    if (attribUses == null) continue;
                    int na = attribUses.size();
                    for (int j = 0; j < na; ++j) {
                        this.addComponent((XSObject)attribUses.get(j), step.getNametest(), this.result);
                    }
                }
                break;
            }
            case 25: {
                int n = this.currentComponents.size();
                for (int i = 0; i < n; ++i) {
                    XSObject comp = (XSObject)this.currentComponents.get(i);
                    if (comp.getType() != 7) continue;
                    XSObjectList particles = ((XSModelGroup)comp).getParticles();
                    int np = particles.size();
                    for (int j = 0; j < np; ++j) {
                        this.addComponent((XSObject)particles.get(j), step.getNametest(), this.result);
                    }
                }
                break;
            }
            case 26: {
                throw new SCDException("Error in SCD: Extension axis is not supported");
            }
            default: {
                throw new SCDException("Error in SCD: Unsupported axis type " + step.getAxisName());
            }
        }
        this.applyPredicate(step.getPredicate());
    }

    private void addTopLevelComponents(QName nameTest) {
        XSObjectList annotations = this.xsModel.getAnnotations();
        int n = annotations.size();
        for (int i = 0; i < n; ++i) {
            this.addComponent(annotations.item(i), nameTest, this.result);
        }
        short[] SCHEMA_COMPONENTS = new short[]{2, 3, 1, 5, 6, 11};
        for (int i = 0; i < SCHEMA_COMPONENTS.length; ++i) {
            XSNamedMap map = this.xsModel.getComponents(SCHEMA_COMPONENTS[i]);
            if (map.isEmpty()) continue;
            int n2 = map.size();
            for (int j = 0; j < n2; ++j) {
                this.addComponent(map.item(i), nameTest, this.result);
            }
        }
    }

    private void applyPredicate(int predicate) throws SCDException {
        if (predicate == 0) {
            return;
        }
        if (predicate <= 0 || predicate > this.result.size()) {
            throw new SCDException("Error in SCD: Invalid predicate value (" + predicate + ") detected");
        }
        XSObject component = (XSObject)this.result.get(predicate - 1);
        this.result.clear();
        this.result.add(component);
    }

    private void term(XSObject sourceComponent, short filter, QName nameTest, List outputComponents) {
        switch (sourceComponent.getType()) {
            case 6: {
                if (-1 != filter && 7 != filter) break;
                this.addComponent(((XSModelGroupDefinition)sourceComponent).getModelGroup(), nameTest, outputComponents);
                break;
            }
            case 3: {
                XSParticle particle;
                if (((XSTypeDefinition)sourceComponent).getTypeCategory() != 15 || (particle = ((XSComplexTypeDefinition)sourceComponent).getParticle()) == null) break;
                XSTerm term = particle.getTerm();
                if (-1 != filter && (term == null || term.getType() != filter)) break;
                this.addComponent(term, nameTest, outputComponents);
                break;
            }
            case 8: {
                XSTerm term = ((XSParticle)sourceComponent).getTerm();
                if (-1 != filter && (term == null || term.getType() != filter)) break;
                this.addComponent(term, nameTest, outputComponents);
                break;
            }
            case 7: {
                XSObjectList particles = ((XSModelGroup)sourceComponent).getParticles();
                int n = particles.size();
                for (int i = 0; i < n; ++i) {
                    XSTerm term = ((XSParticle)particles.item(i)).getTerm();
                    if (-1 != filter && (term == null || term.getType() != filter)) continue;
                    this.addComponent(term, nameTest, outputComponents);
                }
                break;
            }
        }
    }

    private String componentVariety(XSObject component) {
        short type = component.getType();
        if (type == 7) {
            switch (((XSModelGroup)component).getCompositor()) {
                case 1: {
                    return "sequence";
                }
                case 3: {
                    return "all";
                }
                case 2: {
                    return "choice";
                }
            }
        } else if (type == 13 || type == 14) {
            int kind = -1;
            kind = type == 13 ? (int)((XSFacet)component).getFacetKind() : (int)((XSMultiValueFacet)component).getFacetKind();
            switch (kind) {
                case 2048: {
                    return "enumeration";
                }
                case 1024: {
                    return "fractionDigits";
                }
                case 1: {
                    return "length";
                }
                case 64: {
                    return "maxExclusive";
                }
                case 32: {
                    return "maxInclusive";
                }
                case 4: {
                    return "maxLength";
                }
                case 128: {
                    return "minExclusive";
                }
                case 256: {
                    return "minInclusive";
                }
                case 2: {
                    return "minLength";
                }
                case 8: {
                    return "pattern";
                }
                case 512: {
                    return "totalDigits";
                }
                case 16: {
                    return "whiteSpace";
                }
            }
        }
        return null;
    }

    private void componentLinked(XSObject sourceComponent, short filter, QName nameTest, List targetComponents) throws SCDException {
        switch (sourceComponent.getType()) {
            case 1: {
                this.componentChildren(sourceComponent, filter, nameTest, targetComponents);
                if (-1 == filter || 12 == filter) {
                    this.annotations(sourceComponent, targetComponents);
                }
                if (-1 != filter && 3 != filter || ((XSAttributeDeclaration)sourceComponent).getScope() != 2) break;
                this.addComponent(((XSAttributeDeclaration)sourceComponent).getEnclosingCTDefinition(), nameTest, targetComponents);
                break;
            }
            case 2: {
                this.componentChildren(sourceComponent, filter, nameTest, targetComponents);
                if (-1 == filter || 12 == filter) {
                    this.annotations(sourceComponent, targetComponents);
                }
                if ((-1 == filter || 3 == filter) && ((XSElementDeclaration)sourceComponent).getScope() == 2) {
                    this.addComponent(((XSElementDeclaration)sourceComponent).getEnclosingCTDefinition(), nameTest, targetComponents);
                }
                if (-1 == filter || 10 == filter) {
                    XSNamedMap idcs = ((XSElementDeclaration)sourceComponent).getIdentityConstraints();
                    int n = idcs.size();
                    for (int i = 0; i < n; ++i) {
                        this.addComponent(idcs.item(i), nameTest, targetComponents);
                    }
                }
                if (-1 != filter && 2 != filter) break;
                this.addComponent(((XSElementDeclaration)sourceComponent).getSubstitutionGroupAffiliation(), nameTest, targetComponents);
                break;
            }
            case 3: {
                if (((XSTypeDefinition)sourceComponent).getTypeCategory() == 16) {
                    this.componentChildren(sourceComponent, filter, nameTest, targetComponents);
                    if (-1 == filter || 12 == filter) {
                        this.annotations(sourceComponent, targetComponents);
                    }
                    if (-1 != filter && 3 != filter) break;
                    this.addComponent(((XSSimpleTypeDefinition)sourceComponent).getBaseType(), nameTest, targetComponents);
                    this.addComponent(((XSSimpleTypeDefinition)sourceComponent).getPrimitiveType(), nameTest, targetComponents);
                    this.addComponent(((XSSimpleTypeDefinition)sourceComponent).getItemType(), nameTest, targetComponents);
                    XSObjectList list = ((XSSimpleTypeDefinition)sourceComponent).getMemberTypes();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        this.addComponent(list.item(i), nameTest, targetComponents);
                    }
                    break;
                }
                this.componentChildren(sourceComponent, filter, nameTest, targetComponents);
                if (-1 == filter || 12 == filter) {
                    this.annotations(sourceComponent, targetComponents);
                }
                if (-1 == filter || 3 == filter) {
                    this.addComponent(((XSComplexTypeDefinition)sourceComponent).getBaseType(), nameTest, targetComponents);
                }
                if (-1 != filter && 9 != filter) break;
                this.addComponent(((XSComplexTypeDefinition)sourceComponent).getAttributeWildcard(), nameTest, targetComponents);
                break;
            }
            case 4: {
                this.componentChildren(sourceComponent, filter, nameTest, targetComponents);
                if (-1 != filter && 12 != filter) break;
                this.annotations(sourceComponent, targetComponents);
                break;
            }
            case 5: {
                this.componentChildren(sourceComponent, filter, nameTest, targetComponents);
                if (-1 == filter || 12 == filter) {
                    this.annotations(sourceComponent, targetComponents);
                }
                if (-1 != filter && 9 != filter) break;
                this.addComponent(((XSAttributeGroupDefinition)sourceComponent).getAttributeWildcard(), nameTest, targetComponents);
                break;
            }
            case 6: {
                this.componentChildren(sourceComponent, filter, nameTest, targetComponents);
                if (-1 != filter && 12 != filter) break;
                this.annotations(sourceComponent, targetComponents);
                break;
            }
            case 7: {
                this.componentChildren(sourceComponent, filter, nameTest, targetComponents);
                if (-1 != filter && 12 != filter) break;
                this.annotations(sourceComponent, targetComponents);
                break;
            }
            case 8: {
                this.componentChildren(sourceComponent, filter, nameTest, targetComponents);
                break;
            }
            case 9: {
                if (-1 != filter && 12 != filter) break;
                this.annotations(sourceComponent, targetComponents);
                break;
            }
            case 10: {
                if (-1 == filter || 12 == filter) {
                    this.annotations(sourceComponent, targetComponents);
                }
                if (-1 != filter && 10 != filter) break;
                this.addComponent(((XSIDCDefinition)sourceComponent).getRefKey(), nameTest, targetComponents);
                break;
            }
            case 11: {
                if (-1 != filter && 12 != filter) break;
                this.annotations(sourceComponent, targetComponents);
                break;
            }
            case 13: {
                if (-1 != filter && 12 != filter) break;
                this.annotations(sourceComponent, targetComponents);
                break;
            }
            case 14: {
                if (-1 != filter && 12 != filter) break;
                this.annotations(sourceComponent, targetComponents);
                break;
            }
        }
    }

    private void componentChildren(XSObject sourceComponent, short filter, QName nameTest, List targetComponents) {
        block0 : switch (sourceComponent.getType()) {
            case 1: {
                if (-1 != filter && 3 != filter) break;
                this.addComponent(((XSAttributeDeclaration)sourceComponent).getTypeDefinition(), nameTest, targetComponents);
                break;
            }
            case 2: {
                if (-1 != filter && 3 != filter) break;
                this.addComponent(((XSElementDeclaration)sourceComponent).getTypeDefinition(), nameTest, targetComponents);
                break;
            }
            case 3: {
                if (((XSTypeDefinition)sourceComponent).getTypeCategory() == 16) {
                    int i;
                    if (-1 != filter && 13 != filter) break;
                    XSObjectList facets = ((XSSimpleTypeDefinition)sourceComponent).getFacets();
                    int n = facets.size();
                    for (i = 0; i < n; ++i) {
                        this.addComponent(facets.item(i), nameTest, targetComponents);
                    }
                    facets = ((XSSimpleTypeDefinition)sourceComponent).getMultiValueFacets();
                    n = facets.size();
                    for (i = 0; i < n; ++i) {
                        this.addComponent(facets.item(i), nameTest, targetComponents);
                    }
                    break;
                }
                XSComplexTypeDefinition cmplxType = (XSComplexTypeDefinition)sourceComponent;
                if (-1 == filter || 4 == filter) {
                    XSObjectList attributeUses = cmplxType.getAttributeUses();
                    int n = attributeUses.size();
                    for (int i = 0; i < n; ++i) {
                        this.addComponent(attributeUses.item(i), nameTest, targetComponents);
                    }
                }
                short componentVariety = cmplxType.getContentType();
                switch (componentVariety) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (-1 != filter && 3 != filter) break block0;
                        this.addComponent(cmplxType.getSimpleType(), nameTest, targetComponents);
                        break;
                    }
                    default: {
                        this.term(cmplxType, filter, nameTest, targetComponents);
                        break;
                    }
                }
                break;
            }
            case 4: {
                if (-1 != filter && 1 != filter) break;
                this.addComponent(((XSAttributeUse)sourceComponent).getAttrDeclaration(), nameTest, targetComponents);
                break;
            }
            case 5: {
                if (-1 != filter && 1 != filter) break;
                XSObjectList attrbuses = ((XSAttributeGroupDefinition)sourceComponent).getAttributeUses();
                int n = attrbuses.size();
                for (int i = 0; i < n; ++i) {
                    this.addComponent(((XSAttributeUse)attrbuses.item(i)).getAttrDeclaration(), nameTest, targetComponents);
                }
                break;
            }
            case 6: {
                if (-1 != filter && 7 != filter) break;
                this.addComponent(((XSModelGroupDefinition)sourceComponent).getModelGroup(), nameTest, targetComponents);
                break;
            }
            case 7: {
                XSObjectList particles = ((XSModelGroup)sourceComponent).getParticles();
                int n = particles.size();
                for (int i = 0; i < n; ++i) {
                    XSTerm term = ((XSParticle)particles.item(i)).getTerm();
                    if (-1 != filter && term.getType() != filter) continue;
                    this.addComponent(term, nameTest, targetComponents);
                }
                break;
            }
            case 8: {
                XSTerm term = ((XSParticle)sourceComponent).getTerm();
                if (-1 != filter && term.getType() != filter) break;
                this.addComponent(term, nameTest, targetComponents);
                break;
            }
        }
    }

    private void annotations(XSObject sourceComponent, List targetComponents) throws SCDException {
        XSObjectList annotations;
        switch (sourceComponent.getType()) {
            case 1: {
                annotations = ((XSAttributeDeclaration)sourceComponent).getAnnotations();
                break;
            }
            case 2: {
                annotations = ((XSElementDeclaration)sourceComponent).getAnnotations();
                break;
            }
            case 3: {
                if (((XSTypeDefinition)sourceComponent).getTypeCategory() == 15) {
                    annotations = ((XSComplexTypeDefinition)sourceComponent).getAnnotations();
                    break;
                }
                annotations = ((XSSimpleTypeDefinition)sourceComponent).getAnnotations();
                break;
            }
            case 4: {
                annotations = ((XSAttributeUse)sourceComponent).getAnnotations();
                break;
            }
            case 5: {
                annotations = ((XSAttributeGroupDefinition)sourceComponent).getAnnotations();
                break;
            }
            case 7: {
                annotations = ((XSModelGroup)sourceComponent).getAnnotations();
                break;
            }
            case 6: {
                annotations = ((XSModelGroupDefinition)sourceComponent).getAnnotations();
                break;
            }
            case 8: {
                annotations = ((XSParticle)sourceComponent).getAnnotations();
                break;
            }
            case 9: {
                annotations = ((XSWildcard)sourceComponent).getAnnotations();
                break;
            }
            case 10: {
                annotations = ((XSIDCDefinition)sourceComponent).getAnnotations();
                break;
            }
            case 11: {
                annotations = ((XSNotationDeclaration)sourceComponent).getAnnotations();
                break;
            }
            case 13: {
                annotations = ((XSFacet)sourceComponent).getAnnotations();
                break;
            }
            case 14: {
                annotations = ((XSMultiValueFacet)sourceComponent).getAnnotations();
                break;
            }
            default: {
                throw new SCDException("Error in SCD: annotations accessor is not supported for the component type " + sourceComponent.getType());
            }
        }
        if (annotations != null) {
            int n = annotations.size();
            for (int i = 0; i < n; ++i) {
                XSObject annotation = annotations.item(i);
                if (annotation == null || targetComponents.contains(annotation)) continue;
                targetComponents.add(annotation);
            }
        }
    }

    private void componentScope(XSObject sourceComponent, List targetComponents) {
        switch (sourceComponent.getType()) {
            case 1: {
                XSComplexTypeDefinition type;
                if (((XSAttributeDeclaration)sourceComponent).getScope() == 1 || (type = ((XSAttributeDeclaration)sourceComponent).getEnclosingCTDefinition()) == null || targetComponents.contains(type)) break;
                targetComponents.add(type);
                break;
            }
            case 2: {
                XSComplexTypeDefinition type;
                if (((XSElementDeclaration)sourceComponent).getScope() == 1 || (type = ((XSElementDeclaration)sourceComponent).getEnclosingCTDefinition()) == null || targetComponents.contains(type)) break;
                targetComponents.add(type);
            }
        }
    }

    private void addComponent(XSObject component, QName nameTest, List resultComponents) {
        if (component == null || resultComponents.contains(component)) {
            return;
        }
        if (nameTest == SCDParser.ZERO) {
            if (component.getType() == 3 && component.getName() == null) {
                resultComponents.add(component);
            }
        } else if (nameTest == SCDParser.WILDCARD) {
            resultComponents.add(component);
        } else {
            String localPart = component.getName();
            String uri = component.getNamespace();
            if (uri != null && localPart != null) {
                if (uri.equals(nameTest.uri) && localPart.equals(nameTest.localpart)) {
                    resultComponents.add(component);
                }
            } else if (uri == null && localPart != null) {
                if (nameTest.uri == null && localPart.equals(nameTest.localpart)) {
                    resultComponents.add(component);
                }
            } else if (uri == null && localPart == null) {
                String variety = null;
                short type = component.getType();
                if (type == 7 || type == 13 || type == 14) {
                    variety = this.componentVariety(component);
                    if (nameTest.uri == null && nameTest.localpart.equals(variety)) {
                        resultComponents.add(component);
                    }
                }
            }
        }
    }

    public String toString() {
        return "(current components=" + this.currentComponents.toString() + ", result=" + this.result.toString() + ")";
    }
}

