/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.perf;

import com.rabbitmq.stream.perf.Monitoring;
import com.rabbitmq.stream.perf.MonitoringContext;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import picocli.CommandLine;

class PrometheusEndpointMonitoring
implements Monitoring {
    @CommandLine.Option(names={"--prometheus"}, description={"Enable HTTP Prometheus metrics endpoint"}, defaultValue="false")
    private boolean enabled;
    private volatile PrometheusMeterRegistry registry;

    PrometheusEndpointMonitoring() {
    }

    @Override
    public void configure(MonitoringContext context) {
        if (this.enabled) {
            this.registry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
            context.meterRegistry().add((MeterRegistry)this.registry);
            context.addHttpEndpoint("metrics", (Handler)new AbstractHandler(){

                public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                    String scraped = PrometheusEndpointMonitoring.this.registry.scrape();
                    response.setStatus(200);
                    response.setContentLength(scraped.length());
                    response.setContentType("text/plain");
                    response.getWriter().print(scraped);
                    baseRequest.setHandled(true);
                }
            });
        }
    }
}

