/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.sasl;

import com.rabbitmq.stream.sasl.CredentialsProvider;
import com.rabbitmq.stream.sasl.SaslMechanism;
import com.rabbitmq.stream.sasl.UsernamePasswordCredentialsProvider;
import java.nio.charset.StandardCharsets;

public class PlainSaslMechanism
implements SaslMechanism {
    public static final SaslMechanism INSTANCE = new PlainSaslMechanism();
    private static final String UNICODE_NULL = "\u0000";

    @Override
    public String getName() {
        return "PLAIN";
    }

    @Override
    public byte[] handleChallenge(byte[] challenge, CredentialsProvider credentialsProvider) {
        if (credentialsProvider instanceof UsernamePasswordCredentialsProvider) {
            UsernamePasswordCredentialsProvider usernamePasswordCredentialsProvider = (UsernamePasswordCredentialsProvider)credentialsProvider;
            String response = UNICODE_NULL + usernamePasswordCredentialsProvider.getUsername() + UNICODE_NULL + usernamePasswordCredentialsProvider.getPassword();
            return response.getBytes(StandardCharsets.UTF_8);
        }
        throw new IllegalArgumentException("Only username/password credentials provider is supported, not " + CredentialsProvider.class.getSimpleName());
    }
}

