/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.impl;

import com.rabbitmq.stream.ChunkChecksum;
import com.rabbitmq.stream.ChunkChecksumValidationException;
import com.rabbitmq.stream.StreamException;
import io.netty.buffer.ByteBuf;
import io.netty.util.ByteProcessor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JdkChunkChecksum
implements ChunkChecksum {
    static final ChunkChecksum CRC32_SINGLETON;
    private static final Logger LOGGER;
    private static final Supplier<Checksum> CRC32_SUPPLIER;
    private final Supplier<Checksum> checksumSupplier;

    JdkChunkChecksum() {
        this(CRC32_SUPPLIER);
    }

    JdkChunkChecksum(Supplier<Checksum> checksumSupplier) {
        this.checksumSupplier = checksumSupplier;
    }

    private static boolean isChecksumUpdateByteBufferAvailable() {
        try {
            Checksum.class.getDeclaredMethod("update", ByteBuffer.class);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void checksum(ByteBuf byteBuf, long dataLength, long expected) {
        Checksum checksum = this.checksumSupplier.get();
        if (byteBuf.hasArray()) {
            checksum.update(byteBuf.array(), byteBuf.arrayOffset() + byteBuf.readerIndex(), byteBuf.readableBytes());
        } else {
            byteBuf.forEachByte(byteBuf.readerIndex(), byteBuf.readableBytes(), (ByteProcessor)new UpdateProcessor(checksum));
        }
        if (expected != checksum.getValue()) {
            throw new ChunkChecksumValidationException(expected, checksum.getValue());
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(JdkChunkChecksum.class);
        CRC32_SUPPLIER = CRC32::new;
        if (JdkChunkChecksum.isChecksumUpdateByteBufferAvailable()) {
            LOGGER.debug("Checksum#update(ByteBuffer) method available, using it for direct buffers");
            CRC32_SINGLETON = new ByteBufferDirectByteBufChecksum(CRC32_SUPPLIER);
        } else {
            LOGGER.debug("Checksum#update(ByteBuffer) method not available, using byte-by-byte CRC calculation for direct buffers");
            CRC32_SINGLETON = new JdkChunkChecksum(CRC32_SUPPLIER);
        }
    }

    private static class UpdateProcessor
    implements ByteProcessor {
        private final Checksum checksum;

        private UpdateProcessor(Checksum checksum) {
            this.checksum = checksum;
        }

        public boolean process(byte value) {
            this.checksum.update(value);
            return true;
        }
    }

    private static class ByteBufferDirectByteBufChecksum
    implements ChunkChecksum {
        private final Supplier<Checksum> checksumSupplier;
        private final Method updateMethod;

        private ByteBufferDirectByteBufChecksum(Supplier<Checksum> checksumSupplier) {
            this.checksumSupplier = checksumSupplier;
            try {
                this.updateMethod = Checksum.class.getDeclaredMethod("update", ByteBuffer.class);
            }
            catch (NoSuchMethodException e) {
                throw new StreamException("Error while looking up Checksum#update(ByteBuffer) method", e);
            }
        }

        @Override
        public void checksum(ByteBuf byteBuf, long dataLength, long expected) {
            Checksum checksum = this.checksumSupplier.get();
            if (byteBuf.hasArray()) {
                checksum.update(byteBuf.array(), byteBuf.arrayOffset() + byteBuf.readerIndex(), byteBuf.readableBytes());
            } else {
                try {
                    this.updateMethod.invoke((Object)checksum, byteBuf.nioBuffer(byteBuf.readerIndex(), byteBuf.readableBytes()));
                }
                catch (IllegalAccessException e) {
                    throw new StreamException("Error while calculating CRC", e);
                }
                catch (InvocationTargetException e) {
                    throw new StreamException("Error while calculating CRC", e);
                }
            }
            if (expected != checksum.getValue()) {
                throw new ChunkChecksumValidationException(expected, checksum.getValue());
            }
        }
    }
}

