/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.compression;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdInputStream;
import com.github.luben.zstd.ZstdOutputStream;
import com.rabbitmq.stream.compression.Compression;
import com.rabbitmq.stream.compression.CompressionCodec;
import com.rabbitmq.stream.compression.CompressionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.jpountz.lz4.LZ4FrameInputStream;
import net.jpountz.lz4.LZ4FrameOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorInputStream;
import org.apache.commons.compress.compressors.lz4.FramedLZ4CompressorOutputStream;
import org.apache.commons.compress.compressors.snappy.FramedSnappyCompressorInputStream;
import org.apache.commons.compress.compressors.snappy.FramedSnappyCompressorOutputStream;
import org.apache.commons.compress.compressors.snappy.FramedSnappyDialect;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyFramedInputStream;
import org.xerial.snappy.SnappyFramedOutputStream;

public final class CompressionUtils {
    private CompressionUtils() {
    }

    public static class CommonsCompressZstdCompressionCodec
    implements CompressionCodec {
        @Override
        public int maxCompressedLength(int sourceLength) {
            return (int)Zstd.compressBound((long)sourceLength);
        }

        @Override
        public OutputStream compress(OutputStream outputStream) {
            try {
                return new ZstdCompressorOutputStream(outputStream);
            }
            catch (IOException e) {
                throw new CompressionException("Error while creating Zstd compression output stream", e);
            }
        }

        @Override
        public InputStream decompress(InputStream inputStream) {
            try {
                return new ZstdCompressorInputStream(inputStream);
            }
            catch (IOException e) {
                throw new CompressionException("Error while creating Zstd compression input stream", e);
            }
        }

        @Override
        public byte code() {
            return Compression.ZSTD.code;
        }

        public String toString() {
            return "Zstd codec (Commons Compress)";
        }
    }

    public static class CommonsCompressLz4CompressionCodec
    implements CompressionCodec {
        private static final FramedLZ4CompressorOutputStream.Parameters DEFAULT = new FramedLZ4CompressorOutputStream.Parameters(FramedLZ4CompressorOutputStream.BlockSize.K64, true, false, false);

        @Override
        public int maxCompressedLength(int sourceLength) {
            return sourceLength + sourceLength / 255 + 16;
        }

        @Override
        public OutputStream compress(OutputStream outputStream) {
            try {
                return new FramedLZ4CompressorOutputStream(outputStream, DEFAULT);
            }
            catch (IOException e) {
                throw new CompressionException("Error while creating LZ4 compression output stream", e);
            }
        }

        @Override
        public InputStream decompress(InputStream inputStream) {
            try {
                return new FramedLZ4CompressorInputStream(inputStream);
            }
            catch (IOException e) {
                throw new CompressionException("Error while creating LZ4 compression input stream", e);
            }
        }

        @Override
        public byte code() {
            return Compression.LZ4.code;
        }

        public String toString() {
            return "LZ4 codec (Commons Compress)";
        }
    }

    public static class CommonsCompressSnappyCompressionCodec
    implements CompressionCodec {
        @Override
        public int maxCompressedLength(int sourceLength) {
            return 32 + sourceLength + sourceLength / 6;
        }

        @Override
        public OutputStream compress(OutputStream outputStream) {
            try {
                return new FramedSnappyCompressorOutputStream(outputStream);
            }
            catch (IOException e) {
                throw new CompressionException("Error while creating Snappy compression output stream", e);
            }
        }

        @Override
        public InputStream decompress(InputStream inputStream) {
            try {
                return new FramedSnappyCompressorInputStream(inputStream, 65536, FramedSnappyDialect.STANDARD);
            }
            catch (IOException e) {
                throw new CompressionException("Error while creating Snappy compression input stream", e);
            }
        }

        @Override
        public byte code() {
            return Compression.SNAPPY.code;
        }

        public String toString() {
            return "Snappy codec (Commons Compress)";
        }
    }

    public static class CommonsCompressGzipCompressionCodec
    implements CompressionCodec {
        @Override
        public int maxCompressedLength(int sourceLength) {
            return sourceLength;
        }

        @Override
        public OutputStream compress(OutputStream outputStream) {
            try {
                return new GzipCompressorOutputStream(outputStream);
            }
            catch (IOException e) {
                throw new CompressionException("Error while creating GZIP compression output stream", e);
            }
        }

        @Override
        public InputStream decompress(InputStream inputStream) {
            try {
                return new GzipCompressorInputStream(inputStream);
            }
            catch (IOException e) {
                throw new CompressionException("Error while creating GZIP compression input stream", e);
            }
        }

        @Override
        public byte code() {
            return Compression.GZIP.code;
        }

        public String toString() {
            return "GZIP codec (Commons Compress)";
        }
    }

    public static class XerialSnappyCompressionCodec
    implements CompressionCodec {
        @Override
        public int maxCompressedLength(int sourceLength) {
            return Snappy.maxCompressedLength((int)sourceLength);
        }

        @Override
        public OutputStream compress(OutputStream outputStream) {
            try {
                return new SnappyFramedOutputStream(outputStream);
            }
            catch (IOException e) {
                throw new CompressionException("Error while creating snappy compression output stream", e);
            }
        }

        @Override
        public InputStream decompress(InputStream inputStream) {
            try {
                return new SnappyFramedInputStream(inputStream);
            }
            catch (IOException e) {
                throw new CompressionException("Error while creating snappy compression input stream", e);
            }
        }

        @Override
        public byte code() {
            return Compression.SNAPPY.code;
        }

        public String toString() {
            return "Snappy codec (xerial)";
        }
    }

    public static class Lz4JavaCompressionCodec
    implements CompressionCodec {
        private static final LZ4FrameOutputStream.FLG.Bits[] DEFAULT_FEATURES = new LZ4FrameOutputStream.FLG.Bits[]{LZ4FrameOutputStream.FLG.Bits.BLOCK_INDEPENDENCE};

        @Override
        public int maxCompressedLength(int sourceLength) {
            return sourceLength + sourceLength / 255 + 16;
        }

        @Override
        public OutputStream compress(OutputStream outputStream) {
            try {
                return new LZ4FrameOutputStream(outputStream, LZ4FrameOutputStream.BLOCKSIZE.SIZE_64KB, DEFAULT_FEATURES);
            }
            catch (IOException e) {
                throw new CompressionException("Error while creating LZ4 compression output stream", e);
            }
        }

        @Override
        public InputStream decompress(InputStream inputStream) {
            try {
                return new LZ4FrameInputStream(inputStream);
            }
            catch (IOException e) {
                throw new CompressionException("Error while creating LZ4 compression input stream", e);
            }
        }

        @Override
        public byte code() {
            return Compression.LZ4.code;
        }

        public String toString() {
            return "LZ4 codec";
        }
    }

    public static class ZstdJniCompressionCodec
    implements CompressionCodec {
        @Override
        public int maxCompressedLength(int sourceLength) {
            return (int)Zstd.compressBound((long)sourceLength);
        }

        @Override
        public OutputStream compress(OutputStream outputStream) {
            try {
                return new ZstdOutputStream(outputStream);
            }
            catch (IOException e) {
                throw new CompressionException("Error while creating Zstd compression output stream", e);
            }
        }

        @Override
        public InputStream decompress(InputStream inputStream) {
            try {
                return new ZstdInputStream(inputStream);
            }
            catch (IOException e) {
                throw new CompressionException("Error while creating Zstd compression input stream", e);
            }
        }

        @Override
        public byte code() {
            return Compression.ZSTD.code;
        }

        public String toString() {
            return "Zstd codec (JNI)";
        }
    }

    public static class GzipCompressionCodec
    implements CompressionCodec {
        @Override
        public int maxCompressedLength(int sourceLength) {
            return sourceLength;
        }

        @Override
        public OutputStream compress(OutputStream outputStream) {
            try {
                return new GZIPOutputStream(outputStream);
            }
            catch (IOException e) {
                throw new CompressionException("Error while creating GZIP compression output stream", e);
            }
        }

        @Override
        public InputStream decompress(InputStream inputStream) {
            try {
                return new GZIPInputStream(inputStream);
            }
            catch (IOException e) {
                throw new CompressionException("Error while creating GZIP compression input stream", e);
            }
        }

        @Override
        public byte code() {
            return Compression.GZIP.code;
        }

        public String toString() {
            return "GZIP codec (JDK)";
        }
    }
}

