/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream.codec;

import com.rabbitmq.stream.Message;
import com.rabbitmq.stream.MessageBuilder;
import com.rabbitmq.stream.Properties;
import com.rabbitmq.stream.amqp.Symbol;
import com.rabbitmq.stream.amqp.UnsignedByte;
import com.rabbitmq.stream.amqp.UnsignedInteger;
import com.rabbitmq.stream.amqp.UnsignedLong;
import com.rabbitmq.stream.amqp.UnsignedShort;
import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public class WrapperMessageBuilder
implements MessageBuilder {
    private boolean hasPublishingId = false;
    private long publishingId = 0L;
    private Object body;
    private WrapperPropertiesBuilder propertiesBuilder;
    private WrapperApplicationPropertiesBuilder applicationPropertiesBuilder;
    private WrapperMessageAnnotationsBuilder messageAnnotationsBuilder;
    private final AtomicBoolean built = new AtomicBoolean(false);

    @Override
    public Message build() {
        if (this.built.compareAndSet(false, true)) {
            return new SimpleMessage(this.hasPublishingId, this.publishingId, this.body, this.messageAnnotationsBuilder == null ? null : this.messageAnnotationsBuilder.messageAnnotations, this.propertiesBuilder == null ? null : this.propertiesBuilder.properties, this.applicationPropertiesBuilder == null ? null : this.applicationPropertiesBuilder.applicationProperties);
        }
        throw new IllegalStateException("A message builder can build only one message");
    }

    @Override
    public MessageBuilder publishingId(long publishingId) {
        this.publishingId = publishingId;
        this.hasPublishingId = true;
        return this;
    }

    @Override
    public MessageBuilder.PropertiesBuilder properties() {
        if (this.propertiesBuilder == null) {
            this.propertiesBuilder = new WrapperPropertiesBuilder(this);
        }
        return this.propertiesBuilder;
    }

    @Override
    public MessageBuilder.ApplicationPropertiesBuilder applicationProperties() {
        if (this.applicationPropertiesBuilder == null) {
            this.applicationPropertiesBuilder = new WrapperApplicationPropertiesBuilder(this);
        }
        return this.applicationPropertiesBuilder;
    }

    @Override
    public MessageBuilder.MessageAnnotationsBuilder messageAnnotations() {
        if (this.messageAnnotationsBuilder == null) {
            this.messageAnnotationsBuilder = new WrapperMessageAnnotationsBuilder(this);
        }
        return this.messageAnnotationsBuilder;
    }

    @Override
    public MessageBuilder addData(byte[] data) {
        this.body = data;
        return this;
    }

    private static class SimpleProperties
    implements Properties {
        private Object messageId;
        private byte[] userId;
        private String to;
        private String subject;
        private String replyTo;
        private Object correlationId;
        private String contentType;
        private String contentEncoding;
        private long absoluteExpiryTime;
        private long creationTime;
        private String groupId;
        private long groupSequence = -1L;
        private String replyToGroupId;

        private SimpleProperties() {
        }

        @Override
        public Object getMessageId() {
            return this.messageId;
        }

        @Override
        public String getMessageIdAsString() {
            return (String)this.messageId;
        }

        @Override
        public long getMessageIdAsLong() {
            return (Long)this.messageId;
        }

        @Override
        public byte[] getMessageIdAsBinary() {
            return (byte[])this.messageId;
        }

        @Override
        public UUID getMessageIdAsUuid() {
            return (UUID)this.messageId;
        }

        @Override
        public byte[] getUserId() {
            return this.userId;
        }

        @Override
        public String getTo() {
            return this.to;
        }

        @Override
        public String getSubject() {
            return this.subject;
        }

        @Override
        public String getReplyTo() {
            return this.replyTo;
        }

        @Override
        public Object getCorrelationId() {
            return this.correlationId;
        }

        @Override
        public String getCorrelationIdAsString() {
            return (String)this.correlationId;
        }

        @Override
        public long getCorrelationIdAsLong() {
            return (Long)this.correlationId;
        }

        @Override
        public byte[] getCorrelationIdAsBinary() {
            return (byte[])this.correlationId;
        }

        @Override
        public UUID getCorrelationIdAsUuid() {
            return (UUID)this.correlationId;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public String getContentEncoding() {
            return this.contentEncoding;
        }

        @Override
        public long getAbsoluteExpiryTime() {
            return this.absoluteExpiryTime;
        }

        @Override
        public long getCreationTime() {
            return this.creationTime;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public long getGroupSequence() {
            return this.groupSequence;
        }

        @Override
        public String getReplyToGroupId() {
            return this.replyToGroupId;
        }

        static /* synthetic */ byte[] access$902(SimpleProperties x0, byte[] x1) {
            x0.userId = x1;
            return x1;
        }
    }

    private static class SimpleMessage
    implements Message {
        private final boolean hasPublishingId;
        private final long publishingId;
        private final Object body;
        private final Map<String, Object> messageAnnotations;
        private final Properties properties;
        private final Map<String, Object> applicationProperties;

        private SimpleMessage(boolean hasPublishingId, long publishingId, Object body, Map<String, Object> messageAnnotations, Properties properties, Map<String, Object> applicationProperties) {
            this.hasPublishingId = hasPublishingId;
            this.publishingId = publishingId;
            this.body = body;
            this.messageAnnotations = messageAnnotations;
            this.properties = properties;
            this.applicationProperties = applicationProperties;
        }

        @Override
        public boolean hasPublishingId() {
            return this.hasPublishingId;
        }

        @Override
        public long getPublishingId() {
            return this.publishingId;
        }

        @Override
        public byte[] getBodyAsBinary() {
            return (byte[])this.body;
        }

        @Override
        public Object getBody() {
            return this.body;
        }

        @Override
        public Properties getProperties() {
            return this.properties;
        }

        @Override
        public Map<String, Object> getApplicationProperties() {
            return this.applicationProperties;
        }

        @Override
        public Map<String, Object> getMessageAnnotations() {
            return this.messageAnnotations;
        }
    }

    private static class WrapperApplicationPropertiesBuilder
    implements MessageBuilder.ApplicationPropertiesBuilder {
        private final MessageBuilder messageBuilder;
        private final Map<String, Object> applicationProperties = new LinkedHashMap<String, Object>();

        private WrapperApplicationPropertiesBuilder(MessageBuilder messageBuilder) {
            this.messageBuilder = messageBuilder;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, boolean value) {
            this.applicationProperties.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, byte value) {
            this.applicationProperties.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, short value) {
            this.applicationProperties.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, int value) {
            this.applicationProperties.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, long value) {
            this.applicationProperties.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryUnsigned(String key, byte value) {
            this.applicationProperties.put(key, new UnsignedByte(value));
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryUnsigned(String key, short value) {
            this.applicationProperties.put(key, new UnsignedShort(value));
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryUnsigned(String key, int value) {
            this.applicationProperties.put(key, new UnsignedInteger(value));
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryUnsigned(String key, long value) {
            this.applicationProperties.put(key, new UnsignedLong(value));
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, float value) {
            this.applicationProperties.put(key, Float.valueOf(value));
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, double value) {
            this.applicationProperties.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryDecimal32(String key, BigDecimal value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryDecimal64(String key, BigDecimal value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryDecimal128(String key, BigDecimal value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, char value) {
            this.applicationProperties.put(key, Character.valueOf(value));
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entryTimestamp(String key, long value) {
            this.applicationProperties.put(key, new Date(value));
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, UUID value) {
            this.applicationProperties.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, byte[] value) {
            this.applicationProperties.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entry(String key, String value) {
            this.applicationProperties.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.ApplicationPropertiesBuilder entrySymbol(String key, String value) {
            this.applicationProperties.put(key, Symbol.valueOf(value));
            return this;
        }

        @Override
        public MessageBuilder messageBuilder() {
            return this.messageBuilder;
        }
    }

    private static class WrapperPropertiesBuilder
    implements MessageBuilder.PropertiesBuilder {
        private final MessageBuilder messageBuilder;
        private final SimpleProperties properties = new SimpleProperties();

        private WrapperPropertiesBuilder(MessageBuilder messageBuilder) {
            this.messageBuilder = messageBuilder;
        }

        @Override
        public MessageBuilder.PropertiesBuilder messageId(String id) {
            this.properties.messageId = id;
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder messageId(long id) {
            this.properties.messageId = id;
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder messageId(byte[] id) {
            this.properties.messageId = id;
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder messageId(UUID id) {
            this.properties.messageId = id;
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder userId(byte[] userId) {
            SimpleProperties.access$902(this.properties, userId);
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder to(String address) {
            this.properties.to = address;
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder subject(String subject) {
            this.properties.subject = subject;
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder replyTo(String replyTo) {
            this.properties.replyTo = replyTo;
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder correlationId(String correlationId) {
            this.properties.correlationId = correlationId;
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder correlationId(long correlationId) {
            this.properties.correlationId = correlationId;
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder correlationId(byte[] correlationId) {
            this.properties.correlationId = correlationId;
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder correlationId(UUID correlationId) {
            this.properties.correlationId = correlationId;
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder contentType(String contentType) {
            this.properties.contentType = contentType;
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder contentEncoding(String contentEncoding) {
            this.properties.contentEncoding = contentEncoding;
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder absoluteExpiryTime(long absoluteExpiryTime) {
            this.properties.absoluteExpiryTime = absoluteExpiryTime;
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder creationTime(long creationTime) {
            this.properties.creationTime = creationTime;
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder groupId(String groupId) {
            this.properties.groupId = groupId;
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder groupSequence(long groupSequence) {
            this.properties.groupSequence = groupSequence;
            return this;
        }

        @Override
        public MessageBuilder.PropertiesBuilder replyToGroupId(String replyToGroupId) {
            this.properties.replyToGroupId = replyToGroupId;
            return this;
        }

        @Override
        public MessageBuilder messageBuilder() {
            return this.messageBuilder;
        }
    }

    private static class WrapperMessageAnnotationsBuilder
    implements MessageBuilder.MessageAnnotationsBuilder {
        private final MessageBuilder messageBuilder;
        private final Map<String, Object> messageAnnotations = new LinkedHashMap<String, Object>();

        private WrapperMessageAnnotationsBuilder(MessageBuilder messageBuilder) {
            this.messageBuilder = messageBuilder;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, boolean value) {
            this.messageAnnotations.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, byte value) {
            this.messageAnnotations.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, short value) {
            this.messageAnnotations.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, int value) {
            this.messageAnnotations.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, long value) {
            this.messageAnnotations.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryUnsigned(String key, byte value) {
            this.messageAnnotations.put(key, new UnsignedByte(value));
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryUnsigned(String key, short value) {
            this.messageAnnotations.put(key, new UnsignedShort(value));
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryUnsigned(String key, int value) {
            this.messageAnnotations.put(key, new UnsignedInteger(value));
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryUnsigned(String key, long value) {
            this.messageAnnotations.put(key, new UnsignedLong(value));
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, float value) {
            this.messageAnnotations.put(key, Float.valueOf(value));
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, double value) {
            this.messageAnnotations.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryDecimal32(String key, BigDecimal value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryDecimal64(String key, BigDecimal value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryDecimal128(String key, BigDecimal value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, char value) {
            this.messageAnnotations.put(key, Character.valueOf(value));
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entryTimestamp(String key, long value) {
            this.messageAnnotations.put(key, new Date(value));
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, UUID value) {
            this.messageAnnotations.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, byte[] value) {
            this.messageAnnotations.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entry(String key, String value) {
            this.messageAnnotations.put(key, value);
            return this;
        }

        @Override
        public MessageBuilder.MessageAnnotationsBuilder entrySymbol(String key, String value) {
            this.messageAnnotations.put(key, Symbol.valueOf(value));
            return this;
        }

        @Override
        public MessageBuilder messageBuilder() {
            return this.messageBuilder;
        }
    }
}

