/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.stream;

import com.rabbitmq.stream.Consumer;
import com.rabbitmq.stream.ConsumerFlowStrategy;
import com.rabbitmq.stream.ConsumerUpdateListener;
import com.rabbitmq.stream.Message;
import com.rabbitmq.stream.MessageHandler;
import com.rabbitmq.stream.OffsetSpecification;
import com.rabbitmq.stream.SubscriptionListener;
import java.time.Duration;
import java.util.function.Predicate;

public interface ConsumerBuilder {
    public ConsumerBuilder stream(String var1);

    public ConsumerBuilder superStream(String var1);

    public ConsumerBuilder offset(OffsetSpecification var1);

    public ConsumerBuilder messageHandler(MessageHandler var1);

    public ConsumerBuilder name(String var1);

    public ConsumerBuilder singleActiveConsumer();

    public ConsumerBuilder consumerUpdateListener(ConsumerUpdateListener var1);

    public ConsumerBuilder subscriptionListener(SubscriptionListener var1);

    public ManualTrackingStrategy manualTrackingStrategy();

    public AutoTrackingStrategy autoTrackingStrategy();

    public ConsumerBuilder noTrackingStrategy();

    public FilterConfiguration filter();

    public FlowConfiguration flow();

    public Consumer build();

    public static interface FilterConfiguration {
        public FilterConfiguration values(String ... var1);

        public FilterConfiguration postFilter(Predicate<Message> var1);

        public FilterConfiguration matchUnfiltered();

        public FilterConfiguration matchUnfiltered(boolean var1);

        public ConsumerBuilder builder();
    }

    public static interface FlowConfiguration {
        public FlowConfiguration initialCredits(int var1);

        public FlowConfiguration strategy(ConsumerFlowStrategy var1);

        public ConsumerBuilder builder();
    }

    public static interface AutoTrackingStrategy {
        public AutoTrackingStrategy messageCountBeforeStorage(int var1);

        public AutoTrackingStrategy flushInterval(Duration var1);

        public ConsumerBuilder builder();
    }

    public static interface ManualTrackingStrategy {
        public ManualTrackingStrategy checkInterval(Duration var1);

        public ConsumerBuilder builder();
    }
}

